/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.node;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.io.NumberOutput;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.node.NumericNode;
import java.math.BigDecimal;
import java.math.BigInteger;

public class IntNode
extends NumericNode {
    static final int MIN_CANONICAL = -1;
    static final int MAX_CANONICAL = 10;
    private static final IntNode[] CANONICALS;
    protected final int _value;

    public IntNode(int n2) {
        this._value = n2;
    }

    public static IntNode valueOf(int n2) {
        if (n2 <= 10 && n2 >= -1) {
            return CANONICALS[n2 - -1];
        }
        return new IntNode(n2);
    }

    static {
        int n2 = 12;
        CANONICALS = new IntNode[12];
        for (int i2 = 0; i2 < n2; ++i2) {
            IntNode intNode;
            IntNode intNode2 = intNode;
            intNode = new IntNode(i2 + -1);
            IntNode.CANONICALS[i2] = intNode2;
        }
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.INT;
    }

    @Override
    public boolean isIntegralNumber() {
        return true;
    }

    @Override
    public boolean isInt() {
        return true;
    }

    @Override
    public boolean canConvertToInt() {
        return true;
    }

    @Override
    public boolean canConvertToLong() {
        return true;
    }

    @Override
    public Number numberValue() {
        return this._value;
    }

    @Override
    public short shortValue() {
        return (short)this._value;
    }

    @Override
    public int intValue() {
        return this._value;
    }

    @Override
    public long longValue() {
        return this._value;
    }

    @Override
    public float floatValue() {
        return this._value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this._value);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this._value);
    }

    @Override
    public String asText() {
        return NumberOutput.toString(this._value);
    }

    @Override
    public boolean asBoolean(boolean bl) {
        return this._value != 0;
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof IntNode) {
            return ((IntNode)object)._value == this._value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._value;
    }
}

