/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.node;

import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.node.ArrayNode;
import com.privatefasterxml.jackson.databind.node.BigIntegerNode;
import com.privatefasterxml.jackson.databind.node.BinaryNode;
import com.privatefasterxml.jackson.databind.node.BooleanNode;
import com.privatefasterxml.jackson.databind.node.DecimalNode;
import com.privatefasterxml.jackson.databind.node.DoubleNode;
import com.privatefasterxml.jackson.databind.node.FloatNode;
import com.privatefasterxml.jackson.databind.node.IntNode;
import com.privatefasterxml.jackson.databind.node.JsonNodeCreator;
import com.privatefasterxml.jackson.databind.node.LongNode;
import com.privatefasterxml.jackson.databind.node.MissingNode;
import com.privatefasterxml.jackson.databind.node.NullNode;
import com.privatefasterxml.jackson.databind.node.NumericNode;
import com.privatefasterxml.jackson.databind.node.ObjectNode;
import com.privatefasterxml.jackson.databind.node.POJONode;
import com.privatefasterxml.jackson.databind.node.ShortNode;
import com.privatefasterxml.jackson.databind.node.TextNode;
import com.privatefasterxml.jackson.databind.node.ValueNode;
import com.privatefasterxml.jackson.databind.util.RawValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonNodeFactory
implements Serializable,
JsonNodeCreator {
    private static final long serialVersionUID = 1L;
    protected static final int MAX_ELEMENT_INDEX_FOR_INSERT = 9999;
    private static final JsonNodeFactory decimalsNormalized = new JsonNodeFactory(false);
    private static final JsonNodeFactory decimalsAsIs = new JsonNodeFactory(true);
    public static final JsonNodeFactory instance = decimalsNormalized;
    private final boolean _cfgBigDecimalExact;

    public JsonNodeFactory(boolean bl) {
        this._cfgBigDecimalExact = bl;
    }

    public JsonNodeFactory() {
        this(false);
    }

    public static JsonNodeFactory withExactBigDecimals(boolean bl) {
        return bl ? decimalsAsIs : decimalsNormalized;
    }

    public int getMaxElementIndexForInsert() {
        return 9999;
    }

    @Override
    public BooleanNode booleanNode(boolean bl) {
        return bl ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    @Override
    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    public JsonNode missingNode() {
        return MissingNode.getInstance();
    }

    @Override
    public NumericNode numberNode(byte by) {
        return IntNode.valueOf(by);
    }

    @Override
    public ValueNode numberNode(Byte by) {
        return by == null ? this.nullNode() : IntNode.valueOf(by.intValue());
    }

    @Override
    public NumericNode numberNode(short s2) {
        return ShortNode.valueOf(s2);
    }

    @Override
    public ValueNode numberNode(Short s2) {
        return s2 == null ? this.nullNode() : ShortNode.valueOf(s2);
    }

    @Override
    public NumericNode numberNode(int n2) {
        return IntNode.valueOf(n2);
    }

    @Override
    public ValueNode numberNode(Integer n2) {
        return n2 == null ? this.nullNode() : IntNode.valueOf(n2);
    }

    @Override
    public NumericNode numberNode(long l2) {
        return LongNode.valueOf(l2);
    }

    @Override
    public ValueNode numberNode(Long l2) {
        if (l2 == null) {
            return this.nullNode();
        }
        return LongNode.valueOf(l2);
    }

    @Override
    public ValueNode numberNode(BigInteger bigInteger) {
        if (bigInteger == null) {
            return this.nullNode();
        }
        return BigIntegerNode.valueOf(bigInteger);
    }

    @Override
    public NumericNode numberNode(float f2) {
        return FloatNode.valueOf(f2);
    }

    @Override
    public ValueNode numberNode(Float f2) {
        return f2 == null ? this.nullNode() : FloatNode.valueOf(f2.floatValue());
    }

    @Override
    public NumericNode numberNode(double d2) {
        return DoubleNode.valueOf(d2);
    }

    @Override
    public ValueNode numberNode(Double d2) {
        return d2 == null ? this.nullNode() : DoubleNode.valueOf(d2);
    }

    @Override
    public ValueNode numberNode(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return this.nullNode();
        }
        if (this._cfgBigDecimalExact) {
            return DecimalNode.valueOf(bigDecimal);
        }
        if (bigDecimal.signum() == 0) {
            return DecimalNode.ZERO;
        }
        try {
            bigDecimal = bigDecimal.stripTrailingZeros();
        }
        catch (ArithmeticException arithmeticException) {}
        return DecimalNode.valueOf(bigDecimal);
    }

    @Override
    public TextNode textNode(String string) {
        return TextNode.valueOf(string);
    }

    @Override
    public BinaryNode binaryNode(byte[] byArray) {
        return BinaryNode.valueOf(byArray);
    }

    @Override
    public BinaryNode binaryNode(byte[] byArray, int n2, int n3) {
        return BinaryNode.valueOf(byArray, n2, n3);
    }

    @Override
    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    @Override
    public ArrayNode arrayNode(int n2) {
        return new ArrayNode(this, n2);
    }

    @Override
    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    @Override
    public ValueNode pojoNode(Object object) {
        return new POJONode(object);
    }

    @Override
    public ValueNode rawValueNode(RawValue rawValue) {
        return new POJONode(rawValue);
    }

    public boolean _inIntRange(long l2) {
        return (long)((int)l2) == l2;
    }
}

