/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.node;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.node.JsonNodeType;
import com.privatefasterxml.jackson.databind.node.ValueNode;

public class NullNode
extends ValueNode {
    private static final long serialVersionUID = 1L;
    public static final NullNode instance = new NullNode();

    public static NullNode getInstance() {
        return instance;
    }

    public Object readResolve() {
        return instance;
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.NULL;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_NULL;
    }

    @Override
    public String asText(String string) {
        return string;
    }

    @Override
    public String asText() {
        return "null";
    }

    public JsonNode requireNonNull() {
        return (JsonNode)this._reportRequiredViolation("requireNonNull() called on `NullNode`", new Object[0]);
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        serializerProvider.defaultSerializeNull(jsonGenerator);
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof NullNode;
    }

    @Override
    public int hashCode() {
        return JsonNodeType.NULL.ordinal();
    }
}

