/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.node;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonPointer;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.type.WritableTypeId;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.cfg.JsonNodeFeature;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.node.ArrayNode;
import com.privatefasterxml.jackson.databind.node.BaseJsonNode;
import com.privatefasterxml.jackson.databind.node.ContainerNode;
import com.privatefasterxml.jackson.databind.node.JsonNodeFactory;
import com.privatefasterxml.jackson.databind.node.JsonNodeType;
import com.privatefasterxml.jackson.databind.node.MissingNode;
import com.privatefasterxml.jackson.databind.util.RawValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObjectNode
extends ContainerNode<ObjectNode>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<String, JsonNode> _children;

    public ObjectNode(JsonNodeFactory jsonNodeFactory) {
        super(jsonNodeFactory);
        LinkedHashMap linkedHashMap;
        Serializable serializable = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        v1._children = serializable;
    }

    public ObjectNode(JsonNodeFactory jsonNodeFactory, Map<String, JsonNode> map) {
        super(jsonNodeFactory);
        this._children = map;
    }

    @Override
    public JsonNode _at(JsonPointer jsonPointer) {
        return this.get(jsonPointer.getMatchingProperty());
    }

    public ObjectNode deepCopy() {
        ObjectNode objectNode;
        ObjectNode objectNode2 = objectNode;
        objectNode = new ObjectNode(((ContainerNode)this)._nodeFactory);
        for (Map.Entry entry : ((ObjectNode)this)._children.entrySet()) {
            objectNode2._children.put((String)entry.getKey(), (JsonNode)((JsonNode)entry.getValue()).deepCopy());
        }
        return objectNode2;
    }

    @Deprecated
    public ObjectNode with(String string) {
        Object object = this._jsonPointerIfValid(string);
        if (object != null) {
            return this.withObject((JsonPointer)object);
        }
        object = this._children.get(string);
        if (object != null) {
            if (object instanceof ObjectNode) {
                return (ObjectNode)object;
            }
            throw new UnsupportedOperationException("Property '" + string + "' has value that is not of type `ObjectNode` (but `" + object.getClass().getName() + "`)");
        }
        object = this.objectNode();
        this._children.put(string, (JsonNode)object);
        return object;
    }

    public ArrayNode withArray(String string) {
        Object object = this._jsonPointerIfValid(string);
        if (object != null) {
            return this.withArray((JsonPointer)object);
        }
        object = this._children.get(string);
        if (object != null) {
            if (object instanceof ArrayNode) {
                return (ArrayNode)object;
            }
            throw new UnsupportedOperationException("Property '" + string + "' has value that is not of type `ArrayNode` (but `" + object.getClass().getName() + "`)");
        }
        object = this.arrayNode();
        this._children.put(string, (JsonNode)object);
        return object;
    }

    @Override
    public ObjectNode _withObject(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode.OverwriteMode overwriteMode, boolean bl) {
        if (jsonPointer2.matches()) {
            return this;
        }
        JsonNode jsonNode = this._at(jsonPointer2);
        if (jsonNode != null && jsonNode instanceof BaseJsonNode) {
            ObjectNode objectNode = ((BaseJsonNode)jsonNode)._withObject(jsonPointer, jsonPointer2.tail(), overwriteMode, bl);
            if (objectNode != null) {
                return objectNode;
            }
            this._withXxxVerifyReplace(jsonPointer, jsonPointer2, overwriteMode, bl, jsonNode);
        }
        return this._withObjectAddTailProperty(jsonPointer2, bl);
    }

    @Override
    public ArrayNode _withArray(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode.OverwriteMode overwriteMode, boolean bl) {
        if (jsonPointer2.matches()) {
            return null;
        }
        JsonNode jsonNode = this._at(jsonPointer2);
        if (jsonNode != null && jsonNode instanceof BaseJsonNode) {
            ArrayNode arrayNode = ((BaseJsonNode)jsonNode)._withArray(jsonPointer, jsonPointer2.tail(), overwriteMode, bl);
            if (arrayNode != null) {
                return arrayNode;
            }
            this._withXxxVerifyReplace(jsonPointer, jsonPointer2, overwriteMode, bl, jsonNode);
        }
        return this._withArrayAddTailProperty(jsonPointer2, bl);
    }

    public ObjectNode _withObjectAddTailProperty(JsonPointer object, boolean bl) {
        JsonPointer jsonPointer = object;
        object = jsonPointer.getMatchingProperty();
        JsonPointer jsonPointer2 = jsonPointer.tail();
        if (jsonPointer2.matches()) {
            return this.putObject((String)object);
        }
        if (bl && jsonPointer2.mayMatchElement()) {
            return this.putArray((String)object)._withObjectAddTailElement(jsonPointer2, bl);
        }
        return this.putObject((String)object)._withObjectAddTailProperty(jsonPointer2, bl);
    }

    public ArrayNode _withArrayAddTailProperty(JsonPointer object, boolean bl) {
        JsonPointer jsonPointer = object;
        object = jsonPointer.getMatchingProperty();
        JsonPointer jsonPointer2 = jsonPointer.tail();
        if (jsonPointer2.matches()) {
            return this.putArray((String)object);
        }
        if (bl && jsonPointer2.mayMatchElement()) {
            return this.putArray((String)object)._withArrayAddTailElement(jsonPointer2, bl);
        }
        return this.putObject((String)object)._withArrayAddTailProperty(jsonPointer2, bl);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.OBJECT;
    }

    @Override
    public final boolean isObject() {
        return true;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public boolean isEmpty() {
        return this._children.isEmpty();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.values().iterator();
    }

    @Override
    public JsonNode get(int n2) {
        return null;
    }

    @Override
    public JsonNode get(String string) {
        return this._children.get(string);
    }

    @Override
    public Iterator<String> fieldNames() {
        return this._children.keySet().iterator();
    }

    @Override
    public JsonNode path(int n2) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(String string) {
        JsonNode jsonNode = jsonNode._children.get(string);
        if (jsonNode != null) {
            return jsonNode;
        }
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode required(String string) {
        JsonNode jsonNode = objectArray3._children.get(string);
        if (jsonNode != null) {
            return jsonNode;
        }
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = string;
        return (JsonNode)objectArray._reportRequiredViolation("No value for property '%s' of `ObjectNode`", objectArray3);
    }

    @Override
    public Iterator<Map.Entry<String, JsonNode>> fields() {
        return this._children.entrySet().iterator();
    }

    @Override
    public boolean equals(Comparator<JsonNode> comparator, JsonNode iterator) {
        if (!(iterator instanceof ObjectNode)) {
            return false;
        }
        ObjectNode objectNode = map;
        Map<String, JsonNode> map = (ObjectNode)((Object)iterator);
        iterator = objectNode._children;
        map = ((ObjectNode)((Object)map))._children;
        if (map.size() != iterator.size()) {
            return false;
        }
        for (Map.Entry entry : iterator.entrySet()) {
            JsonNode jsonNode = (JsonNode)map.get(entry.getKey());
            if (jsonNode != null && ((JsonNode)entry.getValue()).equals(comparator, jsonNode)) continue;
            return false;
        }
        return true;
    }

    @Override
    public JsonNode findValue(String string) {
        for (Map.Entry entry : ((ObjectNode)this)._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                return (JsonNode)entry.getValue();
            }
            JsonNode object = ((JsonNode)entry.getValue()).findValue(string);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String string, List<JsonNode> list) {
        for (Map.Entry entry : ((ObjectNode)this)._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                if (list == null) {
                    ArrayList arrayList;
                    list = arrayList;
                    arrayList = new ArrayList();
                }
                list.add((JsonNode)entry.getValue());
                continue;
            }
            list = ((JsonNode)entry.getValue()).findValues(string, list);
        }
        return list;
    }

    @Override
    public List<String> findValuesAsText(String string, List<String> list) {
        for (Map.Entry entry : ((ObjectNode)this)._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                if (list == null) {
                    ArrayList arrayList;
                    list = arrayList;
                    arrayList = new ArrayList();
                }
                list.add(((JsonNode)entry.getValue()).asText());
                continue;
            }
            list = ((JsonNode)entry.getValue()).findValuesAsText(string, list);
        }
        return list;
    }

    @Override
    public ObjectNode findParent(String string) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                return this;
            }
            if ((entry = entry.getValue().findParent(string)) == null) continue;
            return (ObjectNode)((Object)entry);
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String string, List<JsonNode> list) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                if (list == null) {
                    ArrayList<JsonNode> arrayList;
                    list = arrayList;
                    arrayList = new ArrayList<JsonNode>();
                }
                list.add(this);
                continue;
            }
            list = entry.getValue().findParents(string, list);
        }
        return list;
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (serializerProvider != null) {
            boolean bl = serializerProvider.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS) ^ true;
            boolean bl2 = serializerProvider.isEnabled(JsonNodeFeature.WRITE_NULL_PROPERTIES) ^ true;
            if (bl || bl2) {
                jsonGenerator.writeStartObject(this);
                ((ObjectNode)this).serializeFilteredContents(jsonGenerator, serializerProvider, bl, bl2);
                jsonGenerator.writeEndObject();
                return;
            }
        }
        jsonGenerator.writeStartObject(this);
        for (Map.Entry entry : ((ObjectNode)this)._children.entrySet()) {
            JsonNode jsonNode = (JsonNode)entry.getValue();
            JsonGenerator jsonGenerator2 = jsonGenerator;
            jsonGenerator2.writeFieldName((String)entry.getKey());
            jsonNode.serialize(jsonGenerator2, serializerProvider);
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        boolean entry;
        boolean bl = false;
        boolean bl2 = false;
        if (serializerProvider != null) {
            SerializerProvider serializerProvider2 = serializerProvider;
            entry = serializerProvider2.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS) ^ true;
            bl2 = serializerProvider2.isEnabled(JsonNodeFeature.WRITE_NULL_PROPERTIES) ^ true;
        }
        TypeSerializer typeSerializer2 = typeSerializer;
        WritableTypeId writableTypeId = typeSerializer2.writeTypePrefix(jsonGenerator, typeSerializer2.typeId(this, JsonToken.START_OBJECT));
        if (!entry && !bl2) {
            for (Map.Entry entry2 : ((ObjectNode)this)._children.entrySet()) {
                JsonNode jsonNode = (JsonNode)entry2.getValue();
                JsonGenerator jsonGenerator2 = jsonGenerator;
                jsonGenerator2.writeFieldName((String)entry2.getKey());
                jsonNode.serialize(jsonGenerator2, serializerProvider);
            }
        } else {
            ((ObjectNode)this).serializeFilteredContents(jsonGenerator, serializerProvider, entry, bl2);
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    public void serializeFilteredContents(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, boolean bl, boolean bl2) {
        for (Map.Entry entry : ((ObjectNode)this)._children.entrySet()) {
            BaseJsonNode baseJsonNode = (BaseJsonNode)entry.getValue();
            if (bl && baseJsonNode.isArray() && baseJsonNode.isEmpty(serializerProvider) || bl2 && baseJsonNode.isNull()) continue;
            JsonGenerator jsonGenerator2 = jsonGenerator;
            jsonGenerator2.writeFieldName((String)entry.getKey());
            baseJsonNode.serialize(jsonGenerator2, serializerProvider);
        }
    }

    public <T extends JsonNode> T set(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        ObjectNode objectNode = this;
        objectNode._children.put(string, jsonNode);
        return (T)objectNode;
    }

    public <T extends JsonNode> T setAll(Map<String, ? extends JsonNode> object) {
        for (Map.Entry entry : object.entrySet()) {
            JsonNode jsonNode = (JsonNode)entry.getValue();
            if (jsonNode == null) {
                jsonNode = this.nullNode();
            }
            this._children.put((String)entry.getKey(), jsonNode);
        }
        return (T)this;
    }

    public <T extends JsonNode> T setAll(ObjectNode objectNode) {
        ObjectNode objectNode2 = this;
        objectNode2._children.putAll(objectNode._children);
        return (T)objectNode2;
    }

    public JsonNode replace(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._children.put(string, jsonNode);
    }

    public <T extends JsonNode> T without(String string) {
        ObjectNode objectNode = this;
        objectNode._children.remove(string);
        return (T)objectNode;
    }

    public <T extends JsonNode> T without(Collection<String> collection) {
        ObjectNode objectNode = this;
        objectNode._children.keySet().removeAll(collection);
        return (T)objectNode;
    }

    @Deprecated
    public JsonNode put(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._children.put(string, jsonNode);
    }

    public JsonNode putIfAbsent(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._children.putIfAbsent(string, jsonNode);
    }

    public JsonNode remove(String string) {
        return this._children.remove(string);
    }

    public ObjectNode remove(Collection<String> collection) {
        ObjectNode objectNode = this;
        objectNode._children.keySet().removeAll(collection);
        return objectNode;
    }

    @Override
    public ObjectNode removeAll() {
        ObjectNode objectNode = this;
        objectNode._children.clear();
        return objectNode;
    }

    @Deprecated
    public JsonNode putAll(Map<String, ? extends JsonNode> map) {
        return this.setAll(map);
    }

    @Deprecated
    public JsonNode putAll(ObjectNode objectNode) {
        return this.setAll(objectNode);
    }

    public ObjectNode retain(Collection<String> collection) {
        ObjectNode objectNode = this;
        objectNode._children.keySet().retainAll(collection);
        return objectNode;
    }

    public ObjectNode retain(String ... stringArray) {
        return this.retain(Arrays.asList(stringArray));
    }

    public ArrayNode putArray(String string) {
        ArrayNode arrayNode = this.arrayNode();
        this._put(string, arrayNode);
        return arrayNode;
    }

    public ObjectNode putObject(String string) {
        ObjectNode objectNode = this.objectNode();
        this._put(string, objectNode);
        return objectNode;
    }

    public ObjectNode putPOJO(String string, Object object) {
        return this._put(string, this.pojoNode(object));
    }

    public ObjectNode putRawValue(String string, RawValue rawValue) {
        return this._put(string, this.rawValueNode(rawValue));
    }

    public ObjectNode putNull(String string) {
        ObjectNode objectNode = this;
        objectNode._children.put(string, this.nullNode());
        return objectNode;
    }

    public ObjectNode put(String string, short s2) {
        return this._put(string, this.numberNode(s2));
    }

    public ObjectNode put(String string, Short serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((short)serializable);
        return this._put(string, (JsonNode)((Object)serializable));
    }

    public ObjectNode put(String string, int n2) {
        return this._put(string, this.numberNode(n2));
    }

    public ObjectNode put(String string, Integer serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((int)serializable);
        return this._put(string, (JsonNode)((Object)serializable));
    }

    public ObjectNode put(String string, long l2) {
        return this._put(string, this.numberNode(l2));
    }

    public ObjectNode put(String string, Long serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((long)serializable);
        return this._put(string, (JsonNode)((Object)serializable));
    }

    public ObjectNode put(String string, float f2) {
        return this._put(string, this.numberNode(f2));
    }

    public ObjectNode put(String string, Float serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode(serializable.floatValue());
        return this._put(string, (JsonNode)((Object)serializable));
    }

    public ObjectNode put(String string, double d2) {
        return this._put(string, this.numberNode(d2));
    }

    public ObjectNode put(String string, Double serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((double)serializable);
        return this._put(string, (JsonNode)((Object)serializable));
    }

    public ObjectNode put(String string, BigDecimal serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((BigDecimal)serializable);
        return this._put(string, (JsonNode)((Object)serializable));
    }

    public ObjectNode put(String string, BigInteger serializable) {
        serializable = serializable == null ? this.nullNode() : this.numberNode((BigInteger)serializable);
        return this._put(string, (JsonNode)((Object)serializable));
    }

    public ObjectNode put(String string, String object) {
        object = object == null ? this.nullNode() : this.textNode((String)object);
        return this._put(string, (JsonNode)object);
    }

    public ObjectNode put(String string, boolean bl) {
        return this._put(string, this.booleanNode(bl));
    }

    public ObjectNode put(String string, Boolean serializable) {
        serializable = serializable == null ? this.nullNode() : this.booleanNode((boolean)serializable);
        return this._put(string, (JsonNode)((Object)serializable));
    }

    public ObjectNode put(String string, byte[] object) {
        object = object == null ? (Object)this.nullNode() : (Object)this.binaryNode((byte[])object);
        return this._put(string, (JsonNode)object);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof ObjectNode) {
            return this._childrenEqual((ObjectNode)object);
        }
        return false;
    }

    public boolean _childrenEqual(ObjectNode objectNode) {
        return this._children.equals(objectNode._children);
    }

    @Override
    public int hashCode() {
        return this._children.hashCode();
    }

    public ObjectNode _put(String string, JsonNode jsonNode) {
        ObjectNode objectNode = this;
        objectNode._children.put(string, jsonNode);
        return objectNode;
    }
}

