/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.node;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.databind.JsonSerializable;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.node.JsonNodeType;
import com.privatefasterxml.jackson.databind.node.ValueNode;

public class POJONode
extends ValueNode {
    private static final long serialVersionUID = 2L;
    protected final Object _value;

    public POJONode(Object object) {
        this._value = object;
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.POJO;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    @Override
    public byte[] binaryValue() {
        Object object = this._value;
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        return super.binaryValue();
    }

    @Override
    public String asText() {
        Object object = ((POJONode)object)._value;
        return object == null ? "null" : object.toString();
    }

    @Override
    public String asText(String string) {
        Object object = ((POJONode)object)._value;
        if (object != null) {
            string = object.toString();
        }
        return string;
    }

    @Override
    public boolean asBoolean(boolean bl) {
        Object object = ((POJONode)object)._value;
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return bl;
    }

    @Override
    public int asInt(int n2) {
        Object object = ((POJONode)object)._value;
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return n2;
    }

    @Override
    public long asLong(long l2) {
        Object object = ((POJONode)object)._value;
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return l2;
    }

    @Override
    public double asDouble(double d2) {
        Object object = ((POJONode)object)._value;
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return d2;
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        Object object = ((POJONode)object)._value;
        if (object == null) {
            serializerProvider.defaultSerializeNull(jsonGenerator);
        } else if (object instanceof JsonSerializable) {
            ((JsonSerializable)object).serialize(jsonGenerator, serializerProvider);
        } else {
            serializerProvider.defaultSerializeValue(object, jsonGenerator);
        }
    }

    public Object getPojo() {
        return this._value;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof POJONode) {
            return this._pojoEquals((POJONode)object);
        }
        return false;
    }

    public boolean _pojoEquals(POJONode pOJONode) {
        Object object = ((POJONode)object)._value;
        if (object == null) {
            return pOJONode._value == null;
        }
        return object.equals(pOJONode._value);
    }

    @Override
    public int hashCode() {
        return this._value.hashCode();
    }
}

