/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.node;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.Base64Variants;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.io.CharTypes;
import com.privatefasterxml.jackson.core.io.NumberInput;
import com.privatefasterxml.jackson.core.util.ByteArrayBuilder;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.exc.InvalidFormatException;
import com.privatefasterxml.jackson.databind.node.JsonNodeType;
import com.privatefasterxml.jackson.databind.node.ValueNode;

public class TextNode
extends ValueNode {
    private static final long serialVersionUID = 2L;
    static final TextNode EMPTY_STRING_NODE = new TextNode("");
    protected final String _value;

    public TextNode(String string) {
        this._value = string;
    }

    public static TextNode valueOf(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return EMPTY_STRING_NODE;
        }
        return new TextNode(string);
    }

    @Deprecated
    public static void appendQuoted(StringBuilder stringBuilder, String string) {
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.append('\"');
        CharTypes.appendQuoted(stringBuilder2, string);
        stringBuilder2.append('\"');
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.STRING;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_STRING;
    }

    @Override
    public String textValue() {
        return this._value;
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) {
        Object[] objectArray;
        String string = ((TextNode)((Object)string))._value.trim();
        int n2 = (string.length() >> 2) * 3 + 4;
        Object[] objectArray2 = objectArray;
        objectArray = new ByteArrayBuilder(Math.max(16, Math.min(65536, n2)));
        try {
            base64Variant.decode(string, (ByteArrayBuilder)objectArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray3 = new Object[1];
            objectArray2 = objectArray3;
            objectArray3[0] = illegalArgumentException.getMessage();
            throw InvalidFormatException.from(null, String.format("Cannot access contents of TextNode as binary due to broken Base64 encoding: %s", objectArray2), string, byte[].class);
        }
        return objectArray2.toByteArray();
    }

    @Override
    public byte[] binaryValue() {
        return this.getBinaryValue(Base64Variants.getDefaultVariant());
    }

    @Override
    public String asText() {
        return this._value;
    }

    @Override
    public String asText(String object) {
        String string = ((TextNode)((Object)string))._value;
        if (string != null) {
            object = string;
        }
        return object;
    }

    @Override
    public boolean asBoolean(boolean bl) {
        Object object = ((TextNode)object)._value;
        if (object != null) {
            if ("true".equals(object = ((String)object).trim())) {
                return true;
            }
            if ("false".equals(object)) {
                return false;
            }
        }
        return bl;
    }

    @Override
    public int asInt(int n2) {
        return NumberInput.parseAsInt(this._value, n2);
    }

    @Override
    public long asLong(long l2) {
        return NumberInput.parseAsLong(this._value, l2);
    }

    @Override
    public double asDouble(double d2) {
        return NumberInput.parseAsDouble(this._value, d2);
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        String string = ((TextNode)((Object)string))._value;
        if (string == null) {
            jsonGenerator.writeNull();
        } else {
            jsonGenerator.writeString(string);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof TextNode) {
            return ((TextNode)object)._value.equals(this._value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._value.hashCode();
    }
}

