/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.node;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.JsonLocation;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonStreamContext;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.core.StreamReadCapability;
import com.privatefasterxml.jackson.core.Version;
import com.privatefasterxml.jackson.core.base.ParserMinimalBase;
import com.privatefasterxml.jackson.core.util.JacksonFeatureSet;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.cfg.PackageVersion;
import com.privatefasterxml.jackson.databind.node.BinaryNode;
import com.privatefasterxml.jackson.databind.node.NodeCursor$RootCursor;
import com.privatefasterxml.jackson.databind.node.NumericNode;
import com.privatefasterxml.jackson.databind.node.POJONode;
import com.privatefasterxml.jackson.databind.node.TextNode;
import com.privatefasterxml.jackson.databind.node.d;
import com.privatefasterxml.jackson.databind.node.f;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class TreeTraversingParser
extends ParserMinimalBase {
    protected ObjectCodec _objectCodec;
    protected d _nodeCursor;
    protected boolean _closed;

    public TreeTraversingParser(JsonNode jsonNode) {
        this(jsonNode, null);
    }

    public TreeTraversingParser(JsonNode jsonNode, ObjectCodec objectCodec) {
        super(0);
        NodeCursor$RootCursor nodeCursor$RootCursor;
        ((TreeTraversingParser)((Object)nodeCursor$RootCursor2))._objectCodec = objectCodec;
        NodeCursor$RootCursor nodeCursor$RootCursor2 = nodeCursor$RootCursor;
        nodeCursor$RootCursor = new NodeCursor$RootCursor(jsonNode, null);
        v1._nodeCursor = nodeCursor$RootCursor2;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return JsonParser.DEFAULT_READ_CAPABILITIES;
    }

    @Override
    public void close() {
        if (!this._closed) {
            TreeTraversingParser treeTraversingParser = this;
            treeTraversingParser._closed = true;
            treeTraversingParser._nodeCursor = null;
            treeTraversingParser._currToken = null;
        }
    }

    @Override
    public JsonToken nextToken() {
        JsonToken jsonToken;
        this._currToken = jsonToken = this._nodeCursor.nextToken();
        if (jsonToken == null) {
            this._closed = true;
            return null;
        }
        switch (f.a[jsonToken.ordinal()]) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                this._nodeCursor = this._nodeCursor.getParent();
                break;
            }
            case 2: {
                this._nodeCursor = this._nodeCursor.startArray();
                break;
            }
            case 1: {
                this._nodeCursor = this._nodeCursor.startObject();
            }
        }
        return this._currToken;
    }

    @Override
    public JsonParser skipChildren() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.START_OBJECT) {
            this._nodeCursor = this._nodeCursor.getParent();
            this._currToken = JsonToken.END_OBJECT;
        } else if (jsonToken == JsonToken.START_ARRAY) {
            this._nodeCursor = this._nodeCursor.getParent();
            this._currToken = JsonToken.END_ARRAY;
        }
        return this;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public String getCurrentName() {
        TreeTraversingParser treeTraversingParser = object;
        Object object = treeTraversingParser._nodeCursor;
        JsonToken jsonToken = treeTraversingParser._currToken;
        if (jsonToken == JsonToken.START_OBJECT || jsonToken == JsonToken.START_ARRAY) {
            object = ((d)object).getParent();
        }
        return object == null ? null : ((d)object).getCurrentName();
    }

    @Override
    public void overrideCurrentName(String string) {
        TreeTraversingParser treeTraversingParser = object;
        Object object = treeTraversingParser._nodeCursor;
        JsonToken jsonToken = treeTraversingParser._currToken;
        if (jsonToken == JsonToken.START_OBJECT || jsonToken == JsonToken.START_ARRAY) {
            object = ((d)object).getParent();
        }
        if (object != null) {
            ((d)object).overrideCurrentName(string);
        }
    }

    @Override
    public JsonStreamContext getParsingContext() {
        return this._nodeCursor;
    }

    @Override
    public JsonLocation getTokenLocation() {
        return JsonLocation.NA;
    }

    @Override
    public JsonLocation getCurrentLocation() {
        return JsonLocation.NA;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getText() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == null) {
            return null;
        }
        switch (f.a[jsonToken.ordinal()]) {
            default: {
                return this._currToken.asString();
            }
            case 9: {
                JsonNode jsonNode = this.currentNode();
                if (jsonNode == null || !jsonNode.isBinary()) return this._currToken.asString();
                return jsonNode.asText();
            }
            case 7: 
            case 8: {
                return String.valueOf(this.currentNode().numberValue());
            }
            case 6: {
                return this.currentNode().textValue();
            }
            case 5: 
        }
        return this._nodeCursor.getCurrentName();
    }

    @Override
    public char[] getTextCharacters() {
        return this.getText().toCharArray();
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }

    @Override
    public int getTextOffset() {
        return 0;
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public JsonParser.NumberType getNumberType() {
        return (this = ((TreeTraversingParser)this).currentNumericNode()) == null ? null : this.numberType();
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return this.currentNumericNode().bigIntegerValue();
    }

    @Override
    public BigDecimal getDecimalValue() {
        return this.currentNumericNode().decimalValue();
    }

    @Override
    public double getDoubleValue() {
        return this.currentNumericNode().doubleValue();
    }

    @Override
    public float getFloatValue() {
        return (float)this.currentNumericNode().doubleValue();
    }

    @Override
    public int getIntValue() {
        NumericNode numericNode = (NumericNode)this.currentNumericNode();
        if (!numericNode.canConvertToInt()) {
            this.reportOverflowInt();
        }
        return numericNode.intValue();
    }

    @Override
    public long getLongValue() {
        NumericNode numericNode = (NumericNode)this.currentNumericNode();
        if (!numericNode.canConvertToLong()) {
            this.reportOverflowLong();
        }
        return numericNode.longValue();
    }

    @Override
    public Number getNumberValue() {
        return this.currentNumericNode().numberValue();
    }

    @Override
    public Object getEmbeddedObject() {
        if (!((TreeTraversingParser)this)._closed && (this = ((TreeTraversingParser)this).currentNode()) != null) {
            if (((JsonNode)this).isPojo()) {
                return ((POJONode)this).getPojo();
            }
            if (((JsonNode)this).isBinary()) {
                return ((BinaryNode)this).binaryValue();
            }
        }
        return null;
    }

    @Override
    public boolean isNaN() {
        if (!((TreeTraversingParser)this)._closed && (this = ((TreeTraversingParser)this).currentNode()) instanceof NumericNode) {
            return ((NumericNode)this).isNaN();
        }
        return false;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) {
        if ((this = ((TreeTraversingParser)this).currentNode()) != null) {
            if (this instanceof TextNode) {
                return ((TextNode)this).getBinaryValue(base64Variant);
            }
            return ((JsonNode)this).binaryValue();
        }
        return null;
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) {
        byte[] byArray = ((TreeTraversingParser)object).getBinaryValue(base64Variant);
        Object object = byArray;
        if (byArray != null) {
            Object object2 = object;
            outputStream.write((byte[])object2, 0, ((Object)object2).length);
            return ((Object)object).length;
        }
        return 0;
    }

    public JsonNode currentNode() {
        if (!((TreeTraversingParser)this)._closed && (this = ((TreeTraversingParser)this)._nodeCursor) != null) {
            return ((d)this).currentNode();
        }
        return null;
    }

    public JsonNode currentNumericNode() {
        Object object = this.currentNode();
        if (object != null && object.isNumber()) {
            return object;
        }
        object = object == null ? null : object.asToken();
        throw this._constructError("Current token (" + object + ") not numeric, cannot use numeric value accessors");
    }

    @Override
    public void _handleEOF() {
        this._throwInternal();
    }
}

