/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import com.privatefasterxml.jackson.databind.ser.PropertyFilter;
import com.privatefasterxml.jackson.databind.ser.std.MapSerializer;
import java.util.Map;

public class AnyGetterWriter {
    protected final BeanProperty _property;
    protected final AnnotatedMember _accessor;
    protected JsonSerializer<Object> _serializer;
    protected MapSerializer _mapSerializer;

    public AnyGetterWriter(BeanProperty beanProperty, AnnotatedMember annotatedMember, JsonSerializer<?> jsonSerializer) {
        this._accessor = annotatedMember;
        this._property = beanProperty;
        this._serializer = jsonSerializer;
        if (jsonSerializer instanceof MapSerializer) {
            this._mapSerializer = (MapSerializer)jsonSerializer;
        }
    }

    public void fixAccess(SerializationConfig serializationConfig) {
        this._accessor.fixAccess(serializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    public void getAndSerialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        Object[] objectArray;
        if ((object = this._accessor.getValue(object)) == null) {
            return;
        }
        if (!(object instanceof Map)) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = this._accessor.getName();
            objectArray2[1] = object.getClass().getName();
            serializerProvider.reportBadDefinition(this._property.getType(), String.format("Value returned by 'any-getter' %s() not java.util.Map but %s", objectArray));
        }
        objectArray = this._mapSerializer;
        if (this._mapSerializer != null) {
            objectArray.serializeWithoutTypeInfo((Map)object, jsonGenerator, serializerProvider);
            return;
        }
        this._serializer.serialize(object, jsonGenerator, serializerProvider);
    }

    public void getAndFilter(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, PropertyFilter propertyFilter) {
        Object[] objectArray;
        Object object2 = ((AnyGetterWriter)((Object)map))._accessor.getValue(object);
        if (object2 == null) {
            return;
        }
        if (!(object2 instanceof Map)) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = ((AnyGetterWriter)((Object)map))._accessor.getName();
            objectArray2[1] = object2.getClass().getName();
            serializerProvider.reportBadDefinition(((AnyGetterWriter)((Object)map))._property.getType(), String.format("Value returned by 'any-getter' (%s()) not java.util.Map but %s", objectArray));
        }
        objectArray = ((AnyGetterWriter)((Object)map))._mapSerializer;
        if (((AnyGetterWriter)((Object)map))._mapSerializer != null) {
            Map map = (Map)object2;
            objectArray.serializeFilteredAnyProperties(serializerProvider, jsonGenerator, object, map, propertyFilter, null);
            return;
        }
        ((AnyGetterWriter)((Object)map))._serializer.serialize(object2, jsonGenerator, serializerProvider);
    }

    public void resolve(SerializerProvider object) {
        JsonSerializer<Object> jsonSerializer = this._serializer;
        if (jsonSerializer instanceof ContextualSerializer) {
            object = ((SerializerProvider)object).handlePrimaryContextualization(jsonSerializer, this._property);
            this._serializer = object;
            if (object instanceof MapSerializer) {
                this._mapSerializer = (MapSerializer)object;
            }
        }
    }
}

