/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser;

import com.privatefasterxml.jackson.annotation.JsonInclude;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.core.io.SerializedString;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.PropertyMetadata;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedField;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.privatefasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.privatefasterxml.jackson.databind.jsonschema.JsonSchema;
import com.privatefasterxml.jackson.databind.jsonschema.SchemaAware;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.node.ObjectNode;
import com.privatefasterxml.jackson.databind.ser.PropertyWriter;
import com.privatefasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.privatefasterxml.jackson.databind.ser.impl.UnwrappingBeanPropertyWriter;
import com.privatefasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.privatefasterxml.jackson.databind.util.Annotations;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.NameTransformer;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;

@JacksonStdImpl
public class BeanPropertyWriter
extends PropertyWriter
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Object MARKER_FOR_EMPTY = JsonInclude.Include.NON_EMPTY;
    protected final SerializedString _name;
    protected final PropertyName _wrapperName;
    protected final JavaType _declaredType;
    protected final JavaType _cfgSerializationType;
    protected JavaType _nonTrivialBaseType;
    protected final transient Annotations _contextAnnotations;
    protected final AnnotatedMember _member;
    protected transient Method _accessorMethod;
    protected transient Field _field;
    protected JsonSerializer<Object> _serializer;
    protected JsonSerializer<Object> _nullSerializer;
    protected TypeSerializer _typeSerializer;
    protected transient PropertySerializerMap _dynamicSerializers;
    protected final boolean _suppressNulls;
    protected final Object _suppressableValue;
    protected final Class<?>[] _includeInViews;
    protected transient HashMap<Object, Object> _internalSettings;

    public BeanPropertyWriter(BeanPropertyDefinition object, AnnotatedMember annotatedMember, Annotations annotations, JavaType javaType, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, JavaType javaType2, boolean bl, Object object2, Class<?>[] classArray) {
        BeanPropertyWriter beanPropertyWriter = this;
        super((BeanPropertyDefinition)object);
        this._member = annotatedMember;
        beanPropertyWriter._contextAnnotations = annotations;
        beanPropertyWriter._name = new SerializedString(((BeanPropertyDefinition)object).getName());
        this._wrapperName = ((BeanPropertyDefinition)object).getWrapperName();
        this._declaredType = javaType;
        this._serializer = jsonSerializer;
        object = jsonSerializer == null ? PropertySerializerMap.emptyForProperties() : null;
        this._dynamicSerializers = object;
        this._typeSerializer = typeSerializer;
        this._cfgSerializationType = javaType2;
        if (annotatedMember instanceof AnnotatedField) {
            this._accessorMethod = null;
            this._field = (Field)annotatedMember.getMember();
        } else if (annotatedMember instanceof AnnotatedMethod) {
            BeanPropertyWriter beanPropertyWriter2 = this;
            beanPropertyWriter2._accessorMethod = (Method)annotatedMember.getMember();
            beanPropertyWriter2._field = null;
        } else {
            BeanPropertyWriter beanPropertyWriter3 = this;
            beanPropertyWriter3._accessorMethod = null;
            beanPropertyWriter3._field = null;
        }
        BeanPropertyWriter beanPropertyWriter4 = this;
        beanPropertyWriter4._suppressNulls = bl;
        beanPropertyWriter4._suppressableValue = object2;
        beanPropertyWriter4._nullSerializer = null;
        beanPropertyWriter4._includeInViews = classArray;
    }

    @Deprecated
    public BeanPropertyWriter(BeanPropertyDefinition beanPropertyDefinition, AnnotatedMember annotatedMember, Annotations annotations, JavaType javaType, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, JavaType javaType2, boolean bl, Object object) {
        this(beanPropertyDefinition, annotatedMember, annotations, javaType, jsonSerializer, typeSerializer, javaType2, bl, object, null);
    }

    public BeanPropertyWriter() {
        super(PropertyMetadata.STD_REQUIRED_OR_OPTIONAL);
        this._member = null;
        this._contextAnnotations = null;
        this._name = null;
        this._wrapperName = null;
        this._includeInViews = null;
        this._declaredType = null;
        this._serializer = null;
        this._dynamicSerializers = null;
        this._typeSerializer = null;
        this._cfgSerializationType = null;
        this._accessorMethod = null;
        this._field = null;
        this._suppressNulls = false;
        this._suppressableValue = null;
        this._nullSerializer = null;
    }

    public BeanPropertyWriter(BeanPropertyWriter beanPropertyWriter) {
        this(beanPropertyWriter, beanPropertyWriter._name);
    }

    public BeanPropertyWriter(BeanPropertyWriter beanPropertyWriter, PropertyName propertyName) {
        super(beanPropertyWriter);
        this._name = new SerializedString(propertyName.getSimpleName());
        this._wrapperName = beanPropertyWriter._wrapperName;
        this._contextAnnotations = beanPropertyWriter._contextAnnotations;
        this._declaredType = beanPropertyWriter._declaredType;
        this._member = beanPropertyWriter._member;
        this._accessorMethod = beanPropertyWriter._accessorMethod;
        this._field = beanPropertyWriter._field;
        this._serializer = beanPropertyWriter._serializer;
        this._nullSerializer = beanPropertyWriter._nullSerializer;
        if (beanPropertyWriter._internalSettings != null) {
            this._internalSettings = new HashMap<Object, Object>(beanPropertyWriter._internalSettings);
        }
        this._cfgSerializationType = beanPropertyWriter._cfgSerializationType;
        this._dynamicSerializers = beanPropertyWriter._dynamicSerializers;
        this._suppressNulls = beanPropertyWriter._suppressNulls;
        this._suppressableValue = beanPropertyWriter._suppressableValue;
        this._includeInViews = beanPropertyWriter._includeInViews;
        this._typeSerializer = beanPropertyWriter._typeSerializer;
        this._nonTrivialBaseType = beanPropertyWriter._nonTrivialBaseType;
    }

    public BeanPropertyWriter(BeanPropertyWriter beanPropertyWriter, SerializedString serializedString) {
        super(beanPropertyWriter);
        this._name = serializedString;
        this._wrapperName = beanPropertyWriter._wrapperName;
        this._member = beanPropertyWriter._member;
        this._contextAnnotations = beanPropertyWriter._contextAnnotations;
        this._declaredType = beanPropertyWriter._declaredType;
        this._accessorMethod = beanPropertyWriter._accessorMethod;
        this._field = beanPropertyWriter._field;
        this._serializer = beanPropertyWriter._serializer;
        this._nullSerializer = beanPropertyWriter._nullSerializer;
        if (beanPropertyWriter._internalSettings != null) {
            this._internalSettings = new HashMap<Object, Object>(beanPropertyWriter._internalSettings);
        }
        this._cfgSerializationType = beanPropertyWriter._cfgSerializationType;
        this._dynamicSerializers = beanPropertyWriter._dynamicSerializers;
        this._suppressNulls = beanPropertyWriter._suppressNulls;
        this._suppressableValue = beanPropertyWriter._suppressableValue;
        this._includeInViews = beanPropertyWriter._includeInViews;
        this._typeSerializer = beanPropertyWriter._typeSerializer;
        this._nonTrivialBaseType = beanPropertyWriter._nonTrivialBaseType;
    }

    public BeanPropertyWriter rename(NameTransformer object) {
        if (((String)(object = ((NameTransformer)object).transform(this._name.getValue()))).equals(this._name.toString())) {
            return this;
        }
        return this._new(PropertyName.construct((String)object));
    }

    public BeanPropertyWriter _new(PropertyName propertyName) {
        return new BeanPropertyWriter(this, propertyName);
    }

    public void assignTypeSerializer(TypeSerializer typeSerializer) {
        this._typeSerializer = typeSerializer;
    }

    public void assignSerializer(JsonSerializer<Object> jsonSerializer) {
        Object[] objectArray = this._serializer;
        if (this._serializer != null && objectArray != jsonSerializer) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = ClassUtil.classNameOf(this._serializer);
            objectArray2[1] = ClassUtil.classNameOf(jsonSerializer);
            throw new IllegalStateException(String.format("Cannot override _serializer: had a %s, trying to set to %s", objectArray));
        }
        this._serializer = jsonSerializer;
    }

    public void assignNullSerializer(JsonSerializer<Object> jsonSerializer) {
        Object[] objectArray = this._nullSerializer;
        if (this._nullSerializer != null && objectArray != jsonSerializer) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = ClassUtil.classNameOf(this._nullSerializer);
            objectArray2[1] = ClassUtil.classNameOf(jsonSerializer);
            throw new IllegalStateException(String.format("Cannot override _nullSerializer: had a %s, trying to set to %s", objectArray));
        }
        this._nullSerializer = jsonSerializer;
    }

    public BeanPropertyWriter unwrappingWriter(NameTransformer nameTransformer) {
        return new UnwrappingBeanPropertyWriter(this, nameTransformer);
    }

    public void setNonTrivialBaseType(JavaType javaType) {
        this._nonTrivialBaseType = javaType;
    }

    public void fixAccess(SerializationConfig serializationConfig) {
        this._member.fixAccess(serializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    public Object readResolve() {
        AnnotatedMember annotatedMember = this._member;
        if (annotatedMember instanceof AnnotatedField) {
            this._accessorMethod = null;
            this._field = (Field)annotatedMember.getMember();
        } else if (annotatedMember instanceof AnnotatedMethod) {
            BeanPropertyWriter beanPropertyWriter = this;
            beanPropertyWriter._accessorMethod = (Method)annotatedMember.getMember();
            beanPropertyWriter._field = null;
        }
        if (this._serializer == null) {
            this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
        }
        return this;
    }

    @Override
    public String getName() {
        return this._name.getValue();
    }

    @Override
    public PropertyName getFullName() {
        return new PropertyName(this._name.getValue());
    }

    @Override
    public JavaType getType() {
        return this._declaredType;
    }

    @Override
    public PropertyName getWrapperName() {
        return this._wrapperName;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        Serializable serializable = ((BeanPropertyWriter)serializable)._member;
        return serializable == null ? null : (A)((AnnotatedMember)serializable).getAnnotation(clazz);
    }

    @Override
    public <A extends Annotation> A getContextAnnotation(Class<A> clazz) {
        Annotations annotations = ((BeanPropertyWriter)((Object)annotations))._contextAnnotations;
        return annotations == null ? null : (A)annotations.get(clazz);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._member;
    }

    public void _depositSchemaProperty(ObjectNode objectNode, JsonNode jsonNode) {
        objectNode.set(this.getName(), jsonNode);
    }

    public Object getInternalSetting(Object object) {
        Serializable serializable = ((BeanPropertyWriter)serializable)._internalSettings;
        return serializable == null ? null : ((HashMap)serializable).get(object);
    }

    public Object setInternalSetting(Object object, Object object2) {
        if (this._internalSettings == null) {
            HashMap hashMap;
            HashMap hashMap2 = hashMap;
            hashMap = new HashMap();
            this._internalSettings = hashMap2;
        }
        return this._internalSettings.put(object, object2);
    }

    public Object removeInternalSetting(Object object) {
        Object object2 = null;
        HashMap<Object, Object> hashMap = this._internalSettings;
        if (hashMap != null) {
            object2 = hashMap.remove(object);
            if (this._internalSettings.size() == 0) {
                this._internalSettings = null;
            }
        }
        return object2;
    }

    public SerializableString getSerializedName() {
        return this._name;
    }

    public boolean hasSerializer() {
        return this._serializer != null;
    }

    public boolean hasNullSerializer() {
        return this._nullSerializer != null;
    }

    public TypeSerializer getTypeSerializer() {
        return this._typeSerializer;
    }

    public boolean isUnwrapping() {
        return false;
    }

    public boolean willSuppressNulls() {
        return this._suppressNulls;
    }

    public boolean wouldConflictWithName(PropertyName propertyName) {
        PropertyName propertyName2 = this._wrapperName;
        if (propertyName2 != null) {
            return propertyName2.equals(propertyName);
        }
        return propertyName.hasSimpleName(this._name.getValue()) && !propertyName.hasNamespace();
    }

    public JsonSerializer<Object> getSerializer() {
        return this._serializer;
    }

    public JavaType getSerializationType() {
        return this._cfgSerializationType;
    }

    @Deprecated
    public Class<?> getRawSerializationType() {
        Serializable serializable = ((BeanPropertyWriter)serializable)._cfgSerializationType;
        return serializable == null ? null : ((JavaType)serializable).getRawClass();
    }

    @Deprecated
    public Class<?> getPropertyType() {
        Method method = ((BeanPropertyWriter)((Object)field))._accessorMethod;
        if (method != null) {
            return method.getReturnType();
        }
        Field field = ((BeanPropertyWriter)((Object)field))._field;
        if (field != null) {
            return field.getType();
        }
        return null;
    }

    @Deprecated
    public Type getGenericPropertyType() {
        Method method = ((BeanPropertyWriter)((Object)field))._accessorMethod;
        if (method != null) {
            return method.getGenericReturnType();
        }
        Field field = ((BeanPropertyWriter)((Object)field))._field;
        if (field != null) {
            return field.getGenericType();
        }
        return null;
    }

    public Class<?>[] getViews() {
        return this._includeInViews;
    }

    @Override
    public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        Object object2;
        Object object3 = ((BeanPropertyWriter)((Object)typeSerializer))._accessorMethod;
        object3 = object3 == null ? ((BeanPropertyWriter)((Object)typeSerializer))._field.get(object) : ((Method)object3).invoke(object, null);
        if (object3 == null) {
            object = ((BeanPropertyWriter)((Object)typeSerializer))._suppressableValue;
            if (object != null && serializerProvider.includeFilterSuppressNulls(object)) {
                return;
            }
            if (((BeanPropertyWriter)((Object)typeSerializer))._nullSerializer != null) {
                jsonGenerator.writeFieldName(((BeanPropertyWriter)((Object)typeSerializer))._name);
                ((BeanPropertyWriter)((Object)typeSerializer))._nullSerializer.serialize(null, jsonGenerator, serializerProvider);
            }
            return;
        }
        Object object4 = ((BeanPropertyWriter)((Object)typeSerializer))._serializer;
        if (object4 == null) {
            object2 = ((BeanPropertyWriter)((Object)typeSerializer))._dynamicSerializers;
            object4 = object3.getClass();
            JsonSerializer<Object> jsonSerializer = ((PropertySerializerMap)object2).serializerFor((Class<?>)object4);
            object4 = jsonSerializer == null ? ((BeanPropertyWriter)((Object)typeSerializer))._findAndAddDynamic((PropertySerializerMap)object2, (Class<?>)object4, serializerProvider) : jsonSerializer;
        }
        if ((object2 = ((BeanPropertyWriter)((Object)typeSerializer))._suppressableValue) != null && (MARKER_FOR_EMPTY == object2 ? ((JsonSerializer)object4).isEmpty(serializerProvider, object3) : object2.equals(object3))) {
            return;
        }
        if (object3 == object && ((BeanPropertyWriter)((Object)typeSerializer))._handleSelfReference(object, jsonGenerator, serializerProvider, (JsonSerializer<?>)object4)) {
            return;
        }
        jsonGenerator.writeFieldName(((BeanPropertyWriter)((Object)typeSerializer))._name);
        TypeSerializer typeSerializer = ((BeanPropertyWriter)((Object)typeSerializer))._typeSerializer;
        if (typeSerializer == null) {
            ((JsonSerializer)object4).serialize((Object)object3, jsonGenerator, serializerProvider);
        } else {
            ((JsonSerializer)object4).serializeWithType((Object)object3, jsonGenerator, serializerProvider, typeSerializer);
        }
    }

    @Override
    public void serializeAsOmittedField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (!jsonGenerator.canOmitFields()) {
            jsonGenerator.writeOmittedField(this._name.getValue());
        }
    }

    @Override
    public void serializeAsElement(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        Object object2;
        Object object3;
        Object object4 = ((BeanPropertyWriter)object3)._accessorMethod;
        object4 = object4 == null ? ((BeanPropertyWriter)object3)._field.get(object) : ((Method)object4).invoke(object, null);
        if (object4 == null) {
            object3 = ((BeanPropertyWriter)object3)._nullSerializer;
            if (object3 != null) {
                ((JsonSerializer)object3).serialize(null, jsonGenerator, serializerProvider);
            } else {
                jsonGenerator.writeNull();
            }
            return;
        }
        Object object5 = ((BeanPropertyWriter)object3)._serializer;
        if (object5 == null) {
            object2 = ((BeanPropertyWriter)object3)._dynamicSerializers;
            object5 = object4.getClass();
            JsonSerializer<Object> jsonSerializer = ((PropertySerializerMap)object2).serializerFor((Class<?>)object5);
            object5 = jsonSerializer == null ? ((BeanPropertyWriter)object3)._findAndAddDynamic((PropertySerializerMap)object2, (Class<?>)object5, serializerProvider) : jsonSerializer;
        }
        if ((object2 = ((BeanPropertyWriter)object3)._suppressableValue) != null) {
            if (MARKER_FOR_EMPTY == object2) {
                if (((JsonSerializer)object5).isEmpty(serializerProvider, object4)) {
                    ((BeanPropertyWriter)object3).serializeAsPlaceholder(object, jsonGenerator, serializerProvider);
                    return;
                }
            } else if (object2.equals(object4)) {
                ((BeanPropertyWriter)object3).serializeAsPlaceholder(object, jsonGenerator, serializerProvider);
                return;
            }
        }
        if (object4 == object && ((BeanPropertyWriter)object3)._handleSelfReference(object, jsonGenerator, serializerProvider, (JsonSerializer<?>)object5)) {
            return;
        }
        object3 = ((BeanPropertyWriter)object3)._typeSerializer;
        if (object3 == null) {
            ((JsonSerializer)object5).serialize((Object)object4, jsonGenerator, serializerProvider);
        } else {
            ((JsonSerializer)object5).serializeWithType((Object)object4, jsonGenerator, serializerProvider, (TypeSerializer)object3);
        }
    }

    @Override
    public void serializeAsPlaceholder(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        JsonSerializer<Object> jsonSerializer = ((BeanPropertyWriter)((Object)jsonSerializer))._nullSerializer;
        if (jsonSerializer != null) {
            jsonSerializer.serialize(null, jsonGenerator, serializerProvider);
        } else {
            jsonGenerator.writeNull();
        }
    }

    @Override
    public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) {
        if (jsonObjectFormatVisitor != null) {
            if (this.isRequired()) {
                jsonObjectFormatVisitor.property(this);
            } else {
                jsonObjectFormatVisitor.optionalProperty(this);
            }
        }
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(ObjectNode objectNode, SerializerProvider object) {
        Type type = this.getSerializationType();
        type = type == null ? this.getType() : type.getRawClass();
        JsonSerializer<Object> jsonSerializer = this.getSerializer();
        if (jsonSerializer == null) {
            jsonSerializer = ((SerializerProvider)object).findValueSerializer(this.getType(), (BeanProperty)this);
        }
        boolean bl = this.isRequired() ^ true;
        object = jsonSerializer instanceof SchemaAware ? ((SchemaAware)((Object)jsonSerializer)).getSchema((SerializerProvider)object, type, bl) : JsonSchema.getDefaultSchemaNode();
        this._depositSchemaProperty(objectNode, (JsonNode)object);
    }

    public JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class<?> object, SerializerProvider serializerProvider) {
        JavaType javaType = this._nonTrivialBaseType;
        object = javaType != null ? propertySerializerMap.findAndAddPrimarySerializer(serializerProvider.constructSpecializedType(javaType, (Class<?>)object), serializerProvider, (BeanProperty)this) : propertySerializerMap.findAndAddPrimarySerializer((Class<?>)object, serializerProvider, (BeanProperty)this);
        if (propertySerializerMap != (propertySerializerMap = ((PropertySerializerMap.SerializerAndMapResult)object).map)) {
            this._dynamicSerializers = propertySerializerMap;
        }
        return ((PropertySerializerMap.SerializerAndMapResult)object).serializer;
    }

    public final Object get(Object object) {
        Method method = this._accessorMethod;
        return method == null ? this._field.get(object) : method.invoke(object, null);
    }

    public boolean _handleSelfReference(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<?> jsonSerializer) {
        if (!jsonSerializer.usesObjectId()) {
            if (serializerProvider.isEnabled(SerializationFeature.FAIL_ON_SELF_REFERENCES)) {
                if (jsonSerializer instanceof BeanSerializerBase) {
                    serializerProvider.reportBadDefinition(this.getType(), "Direct self-reference leading to cycle");
                }
            } else if (serializerProvider.isEnabled(SerializationFeature.WRITE_SELF_REFERENCES_AS_NULL)) {
                if (this._nullSerializer != null) {
                    if (!jsonGenerator.getOutputContext().inArray()) {
                        jsonGenerator.writeFieldName(this._name);
                    }
                    this._nullSerializer.serialize(null, jsonGenerator, serializerProvider);
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder(40).append("property '").append(((BeanPropertyWriter)((Object)jsonSerializer)).getName()).append("' (");
        if (((BeanPropertyWriter)((Object)jsonSerializer))._accessorMethod != null) {
            stringBuilder2.append("via method ").append(((BeanPropertyWriter)((Object)jsonSerializer))._accessorMethod.getDeclaringClass().getName()).append("#").append(((BeanPropertyWriter)((Object)jsonSerializer))._accessorMethod.getName());
        } else if (((BeanPropertyWriter)((Object)jsonSerializer))._field != null) {
            stringBuilder2.append("field \"").append(((BeanPropertyWriter)((Object)jsonSerializer))._field.getDeclaringClass().getName()).append("#").append(((BeanPropertyWriter)((Object)jsonSerializer))._field.getName());
        } else {
            stringBuilder2.append("virtual");
        }
        JsonSerializer<Object> jsonSerializer = ((BeanPropertyWriter)((Object)jsonSerializer))._serializer;
        if (jsonSerializer == null) {
            stringBuilder2.append(", no static serializer");
        } else {
            stringBuilder2.append(", static serializer of type ".concat(jsonSerializer.getClass().getName()));
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(')');
        return stringBuilder3.toString();
    }
}

