/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser;

import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedClass;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.ser.AnyGetterWriter;
import com.privatefasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.privatefasterxml.jackson.databind.ser.BeanSerializer;
import com.privatefasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import java.util.Collections;
import java.util.List;

public class BeanSerializerBuilder {
    private static final BeanPropertyWriter[] NO_PROPERTIES = new BeanPropertyWriter[0];
    protected final BeanDescription _beanDesc;
    protected SerializationConfig _config;
    protected List<BeanPropertyWriter> _properties = Collections.emptyList();
    protected BeanPropertyWriter[] _filteredProperties;
    protected AnyGetterWriter _anyGetter;
    protected Object _filterId;
    protected AnnotatedMember _typeId;
    protected ObjectIdWriter _objectIdWriter;

    public BeanSerializerBuilder(BeanDescription beanDescription) {
        this._beanDesc = beanDescription;
    }

    public BeanSerializerBuilder(BeanSerializerBuilder beanSerializerBuilder) {
        this._beanDesc = beanSerializerBuilder._beanDesc;
        this._properties = beanSerializerBuilder._properties;
        this._filteredProperties = beanSerializerBuilder._filteredProperties;
        this._anyGetter = beanSerializerBuilder._anyGetter;
        this._filterId = beanSerializerBuilder._filterId;
    }

    public void setConfig(SerializationConfig serializationConfig) {
        this._config = serializationConfig;
    }

    public void setProperties(List<BeanPropertyWriter> list) {
        this._properties = list;
    }

    public void setFilteredProperties(BeanPropertyWriter[] beanPropertyWriterArray) {
        if (beanPropertyWriterArray != null && beanPropertyWriterArray.length != this._properties.size()) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = beanPropertyWriterArray.length;
            objectArray[1] = this._properties.size();
            throw new IllegalArgumentException(String.format("Trying to set %d filtered properties; must match length of non-filtered `properties` (%d)", objectArray2));
        }
        this._filteredProperties = beanPropertyWriterArray;
    }

    public void setAnyGetter(AnyGetterWriter anyGetterWriter) {
        this._anyGetter = anyGetterWriter;
    }

    public void setFilterId(Object object) {
        this._filterId = object;
    }

    public void setTypeId(AnnotatedMember annotatedMember) {
        if (this._typeId == null) {
            this._typeId = annotatedMember;
            return;
        }
        throw new IllegalArgumentException("Multiple type ids specified with " + this._typeId + " and " + annotatedMember);
    }

    public void setObjectIdWriter(ObjectIdWriter objectIdWriter) {
        this._objectIdWriter = objectIdWriter;
    }

    public AnnotatedClass getClassInfo() {
        return this._beanDesc.getClassInfo();
    }

    public BeanDescription getBeanDescription() {
        return this._beanDesc;
    }

    public List<BeanPropertyWriter> getProperties() {
        return this._properties;
    }

    public boolean hasProperties() {
        List<BeanPropertyWriter> list = ((BeanSerializerBuilder)((Object)list))._properties;
        return list != null && list.size() > 0;
    }

    public BeanPropertyWriter[] getFilteredProperties() {
        return this._filteredProperties;
    }

    public AnyGetterWriter getAnyGetter() {
        return this._anyGetter;
    }

    public Object getFilterId() {
        return this._filterId;
    }

    public AnnotatedMember getTypeId() {
        return this._typeId;
    }

    public ObjectIdWriter getObjectIdWriter() {
        return this._objectIdWriter;
    }

    public JsonSerializer<?> build() {
        Object[] objectArray;
        if (this._typeId != null && this._config.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            this._typeId.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        if ((objectArray = this._anyGetter) != null) {
            objectArray.fixAccess(this._config);
        }
        if ((objectArray = this._properties) != null && !objectArray.isEmpty()) {
            BeanSerializerBuilder beanSerializerBuilder = this;
            List<BeanPropertyWriter> list = beanSerializerBuilder._properties;
            objectArray = list.toArray(new BeanPropertyWriter[list.size()]);
            if (beanSerializerBuilder._config.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
                int n2 = objectArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    ((BeanPropertyWriter)objectArray[i2]).fixAccess(this._config);
                }
            }
        } else {
            if (this._anyGetter == null && this._objectIdWriter == null) {
                return null;
            }
            objectArray = NO_PROPERTIES;
        }
        Object object = this._filteredProperties;
        if (this._filteredProperties != null && ((BeanPropertyWriter[])object).length != this._properties.size()) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = this._properties.size();
            objectArray2[1] = this._filteredProperties.length;
            throw new IllegalStateException(String.format("Mismatch between `properties` size (%d), `filteredProperties` (%s): should have as many (or `null` for latter)", objectArray));
        }
        BeanSerializerBuilder beanSerializerBuilder = this;
        object = beanSerializerBuilder._beanDesc.getType();
        BeanPropertyWriter[] beanPropertyWriterArray = beanSerializerBuilder._filteredProperties;
        return new BeanSerializer((JavaType)object, this, (BeanPropertyWriter[])objectArray, beanPropertyWriterArray);
    }

    public BeanSerializer createDummy() {
        return BeanSerializer.createDummy(this._beanDesc.getType(), this);
    }
}

