/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser;

import com.privatefasterxml.jackson.annotation.JsonIgnoreProperties;
import com.privatefasterxml.jackson.annotation.JsonIncludeProperties;
import com.privatefasterxml.jackson.annotation.JsonTypeInfo;
import com.privatefasterxml.jackson.annotation.ObjectIdGenerator;
import com.privatefasterxml.jackson.annotation.ObjectIdGenerators;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.TokenStreamFactory;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DatabindContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.ObjectMapper;
import com.privatefasterxml.jackson.databind.ObjectReader;
import com.privatefasterxml.jackson.databind.ObjectWriter;
import com.privatefasterxml.jackson.databind.PropertyMetadata;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.cfg.MapperConfigBase;
import com.privatefasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedField;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.privatefasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.privatefasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.privatefasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.AnyGetterWriter;
import com.privatefasterxml.jackson.databind.ser.BasicSerializerFactory;
import com.privatefasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.privatefasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.privatefasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.privatefasterxml.jackson.databind.ser.PropertyBuilder;
import com.privatefasterxml.jackson.databind.ser.ResolvableSerializer;
import com.privatefasterxml.jackson.databind.ser.SerializerFactory;
import com.privatefasterxml.jackson.databind.ser.Serializers;
import com.privatefasterxml.jackson.databind.ser.impl.FilteredBeanPropertyWriter;
import com.privatefasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.privatefasterxml.jackson.databind.ser.impl.PropertyBasedObjectIdGenerator;
import com.privatefasterxml.jackson.databind.ser.impl.UnsupportedTypeSerializer;
import com.privatefasterxml.jackson.databind.ser.std.MapSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.privatefasterxml.jackson.databind.ser.std.ToEmptyObjectSerializer;
import com.privatefasterxml.jackson.databind.type.ReferenceType;
import com.privatefasterxml.jackson.databind.util.BeanUtil;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.Converter;
import com.privatefasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.privatefasterxml.jackson.databind.util.NativeImageUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class BeanSerializerFactory
extends BasicSerializerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final BeanSerializerFactory instance = new BeanSerializerFactory(null);

    public BeanSerializerFactory(SerializerFactoryConfig serializerFactoryConfig) {
        super(serializerFactoryConfig);
    }

    @Override
    public SerializerFactory withConfig(SerializerFactoryConfig serializerFactoryConfig) {
        if (this._factoryConfig == serializerFactoryConfig) {
            return this;
        }
        if (this.getClass() == BeanSerializerFactory.class) {
            return new BeanSerializerFactory(serializerFactoryConfig);
        }
        throw new IllegalStateException("Subtype of BeanSerializerFactory (" + this.getClass().getName() + ") has not properly overridden method 'withAdditionalSerializers': cannot instantiate subtype with additional serializer definitions");
    }

    @Override
    public Iterable<Serializers> customSerializers() {
        return this._factoryConfig.serializers();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JsonSerializer<Object> createSerializer(SerializerProvider serializerProvider, JavaType javaType) {
        boolean bl;
        String string;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        BeanDescription beanDescription = serializationConfig.introspect(javaType);
        JsonSerializer<Object> jsonSerializer = ((BasicSerializerFactory)((Object)string)).findSerializerFromAnnotation(serializerProvider, beanDescription.getClassInfo());
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        Serializable serializable = serializationConfig.getAnnotationIntrospector();
        if (serializable == null) {
            serializable = javaType;
        } else {
            try {
                serializable = ((AnnotationIntrospector)serializable).refineSerializationType(serializationConfig, beanDescription.getClassInfo(), javaType);
            }
            catch (JsonMappingException jsonMappingException) {
                string = jsonMappingException.getMessage();
                return (JsonSerializer)serializerProvider.reportBadTypeDefinition(beanDescription, string, new Object[0]);
            }
        }
        if (serializable == javaType) {
            bl = false;
        } else {
            bl = true;
            if (!((JavaType)serializable).hasRawClass(javaType.getRawClass())) {
                beanDescription = serializationConfig.introspect((JavaType)serializable);
            }
        }
        Converter<Object, Object> converter = beanDescription.findSerializationConverter();
        if (converter == null) {
            return ((BeanSerializerFactory)((Object)string))._createSerializer2(serializerProvider, (JavaType)serializable, beanDescription, bl);
        }
        JavaType javaType2 = converter.getOutputType(serializerProvider.getTypeFactory());
        if (!javaType2.hasRawClass(((JavaType)serializable).getRawClass())) {
            beanDescription = serializationConfig.introspect(javaType2);
            jsonSerializer = ((BasicSerializerFactory)((Object)string)).findSerializerFromAnnotation(serializerProvider, beanDescription.getClassInfo());
        }
        if (jsonSerializer == null && !javaType2.isJavaLangObject()) {
            jsonSerializer = ((BeanSerializerFactory)((Object)string))._createSerializer2(serializerProvider, javaType2, beanDescription, true);
        }
        return new StdDelegatingSerializer(converter, javaType2, jsonSerializer);
    }

    public JsonSerializer<?> _createSerializer2(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl) {
        JsonSerializer<Object> jsonSerializer = null;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        if (javaType.isContainerType()) {
            if (!bl) {
                bl = ((BasicSerializerFactory)((Object)iterator)).usesStaticTyping(serializationConfig, beanDescription, null);
            }
            if ((jsonSerializer = ((BasicSerializerFactory)((Object)iterator)).buildContainerSerializer(serializerProvider, javaType, beanDescription, bl)) != null) {
                return jsonSerializer;
            }
        } else {
            if (javaType.isReferenceType()) {
                jsonSerializer = ((BasicSerializerFactory)((Object)iterator)).findReferenceSerializer(serializerProvider, (ReferenceType)javaType, beanDescription, bl);
            } else {
                Iterator<Serializers> iterator = ((BeanSerializerFactory)((Object)iterator)).customSerializers().iterator();
                while (iterator.hasNext() && (jsonSerializer = iterator.next().findSerializer(serializationConfig, javaType, beanDescription)) == null) {
                }
            }
            if (jsonSerializer == null) {
                jsonSerializer = ((BasicSerializerFactory)((Object)iterator)).findSerializerByAnnotations(serializerProvider, javaType, beanDescription);
            }
        }
        if (jsonSerializer == null && (jsonSerializer = ((BasicSerializerFactory)((Object)iterator)).findSerializerByLookup(javaType, serializationConfig, beanDescription, bl)) == null && (jsonSerializer = ((BasicSerializerFactory)((Object)iterator)).findSerializerByPrimaryType(serializerProvider, javaType, beanDescription, bl)) == null && (jsonSerializer = ((BeanSerializerFactory)((Object)iterator)).findBeanOrAddOnSerializer(serializerProvider, javaType, beanDescription, bl)) == null) {
            jsonSerializer = serializerProvider.getUnknownTypeSerializer(beanDescription.getBeanClass());
        }
        if (jsonSerializer != null && ((BasicSerializerFactory)((Object)iterator))._factoryConfig.hasSerializerModifiers()) {
            Iterator<BeanSerializerModifier> iterator = ((BasicSerializerFactory)((Object)iterator))._factoryConfig.serializerModifiers().iterator();
            while (iterator.hasNext()) {
                jsonSerializer = ((BeanSerializerModifier)iterator.next()).modifySerializer(serializationConfig, beanDescription, jsonSerializer);
            }
        }
        return jsonSerializer;
    }

    @Deprecated
    public JsonSerializer<Object> findBeanSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription) {
        SerializerProvider serializerProvider2 = serializerProvider;
        boolean bl = serializerProvider2.isEnabled(MapperFeature.USE_STATIC_TYPING);
        return this.findBeanOrAddOnSerializer(serializerProvider2, javaType, beanDescription, bl);
    }

    public JsonSerializer<Object> findBeanOrAddOnSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl) {
        if (!this.isPotentialBeanType(javaType.getRawClass()) && !ClassUtil.isEnumType(javaType.getRawClass())) {
            return null;
        }
        return this.constructBeanOrAddOnSerializer(serializerProvider, javaType, beanDescription, bl);
    }

    public TypeSerializer findPropertyTypeSerializer(JavaType javaType, SerializationConfig serializationConfig, AnnotatedMember annotatedMember) {
        TypeSerializer typeSerializer;
        TypeResolverBuilder<?> typeResolverBuilder = serializationConfig.getAnnotationIntrospector().findPropertyTypeResolver(serializationConfig, annotatedMember, javaType);
        if (typeResolverBuilder == null) {
            typeSerializer = this.createTypeSerializer(serializationConfig, javaType);
        } else {
            SerializationConfig serializationConfig2 = serializationConfig;
            typeSerializer = typeResolverBuilder.buildTypeSerializer(serializationConfig2, javaType, serializationConfig2.getSubtypeResolver().collectAndResolveSubtypesByClass(serializationConfig, annotatedMember, javaType));
        }
        return typeSerializer;
    }

    public TypeSerializer findPropertyContentTypeSerializer(JavaType typeResolverBuilder, SerializationConfig serializationConfig, AnnotatedMember annotatedMember) {
        TypeSerializer typeSerializer;
        JavaType javaType = ((JavaType)((Object)typeResolverBuilder)).getContentType();
        typeResolverBuilder = serializationConfig.getAnnotationIntrospector().findPropertyContentTypeResolver(serializationConfig, annotatedMember, (JavaType)((Object)typeResolverBuilder));
        if (typeResolverBuilder == null) {
            typeSerializer = this.createTypeSerializer(serializationConfig, javaType);
        } else {
            SerializationConfig serializationConfig2 = serializationConfig;
            typeSerializer = typeResolverBuilder.buildTypeSerializer(serializationConfig2, javaType, serializationConfig2.getSubtypeResolver().collectAndResolveSubtypesByClass(serializationConfig, annotatedMember, javaType));
        }
        return typeSerializer;
    }

    @Deprecated
    public JsonSerializer<Object> constructBeanSerializer(SerializerProvider serializerProvider, BeanDescription beanDescription) {
        BeanSerializerFactory beanSerializerFactory = serializable;
        SerializerProvider serializerProvider2 = serializerProvider;
        Serializable serializable = beanDescription.getType();
        boolean bl = serializerProvider2.isEnabled(MapperFeature.USE_STATIC_TYPING);
        return beanSerializerFactory.constructBeanOrAddOnSerializer(serializerProvider2, (JavaType)serializable, beanDescription, bl);
    }

    public JsonSerializer<Object> constructBeanOrAddOnSerializer(SerializerProvider object, JavaType javaType, BeanDescription beanDescription, boolean bl) {
        block17: {
            Object object2;
            if (beanDescription.getBeanClass() == Object.class) {
                return object.getUnknownTypeSerializer(Object.class);
            }
            JsonSerializer<Object> jsonSerializer = this._findUnsupportedTypeSerializer((SerializerProvider)object, javaType, beanDescription);
            if (jsonSerializer != null) {
                return jsonSerializer;
            }
            if (this._isUnserializableJacksonType((SerializerProvider)object, javaType)) {
                return new ToEmptyObjectSerializer(javaType);
            }
            BeanSerializerFactory beanSerializerFactory = this;
            jsonSerializer = object.getConfig();
            BeanSerializerBuilder beanSerializerBuilder = beanSerializerFactory.constructBeanSerializerBuilder(beanDescription);
            beanSerializerBuilder.setConfig((SerializationConfig)((Object)jsonSerializer));
            Iterator<BeanSerializerModifier> iterator = beanSerializerFactory.findBeanProperties((SerializerProvider)object, beanDescription, beanSerializerBuilder);
            if (iterator == null) {
                ArrayList<BeanPropertyWriter> arrayList;
                iterator = arrayList;
                arrayList = new ArrayList<BeanPropertyWriter>();
            } else {
                iterator = this.removeOverlappingTypeIds((SerializerProvider)object, beanDescription, beanSerializerBuilder, (List<BeanPropertyWriter>)((Object)iterator));
            }
            object.getAnnotationIntrospector().findAndAddVirtualProperties((MapperConfig<?>)((Object)jsonSerializer), beanDescription.getClassInfo(), (List<BeanPropertyWriter>)((Object)iterator));
            if (this._factoryConfig.hasSerializerModifiers()) {
                object2 = this._factoryConfig.serializerModifiers().iterator();
                while (object2.hasNext()) {
                    iterator = object2.next().changeProperties((SerializationConfig)((Object)jsonSerializer), beanDescription, (List<BeanPropertyWriter>)((Object)iterator));
                }
            }
            BeanSerializerFactory beanSerializerFactory2 = this;
            iterator = beanSerializerFactory2.filterBeanProperties((SerializationConfig)((Object)jsonSerializer), beanDescription, this.filterUnwantedJDKProperties((SerializationConfig)((Object)jsonSerializer), beanDescription, (List<BeanPropertyWriter>)((Object)iterator)));
            if (beanSerializerFactory2._factoryConfig.hasSerializerModifiers()) {
                object2 = this._factoryConfig.serializerModifiers().iterator();
                while (object2.hasNext()) {
                    iterator = object2.next().orderProperties((SerializationConfig)((Object)jsonSerializer), beanDescription, (List<BeanPropertyWriter>)((Object)iterator));
                }
            }
            beanSerializerBuilder.setObjectIdWriter(this.constructObjectIdHandler((SerializerProvider)object, beanDescription, (List<BeanPropertyWriter>)((Object)iterator)));
            beanSerializerBuilder.setProperties((List<BeanPropertyWriter>)((Object)iterator));
            beanSerializerBuilder.setFilterId(this.findFilterId((SerializationConfig)((Object)jsonSerializer), beanDescription));
            iterator = beanDescription.findAnyGetter();
            if (iterator != null) {
                BeanProperty.Std std;
                BeanSerializerFactory beanSerializerFactory3 = this;
                object2 = ((Annotated)((Object)iterator)).getType();
                JavaType javaType2 = ((JavaType)object2).getContentType();
                Object object3 = beanSerializerFactory3.createTypeSerializer((SerializationConfig)((Object)jsonSerializer), javaType2);
                MapSerializer mapSerializer = beanSerializerFactory3.findSerializerFromAnnotation((SerializerProvider)object, (Annotated)((Object)iterator));
                if (mapSerializer == null) {
                    boolean bl2 = ((MapperConfig)((Object)jsonSerializer)).isEnabled(MapperFeature.USE_STATIC_TYPING);
                    mapSerializer = MapSerializer.construct(null, (JavaType)object2, bl2, (TypeSerializer)object3, null, null, null);
                }
                object2 = PropertyName.construct(((Annotated)((Object)iterator)).getName());
                object3 = std;
                Object object4 = object2;
                object2 = PropertyMetadata.STD_OPTIONAL;
                std = new BeanProperty.Std((PropertyName)object4, javaType2, null, (AnnotatedMember)((Object)iterator), (PropertyMetadata)object2);
                beanSerializerBuilder.setAnyGetter(new AnyGetterWriter((BeanProperty)object3, (AnnotatedMember)((Object)iterator), mapSerializer));
            }
            BeanSerializerFactory beanSerializerFactory4 = this;
            beanSerializerFactory4.processViews((SerializationConfig)((Object)jsonSerializer), beanSerializerBuilder);
            if (beanSerializerFactory4._factoryConfig.hasSerializerModifiers()) {
                iterator = this._factoryConfig.serializerModifiers().iterator();
                while (iterator.hasNext()) {
                    beanSerializerBuilder = iterator.next().updateBuilder((SerializationConfig)((Object)jsonSerializer), beanDescription, beanSerializerBuilder);
                }
            }
            try {
                object = beanSerializerBuilder.build();
                if (object != null) break block17;
            }
            catch (RuntimeException runtimeException) {
                SerializerProvider serializerProvider = object;
                Object[] objectArray = new Object[3];
                object = objectArray;
                object[0] = beanDescription.getType();
                object[1] = runtimeException.getClass().getName();
                objectArray[2] = runtimeException.getMessage();
                return (JsonSerializer)serializerProvider.reportBadTypeDefinition(beanDescription, "Failed to construct BeanSerializer for %s: (%s) %s", object);
            }
            if (javaType.isRecordType() && !NativeImageUtil.needsReflectionConfiguration(javaType.getRawClass())) {
                return beanSerializerBuilder.createDummy();
            }
            object = this.findSerializerByAddonType((SerializationConfig)((Object)jsonSerializer), javaType, beanDescription, bl);
            if (object == null && beanDescription.hasKnownClassAnnotations()) {
                return beanSerializerBuilder.createDummy();
            }
        }
        return object;
    }

    public ObjectIdWriter constructObjectIdHandler(SerializerProvider object, BeanDescription beanDescription, List<BeanPropertyWriter> object2) {
        Object object3 = beanDescription.getObjectIdInfo();
        if (object3 == null) {
            return null;
        }
        Class<? extends ObjectIdGenerator<?>> clazz = object3.getGeneratorType();
        if (clazz == ObjectIdGenerators.PropertyGenerator.class) {
            object = object3.getPropertyName().getSimpleName();
            int n2 = object2.size();
            for (int i2 = 0; i2 != n2; ++i2) {
                PropertyBasedObjectIdGenerator propertyBasedObjectIdGenerator;
                BeanPropertyWriter beanPropertyWriter = (BeanPropertyWriter)object2.get(i2);
                if (!((String)object).equals(beanPropertyWriter.getName())) continue;
                if (i2 > 0) {
                    Object object4 = object2;
                    object4.remove(i2);
                    object4.add(0, beanPropertyWriter);
                }
                object = propertyBasedObjectIdGenerator;
                propertyBasedObjectIdGenerator = new PropertyBasedObjectIdGenerator((ObjectIdInfo)object3, beanPropertyWriter);
                boolean bl = object3.getAlwaysAsId();
                return ObjectIdWriter.construct(beanPropertyWriter.getType(), null, object, bl);
            }
            Object[] objectArray = new Object[2];
            object3 = objectArray;
            object3[0] = ClassUtil.getTypeDescription(beanDescription.getType());
            objectArray[1] = ClassUtil.name((String)object);
            throw new IllegalArgumentException(String.format("Invalid Object Id definition for %s: cannot find property with name %s", object3));
        }
        SerializerProvider serializerProvider = object;
        object2 = serializerProvider.constructType(clazz);
        object3 = ((DatabindContext)object).objectIdGeneratorInstance(beanDescription.getClassInfo(), (ObjectIdInfo)object3);
        object = object3.getPropertyName();
        boolean bl = object3.getAlwaysAsId();
        return ObjectIdWriter.construct(serializerProvider.getTypeFactory().findTypeParameters((JavaType)object2, ObjectIdGenerator.class)[0], (PropertyName)object, object3, bl);
    }

    public BeanPropertyWriter constructFilteredBeanWriter(BeanPropertyWriter beanPropertyWriter, Class<?>[] classArray) {
        return FilteredBeanPropertyWriter.constructViewBased(beanPropertyWriter, classArray);
    }

    public PropertyBuilder constructPropertyBuilder(SerializationConfig serializationConfig, BeanDescription beanDescription) {
        return new PropertyBuilder(serializationConfig, beanDescription);
    }

    public BeanSerializerBuilder constructBeanSerializerBuilder(BeanDescription beanDescription) {
        return new BeanSerializerBuilder(beanDescription);
    }

    public boolean isPotentialBeanType(Class<?> clazz) {
        return ClassUtil.canBeABeanType(clazz) == null && !ClassUtil.isProxyType(clazz);
    }

    public List<BeanPropertyWriter> findBeanProperties(SerializerProvider serializerProvider, BeanDescription object, BeanSerializerBuilder beanSerializerBuilder) {
        ArrayList<BeanPropertyWriter> arrayList;
        Object object2 = ((BeanDescription)object).findProperties();
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        this.removeIgnorableTypes(serializationConfig, (BeanDescription)object, (List<BeanPropertyDefinition>)object2);
        if (serializationConfig.isEnabled(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS)) {
            this.removeSetterlessGetters(serializationConfig, (BeanDescription)object, (List<BeanPropertyDefinition>)object2);
        }
        if (object2.isEmpty()) {
            return null;
        }
        boolean bl = this.usesStaticTyping(serializationConfig, (BeanDescription)object, null);
        object = this.constructPropertyBuilder(serializationConfig, (BeanDescription)object);
        ArrayList<BeanPropertyWriter> arrayList2 = arrayList;
        arrayList = new ArrayList<BeanPropertyWriter>(object2.size());
        object2 = object2.iterator();
        while (object2.hasNext()) {
            BeanPropertyDefinition beanPropertyDefinition = (BeanPropertyDefinition)object2.next();
            AnnotatedMember annotatedMember = beanPropertyDefinition.getAccessor();
            if (beanPropertyDefinition.isTypeId()) {
                if (annotatedMember == null) continue;
                beanSerializerBuilder.setTypeId(annotatedMember);
                continue;
            }
            AnnotationIntrospector.ReferenceProperty referenceProperty = beanPropertyDefinition.findReferenceType();
            if (referenceProperty != null && referenceProperty.isBackReference()) continue;
            if (annotatedMember instanceof AnnotatedMethod) {
                annotatedMember = (AnnotatedMethod)annotatedMember;
                arrayList2.add(this._constructWriter(serializerProvider, beanPropertyDefinition, (PropertyBuilder)object, bl, annotatedMember));
                continue;
            }
            annotatedMember = (AnnotatedField)annotatedMember;
            arrayList2.add(this._constructWriter(serializerProvider, beanPropertyDefinition, (PropertyBuilder)object, bl, annotatedMember));
        }
        return arrayList2;
    }

    public List<BeanPropertyWriter> filterBeanProperties(SerializationConfig object, BeanDescription beanDescription, List<BeanPropertyWriter> list) {
        BeanDescription beanDescription2 = beanDescription;
        Object object2 = beanDescription2.getBeanClass();
        object2 = ((MapperConfigBase)object).getDefaultPropertyIgnorals((Class<?>)object2, beanDescription2.getClassInfo());
        Set<String> set = null;
        if (object2 != null) {
            set = ((JsonIgnoreProperties.Value)object2).findIgnoredForSerialization();
        }
        BeanDescription beanDescription3 = beanDescription;
        object2 = beanDescription3.getBeanClass();
        object2 = ((MapperConfigBase)object).getDefaultPropertyInclusions((Class<?>)object2, beanDescription3.getClassInfo());
        object = null;
        if (object2 != null) {
            object = ((JsonIncludeProperties.Value)object2).getIncluded();
        }
        if (object != null || set != null && !set.isEmpty()) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                if (!IgnorePropertiesUtil.shouldIgnore(((BeanPropertyWriter)object2.next()).getName(), set, (Collection<String>)object)) continue;
                object2.remove();
            }
        }
        return list;
    }

    public List<BeanPropertyWriter> filterUnwantedJDKProperties(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyWriter> list) {
        if (beanDescription.getType().isTypeOrSubTypeOf(CharSequence.class) && list.size() == 1 && (this = list.get(0).getMember()) instanceof AnnotatedMethod && "isEmpty".equals(((Annotated)((Object)this)).getName()) && ((AnnotatedMember)this).getDeclaringClass() == CharSequence.class) {
            list.remove(0);
        }
        return list;
    }

    public void processViews(SerializationConfig serializationConfig, BeanSerializerBuilder beanSerializerBuilder) {
        List<BeanPropertyWriter> list = beanSerializerBuilder.getProperties();
        boolean bl = serializationConfig.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        int n2 = list.size();
        int n3 = 0;
        BeanPropertyWriter[] beanPropertyWriterArray = new BeanPropertyWriter[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            BeanPropertyWriter beanPropertyWriter = list.get(i2);
            Class<?>[] classArray = beanPropertyWriter.getViews();
            if (classArray != null && classArray.length != 0) {
                ++n3;
                beanPropertyWriterArray[i2] = this.constructFilteredBeanWriter(beanPropertyWriter, classArray);
                continue;
            }
            if (!bl) continue;
            beanPropertyWriterArray[i2] = beanPropertyWriter;
        }
        if (bl && n3 == 0) {
            return;
        }
        beanSerializerBuilder.setFilteredProperties(beanPropertyWriterArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeIgnorableTypes(SerializationConfig serializationConfig, BeanDescription object, List<BeanPropertyDefinition> iterator) {
        HashMap hashMap;
        Serializable serializable = serializationConfig.getAnnotationIntrospector();
        object = hashMap;
        hashMap = new HashMap();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object2 = (BeanPropertyDefinition)iterator.next();
            if (((BeanPropertyDefinition)object2).getAccessor() != null) {
                Boolean bl = (Boolean)((HashMap)object).get(object2 = ((BeanPropertyDefinition)object2).getRawPrimaryType());
                if (bl == null) {
                    bl = serializationConfig.getConfigOverride((Class<?>)object2).getIsIgnoredType();
                    if (bl == null && (bl = ((AnnotationIntrospector)serializable).isIgnorableType(serializationConfig.introspectClassAnnotations((Class<?>)object2).getClassInfo())) == null) {
                        bl = Boolean.FALSE;
                    }
                    ((HashMap)object).put(object2, bl);
                }
                if (!bl.booleanValue()) continue;
            }
            iterator.remove();
        }
        return;
    }

    public void removeSetterlessGetters(SerializationConfig object, BeanDescription beanDescription, List<BeanPropertyDefinition> list) {
        Iterator<BeanPropertyDefinition> iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (BeanPropertyDefinition)iterator.next();
            if (((BeanPropertyDefinition)object).couldDeserialize() || ((BeanPropertyDefinition)object).isExplicitlyIncluded()) continue;
            iterator.remove();
        }
    }

    public List<BeanPropertyWriter> removeOverlappingTypeIds(SerializerProvider serializerProvider, BeanDescription object, BeanSerializerBuilder object2, List<BeanPropertyWriter> list) {
        int n2 = list.size();
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            object = list.get(i2);
            object2 = ((BeanPropertyWriter)object).getTypeSerializer();
            if (object2 == null || ((TypeSerializer)object2).getTypeInclusion() != JsonTypeInfo.As.EXTERNAL_PROPERTY) continue;
            object2 = PropertyName.construct(((TypeSerializer)object2).getPropertyName());
            for (BeanPropertyWriter beanPropertyWriter : list) {
                if (beanPropertyWriter == object || !beanPropertyWriter.wouldConflictWithName((PropertyName)object2)) continue;
                ((BeanPropertyWriter)object).assignTypeSerializer(null);
                continue block0;
            }
        }
        return list;
    }

    public BeanPropertyWriter _constructWriter(SerializerProvider serializerProvider, BeanPropertyDefinition beanPropertyDefinition, PropertyBuilder propertyBuilder, boolean bl, AnnotatedMember annotatedMember) {
        BeanProperty.Std std;
        JsonSerializer<Object> jsonSerializer = beanPropertyDefinition.getFullName();
        JavaType javaType = annotatedMember.getType();
        Object object = std;
        PropertyName propertyName = jsonSerializer;
        BeanPropertyDefinition beanPropertyDefinition2 = beanPropertyDefinition;
        jsonSerializer = beanPropertyDefinition2.getWrapperName();
        PropertyMetadata propertyMetadata = beanPropertyDefinition2.getMetadata();
        std = new BeanProperty.Std(propertyName, javaType, (PropertyName)((Object)jsonSerializer), annotatedMember, propertyMetadata);
        jsonSerializer = ((BasicSerializerFactory)((Object)typeSerializer)).findSerializerFromAnnotation(serializerProvider, annotatedMember);
        if (jsonSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
        }
        jsonSerializer = serializerProvider.handlePrimaryContextualization(jsonSerializer, (BeanProperty)object);
        object = null;
        if (javaType.isContainerType() || javaType.isReferenceType()) {
            object = ((BeanSerializerFactory)((Object)typeSerializer)).findPropertyContentTypeSerializer(javaType, serializerProvider.getConfig(), annotatedMember);
        }
        TypeSerializer typeSerializer = ((BeanSerializerFactory)((Object)typeSerializer)).findPropertyTypeSerializer(javaType, serializerProvider.getConfig(), annotatedMember);
        return propertyBuilder.buildWriter(serializerProvider, beanPropertyDefinition, javaType, jsonSerializer, typeSerializer, (TypeSerializer)object, annotatedMember, bl);
    }

    public JsonSerializer<?> _findUnsupportedTypeSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription) {
        String string = BeanUtil.checkUnsupportedType(javaType);
        if (string != null && serializerProvider.getConfig().findMixInClassFor(javaType.getRawClass()) == null) {
            return new UnsupportedTypeSerializer(javaType, string);
        }
        return null;
    }

    public boolean _isUnserializableJacksonType(SerializerProvider serializerProvider, JavaType javaType) {
        Serializable serializable = javaType.getRawClass();
        return ObjectMapper.class.isAssignableFrom((Class<?>)serializable) || ObjectReader.class.isAssignableFrom((Class<?>)serializable) || ObjectWriter.class.isAssignableFrom((Class<?>)serializable) || DatabindContext.class.isAssignableFrom((Class<?>)serializable) || TokenStreamFactory.class.isAssignableFrom((Class<?>)serializable) || JsonParser.class.isAssignableFrom((Class<?>)serializable) || JsonGenerator.class.isAssignableFrom((Class<?>)serializable);
    }
}

