/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser;

import com.applitools.android.common.a;
import com.privatefasterxml.jackson.annotation.ObjectIdGenerator;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsonschema.JsonSchema;
import com.privatefasterxml.jackson.databind.jsonschema.SchemaAware;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.node.ObjectNode;
import com.privatefasterxml.jackson.databind.ser.SerializerFactory;
import com.privatefasterxml.jackson.databind.ser.impl.WritableObjectId;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public abstract class DefaultSerializerProvider
extends SerializerProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient Map<Object, WritableObjectId> _seenObjectIds;
    protected transient ArrayList<ObjectIdGenerator<?>> _objectIdGenerators;
    protected transient JsonGenerator _generator;

    public DefaultSerializerProvider() {
    }

    public DefaultSerializerProvider(SerializerProvider serializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        super(serializerProvider, serializationConfig, serializerFactory);
    }

    public DefaultSerializerProvider(DefaultSerializerProvider defaultSerializerProvider) {
        super(defaultSerializerProvider);
    }

    private final void _serialize(JsonGenerator jsonGenerator, Object object, JsonSerializer<Object> jsonSerializer, PropertyName propertyName) {
        try {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(propertyName.simpleAsEncoded(this._config));
            jsonSerializer.serialize(object, jsonGenerator, this);
            jsonGenerator.writeEndObject();
            return;
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
    }

    private final void _serialize(JsonGenerator jsonGenerator, Object object, JsonSerializer<Object> jsonSerializer) {
        try {
            jsonSerializer.serialize(object, jsonGenerator, this);
            return;
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
    }

    private IOException _wrapAsIOE(JsonGenerator jsonGenerator, Exception exception) {
        if (exception instanceof IOException) {
            return (IOException)exception;
        }
        Object object = ClassUtil.exceptionMessage(exception);
        if (object == null) {
            object = "[no message for " + exception.getClass().getName() + "]";
        }
        return new JsonMappingException((Closeable)jsonGenerator, (String)object, (Throwable)exception);
    }

    public abstract DefaultSerializerProvider createInstance(SerializationConfig var1, SerializerFactory var2);

    public DefaultSerializerProvider copy() {
        throw new IllegalStateException("DefaultSerializerProvider sub-class not overriding copy()");
    }

    @Override
    public JsonSerializer<Object> serializerInstance(Annotated jsonSerializer, Object object) {
        block9: {
            block8: {
                HandlerInstantiator handlerInstantiator;
                block7: {
                    if (object == null) {
                        return null;
                    }
                    if (!(object instanceof JsonSerializer)) break block7;
                    jsonSerializer = (JsonSerializer)object;
                    break block8;
                }
                if (!(object instanceof Class)) {
                    this.reportBadDefinition(((Annotated)((Object)jsonSerializer)).getType(), "AnnotationIntrospector returned serializer definition of type " + object.getClass().getName() + "; expected type JsonSerializer or Class<JsonSerializer> instead");
                }
                if ((object = (Class)object) == JsonSerializer.None.class || ClassUtil.isBogusClass(object)) break block9;
                if (!JsonSerializer.class.isAssignableFrom((Class<?>)object)) {
                    this.reportBadDefinition(((Annotated)((Object)jsonSerializer)).getType(), "AnnotationIntrospector returned Class " + ((Class)object).getName() + "; expected Class<JsonSerializer>");
                }
                if ((jsonSerializer = (handlerInstantiator = this._config.getHandlerInstantiator()) == null ? null : handlerInstantiator.serializerInstance(this._config, (Annotated)((Object)jsonSerializer), (Class<?>)object)) == null) {
                    jsonSerializer = (JsonSerializer)ClassUtil.createInstance(object, this._config.canOverrideAccessModifiers());
                }
            }
            return this._handleResolvable(jsonSerializer);
        }
        return null;
    }

    @Override
    public Object includeFilterInstance(BeanPropertyDefinition object, Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
        object = handlerInstantiator == null ? null : handlerInstantiator.includeFilterInstance(this._config, (BeanPropertyDefinition)object, clazz);
        if (object == null) {
            object = ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
        }
        return object;
    }

    @Override
    public boolean includeFilterSuppressNulls(Object object) {
        if (object == null) {
            return true;
        }
        try {
            return object.equals(null);
        }
        catch (Exception exception) {
            Object[] objectArray = object2;
            Object[] objectArray2 = new Object[3];
            Object object2 = objectArray2;
            object2[0] = object.getClass().getName();
            object2[1] = exception.getClass().getName();
            objectArray2[2] = ClassUtil.exceptionMessage(exception);
            object2 = String.format("Problem determining whether filter of type '%s' should filter out `null` values: (%s) %s", object2);
            objectArray.reportBadDefinition(object.getClass(), (String)object2, (Throwable)exception);
            return false;
        }
    }

    @Override
    public WritableObjectId findObjectId(Object object, ObjectIdGenerator<?> object2) {
        WritableObjectId writableObjectId;
        Object object3 = this._seenObjectIds;
        if (object3 == null) {
            this._seenObjectIds = this._createObjectIdMap();
        } else if ((object3 = object3.get(object)) != null) {
            return object3;
        }
        object3 = null;
        ArrayList arrayList = this._objectIdGenerators;
        if (arrayList == null) {
            ArrayList arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList(8);
            this._objectIdGenerators = arrayList;
        } else {
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ObjectIdGenerator<?> objectIdGenerator = this._objectIdGenerators.get(i2);
                if (!objectIdGenerator.canUseFor((ObjectIdGenerator<?>)object2)) continue;
                object3 = objectIdGenerator;
                break;
            }
        }
        if (object3 == null) {
            object3 = ((ObjectIdGenerator)object2).newForSerialization(this);
            this._objectIdGenerators.add((ObjectIdGenerator<?>)object3);
        }
        object2 = writableObjectId;
        ((WritableObjectId)object2)((ObjectIdGenerator<?>)object3);
        this._seenObjectIds.put(object, (WritableObjectId)object2);
        return writableObjectId;
    }

    public Map<Object, WritableObjectId> _createObjectIdMap() {
        if (this.isEnabled(SerializationFeature.USE_EQUALITY_FOR_OBJECT_ID)) {
            return new HashMap<Object, WritableObjectId>();
        }
        return new IdentityHashMap<Object, WritableObjectId>();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasSerializerFor(Class<?> clazz, AtomicReference<Throwable> atomicReference) {
        if (clazz == Object.class && !this._config.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            return true;
        }
        try {
            if (this._findExplicitUntypedSerializer(clazz) == null) return false;
            return true;
        }
        catch (RuntimeException runtimeException) {
            void var0_2;
            block4: {
                if (atomicReference == null) throw runtimeException;
                break block4;
                catch (JsonMappingException jsonMappingException) {
                    if (atomicReference == null) return false;
                }
            }
            atomicReference.set((Throwable)var0_2);
            return false;
        }
    }

    @Override
    public JsonGenerator getGenerator() {
        return this._generator;
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object) {
        serializable._generator = jsonGenerator;
        if (object == null) {
            serializable._serializeNull(jsonGenerator);
            return;
        }
        DefaultSerializerProvider defaultSerializerProvider = serializable;
        Class<?> clazz = object.getClass();
        JsonSerializer<Object> jsonSerializer = defaultSerializerProvider.findTypedValueSerializer(clazz, true, null);
        PropertyName propertyName = defaultSerializerProvider._config.getFullRootName();
        if (propertyName == null) {
            if (serializable._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE)) {
                DefaultSerializerProvider defaultSerializerProvider2 = serializable;
                Serializable serializable = serializable._config.findRootName(clazz);
                defaultSerializerProvider2._serialize(jsonGenerator, object, jsonSerializer, (PropertyName)serializable);
                return;
            }
        } else if (!propertyName.isEmpty()) {
            serializable._serialize(jsonGenerator, object, jsonSerializer, propertyName);
            return;
        }
        serializable._serialize(jsonGenerator, object, jsonSerializer);
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType) {
        serializable._generator = jsonGenerator;
        if (object == null) {
            serializable._serializeNull(jsonGenerator);
            return;
        }
        if (!javaType.getRawClass().isAssignableFrom(object.getClass())) {
            serializable._reportIncompatibleRootType(object, javaType);
        }
        DefaultSerializerProvider defaultSerializerProvider = serializable;
        JsonSerializer<Object> jsonSerializer = defaultSerializerProvider.findTypedValueSerializer(javaType, true, null);
        PropertyName propertyName = defaultSerializerProvider._config.getFullRootName();
        if (propertyName == null) {
            if (serializable._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE)) {
                DefaultSerializerProvider defaultSerializerProvider2 = serializable;
                Serializable serializable = serializable._config.findRootName(javaType);
                defaultSerializerProvider2._serialize(jsonGenerator, object, jsonSerializer, (PropertyName)serializable);
                return;
            }
        } else if (!propertyName.isEmpty()) {
            serializable._serialize(jsonGenerator, object, jsonSerializer, propertyName);
            return;
        }
        serializable._serialize(jsonGenerator, object, jsonSerializer);
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType serializable, JsonSerializer<Object> jsonSerializer) {
        PropertyName propertyName;
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeNull(jsonGenerator);
            return;
        }
        if (serializable != null && !serializable.getRawClass().isAssignableFrom(object.getClass())) {
            this._reportIncompatibleRootType(object, (JavaType)serializable);
        }
        if (jsonSerializer == null) {
            jsonSerializer = this.findTypedValueSerializer((JavaType)serializable, true, null);
        }
        if ((propertyName = this._config.getFullRootName()) == null) {
            if (this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE)) {
                serializable = serializable == null ? this._config.findRootName(object.getClass()) : this._config.findRootName((JavaType)serializable);
                this._serialize(jsonGenerator, object, jsonSerializer, (PropertyName)serializable);
                return;
            }
        } else if (!propertyName.isEmpty()) {
            this._serialize(jsonGenerator, object, jsonSerializer, propertyName);
            return;
        }
        this._serialize(jsonGenerator, object, jsonSerializer);
    }

    public void serializePolymorphic(JsonGenerator jsonGenerator, Object object, JavaType serializable, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer) {
        Exception exception2;
        block12: {
            block11: {
                boolean bl;
                this._generator = jsonGenerator;
                if (object == null) {
                    this._serializeNull(jsonGenerator);
                    return;
                }
                if (serializable != null && !((JavaType)serializable).getRawClass().isAssignableFrom(object.getClass())) {
                    this._reportIncompatibleRootType(object, (JavaType)serializable);
                }
                if (jsonSerializer == null) {
                    jsonSerializer = serializable != null && ((JavaType)serializable).isContainerType() ? this.findValueSerializer((JavaType)serializable, null) : this.findValueSerializer(object.getClass(), null);
                }
                if ((serializable = this._config.getFullRootName()) == null) {
                    bl = this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
                    if (bl) {
                        jsonGenerator.writeStartObject();
                        jsonGenerator.writeFieldName(this._config.findRootName(object.getClass()).simpleAsEncoded(this._config));
                    }
                } else if (((PropertyName)serializable).isEmpty()) {
                    bl = false;
                } else {
                    bl = true;
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeFieldName(((PropertyName)serializable).getSimpleName());
                }
                try {
                    jsonSerializer.serializeWithType(object, jsonGenerator, this, typeSerializer);
                    if (!bl) break block11;
                }
                catch (Exception exception2) {
                    break block12;
                }
                jsonGenerator.writeEndObject();
            }
            return;
        }
        throw this._wrapAsIOE(jsonGenerator, exception2);
    }

    public void _serializeNull(JsonGenerator jsonGenerator) {
        try {
            this.getDefaultNullValueSerializer().serialize(null, jsonGenerator, this);
            return;
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
    }

    public int cachedSerializersCount() {
        return this._serializerCache.size();
    }

    public void flushCachedSerializers() {
        this._serializerCache.flush();
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) {
        if (javaType != null) {
            jsonFormatVisitorWrapper.setProvider(this);
            this.findValueSerializer(javaType, null).acceptJsonFormatVisitor(jsonFormatVisitorWrapper, javaType);
            return;
        }
        throw new IllegalArgumentException("A class must be provided");
    }

    @Deprecated
    public JsonSchema generateJsonSchema(Class<?> clazz) {
        JsonSerializer<Object> jsonSerializer = ((SerializerProvider)this).findValueSerializer(clazz, null);
        if ((this = jsonSerializer instanceof SchemaAware ? ((SchemaAware)((Object)jsonSerializer)).getSchema((SerializerProvider)this, null) : JsonSchema.getDefaultSchemaNode()) instanceof ObjectNode) {
            return new JsonSchema((ObjectNode)this);
        }
        throw new IllegalArgumentException(a.a(clazz, new StringBuilder("Class "), " would not be serialized as a JSON object and therefore has no schema"));
    }

    public static final class Impl
    extends DefaultSerializerProvider {
        private static final long serialVersionUID = 1L;

        public Impl() {
        }

        public Impl(Impl impl) {
            super(impl);
        }

        public Impl(SerializerProvider serializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
            super(serializerProvider, serializationConfig, serializerFactory);
        }

        @Override
        public DefaultSerializerProvider copy() {
            return new Impl(this);
        }

        @Override
        public Impl createInstance(SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
            return new Impl(this, serializationConfig, serializerFactory);
        }
    }
}

