/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser;

import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.ser.ResolvableSerializer;
import com.privatefasterxml.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap;
import com.privatefasterxml.jackson.databind.util.LRUMap;
import com.privatefasterxml.jackson.databind.util.TypeKey;
import java.util.concurrent.atomic.AtomicReference;

public final class SerializerCache {
    public static final int DEFAULT_MAX_CACHED = 4000;
    private final LRUMap<TypeKey, JsonSerializer<Object>> _sharedMap;
    private final AtomicReference<ReadOnlyClassToSerializerMap> _readOnlyMap;

    public SerializerCache() {
        this(4000);
    }

    public SerializerCache(int n2) {
        AtomicReference atomicReference;
        LRUMap lRUMap;
        SerializerCache serializerCache = this;
        int n3 = Math.min(64, n2 >> 2);
        LRUMap lRUMap2 = lRUMap;
        lRUMap = new LRUMap(n3, n2);
        serializerCache._sharedMap = lRUMap2;
        AtomicReference atomicReference2 = atomicReference;
        atomicReference = new AtomicReference();
        serializerCache._readOnlyMap = atomicReference2;
    }

    private final synchronized ReadOnlyClassToSerializerMap _makeReadOnlyLookupMap() {
        ReadOnlyClassToSerializerMap readOnlyClassToSerializerMap = this._readOnlyMap.get();
        if (readOnlyClassToSerializerMap == null) {
            SerializerCache serializerCache = this;
            readOnlyClassToSerializerMap = ReadOnlyClassToSerializerMap.from(serializerCache._sharedMap);
            serializerCache._readOnlyMap.set(readOnlyClassToSerializerMap);
        }
        return readOnlyClassToSerializerMap;
    }

    public ReadOnlyClassToSerializerMap getReadOnlyLookupMap() {
        ReadOnlyClassToSerializerMap readOnlyClassToSerializerMap = this._readOnlyMap.get();
        if (readOnlyClassToSerializerMap != null) {
            return readOnlyClassToSerializerMap;
        }
        return this._makeReadOnlyLookupMap();
    }

    public synchronized int size() {
        return this._sharedMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> untypedValueSerializer(Class<?> clazz) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            // ** MonitorExit[this] (shouldn't be in output)
            return serializerCache._sharedMap.get(new TypeKey(clazz, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> untypedValueSerializer(JavaType javaType) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            // ** MonitorExit[this] (shouldn't be in output)
            return serializerCache._sharedMap.get(new TypeKey(javaType, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> typedValueSerializer(JavaType javaType) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            // ** MonitorExit[this] (shouldn't be in output)
            return serializerCache._sharedMap.get(new TypeKey(javaType, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> typedValueSerializer(Class<?> clazz) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            // ** MonitorExit[this] (shouldn't be in output)
            return serializerCache._sharedMap.get(new TypeKey(clazz, true));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addTypedSerializer(JavaType javaType, JsonSerializer<Object> jsonSerializer) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            Throwable throwable2;
            block4: {
                block3: {
                    try {
                        if (serializerCache._sharedMap.put(new TypeKey(javaType, true), jsonSerializer) != null) break block3;
                        this._readOnlyMap.set(null);
                    }
                    catch (Throwable throwable2) {
                        break block4;
                    }
                }
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addTypedSerializer(Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            Throwable throwable2;
            block4: {
                block3: {
                    try {
                        if (serializerCache._sharedMap.put(new TypeKey(clazz, true), jsonSerializer) != null) break block3;
                        this._readOnlyMap.set(null);
                    }
                    catch (Throwable throwable2) {
                        break block4;
                    }
                }
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAndResolveNonTypedSerializer(Class<?> clazz, JsonSerializer<Object> jsonSerializer, SerializerProvider serializerProvider) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            Throwable throwable2;
            block5: {
                block4: {
                    try {
                        if (serializerCache._sharedMap.put(new TypeKey(clazz, false), jsonSerializer) != null) break block4;
                        this._readOnlyMap.set(null);
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                }
                if (jsonSerializer instanceof ResolvableSerializer) {
                    ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
                }
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAndResolveNonTypedSerializer(JavaType javaType, JsonSerializer<Object> jsonSerializer, SerializerProvider serializerProvider) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            Throwable throwable2;
            block5: {
                block4: {
                    try {
                        if (serializerCache._sharedMap.put(new TypeKey(javaType, false), jsonSerializer) != null) break block4;
                        this._readOnlyMap.set(null);
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                }
                if (jsonSerializer instanceof ResolvableSerializer) {
                    ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
                }
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAndResolveNonTypedSerializer(Class<?> object, JavaType javaType, JsonSerializer<Object> jsonSerializer, SerializerProvider serializerProvider) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            Throwable throwable2;
            block5: {
                block4: {
                    try {
                        TypeKey typeKey = new TypeKey((Class<?>)object, false);
                        object = this._sharedMap.put(new TypeKey(javaType, false), jsonSerializer);
                        if (serializerCache._sharedMap.put(typeKey, jsonSerializer) == null || object == null) {
                            this._readOnlyMap.set(null);
                        }
                        if (!(jsonSerializer instanceof ResolvableSerializer)) break block4;
                        ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                }
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    public synchronized void flush() {
        this._sharedMap.clear();
    }
}

