/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser;

import com.privatefasterxml.jackson.annotation.JsonInclude;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedClass;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.privatefasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.privatefasterxml.jackson.databind.util.Annotations;
import java.io.Serializable;

public abstract class VirtualBeanPropertyWriter
extends BeanPropertyWriter
implements Serializable {
    private static final long serialVersionUID = 1L;

    public VirtualBeanPropertyWriter(BeanPropertyDefinition beanPropertyDefinition, Annotations annotations, JavaType javaType) {
        VirtualBeanPropertyWriter virtualBeanPropertyWriter = serializable;
        Serializable serializable = beanPropertyDefinition.findInclusion();
        virtualBeanPropertyWriter(beanPropertyDefinition, annotations, javaType, null, null, null, (JsonInclude.Value)serializable);
    }

    public VirtualBeanPropertyWriter() {
    }

    public VirtualBeanPropertyWriter(BeanPropertyDefinition beanPropertyDefinition, Annotations annotations, JavaType javaType, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, JavaType javaType2, JsonInclude.Value value, Class<?>[] classArray) {
        VirtualBeanPropertyWriter virtualBeanPropertyWriter = serializable;
        JsonInclude.Value value2 = value;
        Serializable serializable = beanPropertyDefinition.getPrimaryMember();
        boolean bl = VirtualBeanPropertyWriter._suppressNulls(value2);
        Object object = VirtualBeanPropertyWriter._suppressableValue(value2);
        super(beanPropertyDefinition, (AnnotatedMember)serializable, annotations, javaType, jsonSerializer, typeSerializer, javaType2, bl, object, classArray);
    }

    @Deprecated
    public VirtualBeanPropertyWriter(BeanPropertyDefinition beanPropertyDefinition, Annotations annotations, JavaType javaType, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, JavaType javaType2, JsonInclude.Value value) {
        this(beanPropertyDefinition, annotations, javaType, jsonSerializer, typeSerializer, javaType2, value, null);
    }

    public VirtualBeanPropertyWriter(VirtualBeanPropertyWriter virtualBeanPropertyWriter) {
        super(virtualBeanPropertyWriter);
    }

    public VirtualBeanPropertyWriter(VirtualBeanPropertyWriter virtualBeanPropertyWriter, PropertyName propertyName) {
        super((BeanPropertyWriter)virtualBeanPropertyWriter, propertyName);
    }

    public static boolean _suppressNulls(JsonInclude.Value object) {
        if (object == null) {
            return false;
        }
        return (object = object.getValueInclusion()) != JsonInclude.Include.ALWAYS && object != JsonInclude.Include.USE_DEFAULTS;
    }

    public static Object _suppressableValue(JsonInclude.Value object) {
        if (object == null) {
            return Boolean.FALSE;
        }
        if ((object = object.getValueInclusion()) != JsonInclude.Include.ALWAYS && object != JsonInclude.Include.NON_NULL && object != JsonInclude.Include.USE_DEFAULTS) {
            return BeanPropertyWriter.MARKER_FOR_EMPTY;
        }
        return null;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    public abstract Object value(Object var1, JsonGenerator var2, SerializerProvider var3);

    public abstract VirtualBeanPropertyWriter withConfig(MapperConfig<?> var1, AnnotatedClass var2, BeanPropertyDefinition var3, JavaType var4);

    @Override
    public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        Object object2;
        Object object3 = ((VirtualBeanPropertyWriter)((Object)typeSerializer)).value(object, jsonGenerator, serializerProvider);
        if (object3 == null) {
            if (((BeanPropertyWriter)((Object)typeSerializer))._nullSerializer != null) {
                jsonGenerator.writeFieldName(((BeanPropertyWriter)((Object)typeSerializer))._name);
                ((BeanPropertyWriter)((Object)typeSerializer))._nullSerializer.serialize(null, jsonGenerator, serializerProvider);
            }
            return;
        }
        Object object4 = ((BeanPropertyWriter)((Object)typeSerializer))._serializer;
        if (object4 == null) {
            object2 = ((BeanPropertyWriter)((Object)typeSerializer))._dynamicSerializers;
            object4 = object3.getClass();
            JsonSerializer<Object> jsonSerializer = ((PropertySerializerMap)object2).serializerFor((Class<?>)object4);
            object4 = jsonSerializer == null ? ((BeanPropertyWriter)((Object)typeSerializer))._findAndAddDynamic((PropertySerializerMap)object2, (Class<?>)object4, serializerProvider) : jsonSerializer;
        }
        if ((object2 = ((BeanPropertyWriter)((Object)typeSerializer))._suppressableValue) != null && (BeanPropertyWriter.MARKER_FOR_EMPTY == object2 ? ((JsonSerializer)object4).isEmpty(serializerProvider, object3) : object2.equals(object3))) {
            return;
        }
        if (object3 == object && ((BeanPropertyWriter)((Object)typeSerializer))._handleSelfReference(object, jsonGenerator, serializerProvider, (JsonSerializer<?>)object4)) {
            return;
        }
        jsonGenerator.writeFieldName(((BeanPropertyWriter)((Object)typeSerializer))._name);
        TypeSerializer typeSerializer = ((BeanPropertyWriter)((Object)typeSerializer))._typeSerializer;
        if (typeSerializer == null) {
            ((JsonSerializer)object4).serialize((Object)object3, jsonGenerator, serializerProvider);
        } else {
            ((JsonSerializer)object4).serializeWithType((Object)object3, jsonGenerator, serializerProvider, typeSerializer);
        }
    }

    @Override
    public void serializeAsElement(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        Object object2;
        Object object3;
        Object object4 = ((VirtualBeanPropertyWriter)object3).value(object, jsonGenerator, serializerProvider);
        if (object4 == null) {
            object3 = ((BeanPropertyWriter)object3)._nullSerializer;
            if (object3 != null) {
                ((JsonSerializer)object3).serialize(null, jsonGenerator, serializerProvider);
            } else {
                jsonGenerator.writeNull();
            }
            return;
        }
        Object object5 = ((BeanPropertyWriter)object3)._serializer;
        if (object5 == null) {
            object2 = ((BeanPropertyWriter)object3)._dynamicSerializers;
            object5 = object4.getClass();
            JsonSerializer<Object> jsonSerializer = ((PropertySerializerMap)object2).serializerFor((Class<?>)object5);
            object5 = jsonSerializer == null ? ((BeanPropertyWriter)object3)._findAndAddDynamic((PropertySerializerMap)object2, (Class<?>)object5, serializerProvider) : jsonSerializer;
        }
        if ((object2 = ((BeanPropertyWriter)object3)._suppressableValue) != null) {
            if (BeanPropertyWriter.MARKER_FOR_EMPTY == object2) {
                if (((JsonSerializer)object5).isEmpty(serializerProvider, object4)) {
                    ((BeanPropertyWriter)object3).serializeAsPlaceholder(object, jsonGenerator, serializerProvider);
                    return;
                }
            } else if (object2.equals(object4)) {
                ((BeanPropertyWriter)object3).serializeAsPlaceholder(object, jsonGenerator, serializerProvider);
                return;
            }
        }
        if (object4 == object && ((BeanPropertyWriter)object3)._handleSelfReference(object, jsonGenerator, serializerProvider, (JsonSerializer<?>)object5)) {
            return;
        }
        object3 = ((BeanPropertyWriter)object3)._typeSerializer;
        if (object3 == null) {
            ((JsonSerializer)object5).serialize((Object)object4, jsonGenerator, serializerProvider);
        } else {
            ((JsonSerializer)object5).serializeWithType((Object)object4, jsonGenerator, serializerProvider, (TypeSerializer)object3);
        }
    }
}

