/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.impl;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.type.WritableTypeId;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.privatefasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.privatefasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.privatefasterxml.jackson.databind.util.NameTransformer;
import java.util.Set;

public class BeanAsArraySerializer
extends BeanSerializerBase {
    private static final long serialVersionUID = 1L;
    protected final BeanSerializerBase _defaultSerializer;

    public BeanAsArraySerializer(BeanSerializerBase beanSerializerBase) {
        super(beanSerializerBase, (ObjectIdWriter)null);
        this._defaultSerializer = beanSerializerBase;
    }

    public BeanAsArraySerializer(BeanSerializerBase beanSerializerBase, Set<String> set) {
        this(beanSerializerBase, set, null);
    }

    public BeanAsArraySerializer(BeanSerializerBase beanSerializerBase, Set<String> set, Set<String> set2) {
        super(beanSerializerBase, set, set2);
        this._defaultSerializer = beanSerializerBase;
    }

    public BeanAsArraySerializer(BeanSerializerBase beanSerializerBase, ObjectIdWriter objectIdWriter, Object object) {
        super(beanSerializerBase, objectIdWriter, object);
        this._defaultSerializer = beanSerializerBase;
    }

    private boolean hasSingleElement(SerializerProvider serializerProvider) {
        return (this._filteredProps != null && serializerProvider.getActiveView() != null ? this._filteredProps : this._props).length == 1;
    }

    @Override
    public JsonSerializer<Object> unwrappingSerializer(NameTransformer nameTransformer) {
        return this._defaultSerializer.unwrappingSerializer(nameTransformer);
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return false;
    }

    @Override
    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return this._defaultSerializer.withObjectIdWriter(objectIdWriter);
    }

    @Override
    public BeanSerializerBase withFilterId(Object object) {
        return new BeanAsArraySerializer((BeanSerializerBase)this, this._objectIdWriter, object);
    }

    @Override
    public BeanAsArraySerializer withByNameInclusion(Set<String> set, Set<String> set2) {
        return new BeanAsArraySerializer((BeanSerializerBase)this, set, set2);
    }

    @Override
    public BeanSerializerBase withProperties(BeanPropertyWriter[] beanPropertyWriterArray, BeanPropertyWriter[] beanPropertyWriterArray2) {
        return this;
    }

    @Override
    public BeanSerializerBase asArraySerializer() {
        return this;
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        if (object2._objectIdWriter != null) {
            object2._serializeWithObjectId(object, jsonGenerator, serializerProvider, typeSerializer);
            return;
        }
        BeanAsArraySerializer beanAsArraySerializer = object2;
        BeanAsArraySerializer beanAsArraySerializer2 = object2;
        Object object2 = JsonToken.START_ARRAY;
        object2 = beanAsArraySerializer2._typeIdDef(typeSerializer, object, (JsonToken)((Object)object2));
        typeSerializer.writeTypePrefix(jsonGenerator, (WritableTypeId)object2);
        jsonGenerator.setCurrentValue(object);
        beanAsArraySerializer.serializeAsArray(object, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, (WritableTypeId)object2);
    }

    @Override
    public final void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) && this.hasSingleElement(serializerProvider)) {
            this.serializeAsArray(object, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(object);
        this.serializeAsArray(object, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void serializeAsArray(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2;
        BeanPropertyWriter[] beanPropertyWriterArray = ((BeanSerializerBase)((Object)string))._filteredProps != null && serializerProvider.getActiveView() != null ? ((BeanSerializerBase)((Object)string))._filteredProps : ((BeanSerializerBase)((Object)string))._props;
        try {
            for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
                if (beanPropertyWriter == null) {
                    jsonGenerator.writeNull();
                    continue;
                }
                beanPropertyWriter.serializeAsElement(object, jsonGenerator, serializerProvider);
            }
            return;
        }
        catch (StackOverflowError stackOverflowError) {}
        JsonMappingException jsonMappingException = JsonMappingException.from(jsonGenerator, "Infinite recursion (StackOverflowError)", (Throwable)stackOverflowError);
        jsonMappingException.prependPath(object, beanPropertyWriterArray[n2].getName());
        throw jsonMappingException;
        catch (Exception exception) {}
        BeanAsArraySerializer beanAsArraySerializer = string;
        String string = beanPropertyWriterArray[n2].getName();
        beanAsArraySerializer.wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
    }

    public String toString() {
        return "BeanAsArraySerializer for ".concat(this.handledType().getName());
    }
}

