/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.impl;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.type.WritableTypeId;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StaticListSerializerBase;
import java.util.List;

@JacksonStdImpl
public final class IndexedStringListSerializer
extends StaticListSerializerBase<List<String>> {
    private static final long serialVersionUID = 1L;
    public static final IndexedStringListSerializer instance = new IndexedStringListSerializer();

    public IndexedStringListSerializer() {
        super(List.class);
    }

    public IndexedStringListSerializer(IndexedStringListSerializer indexedStringListSerializer, Boolean bl) {
        super(indexedStringListSerializer, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void serializeContents(List<String> list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            Exception exception2;
            block5: {
                String string;
                block4: {
                    try {
                        string = list.get(i2);
                        if (string != null) break block4;
                    }
                    catch (Exception exception2) {
                        break block5;
                    }
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                jsonGenerator.writeString(string);
                continue;
            }
            this.wrapAndThrow(serializerProvider, (Throwable)exception2, list, i2);
            return;
        }
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
        return new IndexedStringListSerializer(this, bl);
    }

    @Override
    public JsonNode contentSchema() {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptContentVisitor(JsonArrayFormatVisitor jsonArrayFormatVisitor) {
        jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.STRING);
    }

    @Override
    public void serialize(List<String> list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2 = list.size();
        if (n2 == 1 && (this._unwrapSingle == null && serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(list, jsonGenerator, serializerProvider, 1);
            return;
        }
        jsonGenerator.writeStartArray(list, n2);
        this.serializeContents(list, jsonGenerator, serializerProvider, n2);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeWithType(List<String> list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        IndexedStringListSerializer indexedStringListSerializer = writableTypeId;
        TypeSerializer typeSerializer2 = typeSerializer;
        WritableTypeId writableTypeId = typeSerializer2.writeTypePrefix(jsonGenerator, typeSerializer2.typeId(list, JsonToken.START_ARRAY));
        jsonGenerator.setCurrentValue(list);
        int n2 = list.size();
        indexedStringListSerializer.serializeContents(list, jsonGenerator, serializerProvider, n2);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }
}

