/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.impl;

import com.privatefasterxml.jackson.annotation.ObjectIdGenerator;
import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.core.io.SerializedString;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.PropertyName;

public final class ObjectIdWriter {
    public final JavaType idType;
    public final SerializableString propertyName;
    public final ObjectIdGenerator<?> generator;
    public final JsonSerializer<Object> serializer;
    public final boolean alwaysAsId;

    public ObjectIdWriter(JavaType javaType, SerializableString serializableString, ObjectIdGenerator<?> objectIdGenerator, JsonSerializer<?> jsonSerializer, boolean bl) {
        this.idType = javaType;
        this.propertyName = serializableString;
        this.generator = objectIdGenerator;
        this.serializer = jsonSerializer;
        this.alwaysAsId = bl;
    }

    public static ObjectIdWriter construct(JavaType javaType, PropertyName object, ObjectIdGenerator<?> objectIdGenerator, boolean bl) {
        if ((object = object == null ? null : ((PropertyName)object).getSimpleName()) == null) {
            object = null;
        } else {
            SerializedString serializedString;
            SerializedString serializedString2 = serializedString;
            serializedString = new SerializedString((String)object);
            object = serializedString2;
        }
        return new ObjectIdWriter(javaType, (SerializableString)object, objectIdGenerator, null, bl);
    }

    public ObjectIdWriter withSerializer(JsonSerializer<?> jsonSerializer) {
        ObjectIdWriter objectIdWriter = javaType;
        JavaType javaType = objectIdWriter.idType;
        SerializableString serializableString = objectIdWriter.propertyName;
        ObjectIdGenerator<?> objectIdGenerator = objectIdWriter.generator;
        boolean bl = objectIdWriter.alwaysAsId;
        return new ObjectIdWriter(javaType, serializableString, objectIdGenerator, jsonSerializer, bl);
    }

    public ObjectIdWriter withAlwaysAsId(boolean bl) {
        if (bl == ((ObjectIdWriter)((Object)javaType)).alwaysAsId) {
            return javaType;
        }
        ObjectIdWriter objectIdWriter = javaType;
        JavaType javaType = objectIdWriter.idType;
        SerializableString serializableString = objectIdWriter.propertyName;
        ObjectIdGenerator<?> objectIdGenerator = objectIdWriter.generator;
        JsonSerializer<Object> jsonSerializer = objectIdWriter.serializer;
        return new ObjectIdWriter(javaType, serializableString, objectIdGenerator, jsonSerializer, bl);
    }
}

