/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.impl;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.ContainerSerializer;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import com.privatefasterxml.jackson.databind.ser.std.ArraySerializerBase;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.Objects;

@JacksonStdImpl
public class StringArraySerializer
extends ArraySerializerBase<String[]>
implements ContextualSerializer {
    private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(String.class);
    public static final StringArraySerializer instance = new StringArraySerializer();
    protected final JsonSerializer<Object> _elementSerializer;

    public StringArraySerializer() {
        super(String[].class);
        this._elementSerializer = null;
    }

    public StringArraySerializer(StringArraySerializer stringArraySerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, Boolean bl) {
        super(stringArraySerializer, beanProperty, bl);
        this._elementSerializer = jsonSerializer;
    }

    private void serializeContentsSlow(String[] stringArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<Object> jsonSerializer) {
        for (String string : stringArray) {
            if (string == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            jsonSerializer.serialize(string, jsonGenerator, serializerProvider);
        }
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
        JsonSerializer<Object> jsonSerializer = this._elementSerializer;
        return new StringArraySerializer(this, beanProperty, jsonSerializer, bl);
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return this;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        Object object;
        JsonSerializer<Object> jsonSerializer = null;
        if (beanProperty != null) {
            object = serializerProvider.getAnnotationIntrospector();
            AnnotatedMember annotatedMember = beanProperty.getMember();
            if (annotatedMember != null && (object = object.findContentSerializer(annotatedMember)) != null) {
                jsonSerializer = serializerProvider.serializerInstance(annotatedMember, object);
            }
        }
        object = JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED;
        object = this.findFormatFeature(serializerProvider, beanProperty, String[].class, (JsonFormat.Feature)((Object)object));
        if (jsonSerializer == null) {
            jsonSerializer = this._elementSerializer;
        }
        if ((jsonSerializer = this.findContextualConvertingSerializer(serializerProvider, beanProperty, jsonSerializer)) == null) {
            jsonSerializer = serializerProvider.findContentValueSerializer(String.class, beanProperty);
        }
        if (this.isDefaultSerializer(jsonSerializer)) {
            jsonSerializer = null;
        }
        if (jsonSerializer == this._elementSerializer && Objects.equals(object, this._unwrapSingle)) {
            return this;
        }
        return new StringArraySerializer(this, beanProperty, jsonSerializer, (Boolean)object);
    }

    @Override
    public JavaType getContentType() {
        return VALUE_TYPE;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._elementSerializer;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, String[] stringArray) {
        return stringArray.length == 0;
    }

    @Override
    public boolean hasSingleElement(String[] stringArray) {
        return stringArray.length == 1;
    }

    @Override
    public final void serialize(String[] stringArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2 = stringArray.length;
        if (n2 == 1 && (this._unwrapSingle == null && serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(stringArray, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(stringArray, n2);
        this.serializeContents(stringArray, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeContents(String[] stringArray, JsonGenerator jsonGenerator, SerializerProvider object) {
        int n2 = stringArray.length;
        if (n2 == 0) {
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._elementSerializer;
        if (jsonSerializer != null) {
            this.serializeContentsSlow(stringArray, jsonGenerator, (SerializerProvider)object, jsonSerializer);
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            object = stringArray[i2];
            if (object == null) {
                jsonGenerator.writeNull();
                continue;
            }
            jsonGenerator.writeString((String)object);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("array", true).set("items", this.createSchemaNode("string"));
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        StringArraySerializer stringArraySerializer = object;
        Object object = JsonFormatTypes.STRING;
        stringArraySerializer.visitArrayFormat(jsonFormatVisitorWrapper, javaType, (JsonFormatTypes)((Object)object));
    }
}

