/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.impl;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.std.ToEmptyObjectSerializer;
import com.privatefasterxml.jackson.databind.util.NativeImageUtil;

public class UnknownSerializer
extends ToEmptyObjectSerializer {
    public UnknownSerializer() {
        super(Object.class);
    }

    public UnknownSerializer(Class<?> clazz) {
        super(clazz);
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (serializerProvider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(serializerProvider, object);
        }
        super.serialize(object, jsonGenerator, serializerProvider);
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        if (serializerProvider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(serializerProvider, object);
        }
        super.serializeWithType(object, jsonGenerator, serializerProvider, typeSerializer);
    }

    public void failForEmpty(SerializerProvider serializerProvider, Object clazz) {
        Object[] objectArray;
        if (NativeImageUtil.needsReflectionConfiguration(clazz = clazz.getClass())) {
            Class clazz2 = objectArray.handledType();
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = clazz.getName();
            serializerProvider.reportBadDefinition(clazz2, String.format("No serializer found for class %s and no properties discovered to create BeanSerializer (to avoid exception, disable SerializationFeature.FAIL_ON_EMPTY_BEANS). This appears to be a native image, in which case you may need to configure reflection for the class that is to be serialized", objectArray));
        } else {
            Class clazz3 = objectArray.handledType();
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = clazz.getName();
            serializerProvider.reportBadDefinition(clazz3, String.format("No serializer found for class %s and no properties discovered to create BeanSerializer (to avoid exception, disable SerializationFeature.FAIL_ON_EMPTY_BEANS)", objectArray));
        }
    }
}

