/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.impl;

import com.privatefasterxml.jackson.annotation.ObjectIdGenerator;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.ser.impl.ObjectIdWriter;

public final class WritableObjectId {
    public final ObjectIdGenerator<?> generator;
    public Object id;
    protected boolean idWritten = false;

    public WritableObjectId(ObjectIdGenerator<?> objectIdGenerator) {
        this.generator = objectIdGenerator;
    }

    public boolean writeAsId(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, ObjectIdWriter objectIdWriter) {
        if (this.id != null && (this.idWritten || objectIdWriter.alwaysAsId)) {
            if (jsonGenerator.canWriteObjectId()) {
                jsonGenerator.writeObjectRef(String.valueOf(this.id));
            } else {
                objectIdWriter.serializer.serialize(this.id, jsonGenerator, serializerProvider);
            }
            return true;
        }
        return false;
    }

    public Object generateId(Object object) {
        if (this.id == null) {
            this.id = this.generator.generateId(object);
        }
        return this.id;
    }

    public void writeAsField(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, ObjectIdWriter objectIdWriter) {
        ((WritableObjectId)object).idWritten = true;
        if (jsonGenerator.canWriteObjectId()) {
            Object object = ((WritableObjectId)object).id;
            object = object == null ? null : String.valueOf(object);
            jsonGenerator.writeObjectId(object);
            return;
        }
        SerializableString serializableString = objectIdWriter.propertyName;
        if (serializableString != null) {
            jsonGenerator.writeFieldName(serializableString);
            objectIdWriter.serializer.serialize(((WritableObjectId)object).id, jsonGenerator, serializerProvider);
        }
    }
}

