/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.type.WritableTypeId;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.ContainerSerializer;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.Serializable;
import java.util.Objects;

public abstract class ArraySerializerBase<T>
extends ContainerSerializer<T>
implements ContextualSerializer {
    protected final BeanProperty _property;
    protected final Boolean _unwrapSingle;

    public ArraySerializerBase(Class<T> clazz) {
        super(clazz);
        this._property = null;
        this._unwrapSingle = null;
    }

    @Deprecated
    public ArraySerializerBase(Class<T> clazz, BeanProperty beanProperty) {
        super(clazz);
        this._property = beanProperty;
        this._unwrapSingle = null;
    }

    public ArraySerializerBase(ArraySerializerBase<?> arraySerializerBase) {
        super(arraySerializerBase._handledType, false);
        this._property = arraySerializerBase._property;
        this._unwrapSingle = arraySerializerBase._unwrapSingle;
    }

    public ArraySerializerBase(ArraySerializerBase<?> arraySerializerBase, BeanProperty beanProperty, Boolean bl) {
        super(arraySerializerBase._handledType, false);
        this._property = beanProperty;
        this._unwrapSingle = bl;
    }

    @Deprecated
    public ArraySerializerBase(ArraySerializerBase<?> arraySerializerBase, BeanProperty beanProperty) {
        super(arraySerializerBase._handledType, false);
        this._property = beanProperty;
        this._unwrapSingle = arraySerializerBase._unwrapSingle;
    }

    public abstract JsonSerializer<?> _withResolved(BeanProperty var1, Boolean var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty beanProperty) {
        if (beanProperty != null) {
            ArraySerializerBase arraySerializerBase = this;
            Class clazz = arraySerializerBase.handledType();
            if ((object = arraySerializerBase.findFormatOverrides((SerializerProvider)object, beanProperty, clazz)) != null && !Objects.equals(object = ((JsonFormat.Value)object).getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED), this._unwrapSingle)) {
                return this._withResolved(beanProperty, (Boolean)object);
            }
        }
        return this;
    }

    @Override
    public void serialize(T t2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (this._shouldUnwrapSingle(serializerProvider) && this.hasSingleElement(t2)) {
            this.serializeContents(t2, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(t2);
        this.serializeContents(t2, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public final void serializeWithType(T t2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        ArraySerializerBase arraySerializerBase = writableTypeId;
        TypeSerializer typeSerializer2 = typeSerializer;
        WritableTypeId writableTypeId = typeSerializer2.writeTypePrefix(jsonGenerator, typeSerializer2.typeId(t2, JsonToken.START_ARRAY));
        jsonGenerator.setCurrentValue(t2);
        arraySerializerBase.serializeContents(t2, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    public abstract void serializeContents(T var1, JsonGenerator var2, SerializerProvider var3);

    public final boolean _shouldUnwrapSingle(SerializerProvider serializerProvider) {
        Serializable serializable = ((ArraySerializerBase)serializable)._unwrapSingle;
        if (serializable == null) {
            return serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        return (Boolean)serializable;
    }
}

