/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.type.WritableTypeId;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsonschema.JsonSchema;
import com.privatefasterxml.jackson.databind.jsonschema.SchemaAware;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.node.ObjectNode;
import com.privatefasterxml.jackson.databind.ser.ContainerSerializer;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import com.privatefasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Objects;

public abstract class AsArraySerializerBase<T>
extends ContainerSerializer<T>
implements ContextualSerializer {
    protected final JavaType _elementType;
    protected final BeanProperty _property;
    protected final boolean _staticTyping;
    protected final Boolean _unwrapSingle;
    protected final TypeSerializer _valueTypeSerializer;
    protected final JsonSerializer<Object> _elementSerializer;
    protected PropertySerializerMap _dynamicSerializers;

    public AsArraySerializerBase(Class<?> clazz, JavaType javaType, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        this(clazz, javaType, bl, typeSerializer, null, jsonSerializer, null);
    }

    @Deprecated
    public AsArraySerializerBase(Class<?> clazz, JavaType javaType, boolean bl, TypeSerializer typeSerializer, BeanProperty beanProperty, JsonSerializer<Object> jsonSerializer) {
        this(clazz, javaType, bl, typeSerializer, beanProperty, jsonSerializer, null);
    }

    public AsArraySerializerBase(Class<?> clazz, JavaType javaType, boolean bl, TypeSerializer typeSerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, Boolean bl2) {
        super(clazz, false);
        this._elementType = javaType;
        boolean bl3 = bl || javaType != null && javaType.isFinal();
        AsArraySerializerBase asArraySerializerBase = this;
        this._staticTyping = bl3;
        this._valueTypeSerializer = typeSerializer;
        this._property = beanProperty;
        asArraySerializerBase._elementSerializer = jsonSerializer;
        asArraySerializerBase._dynamicSerializers = PropertySerializerMap.emptyForProperties();
        this._unwrapSingle = bl2;
    }

    public AsArraySerializerBase(AsArraySerializerBase<?> asArraySerializerBase, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl) {
        AsArraySerializerBase asArraySerializerBase2 = this;
        super((ContainerSerializer<?>)asArraySerializerBase);
        this._elementType = asArraySerializerBase._elementType;
        this._staticTyping = asArraySerializerBase._staticTyping;
        this._valueTypeSerializer = typeSerializer;
        this._property = beanProperty;
        asArraySerializerBase2._elementSerializer = jsonSerializer;
        asArraySerializerBase2._dynamicSerializers = PropertySerializerMap.emptyForProperties();
        this._unwrapSingle = bl;
    }

    @Deprecated
    public AsArraySerializerBase(AsArraySerializerBase<?> asArraySerializerBase, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer) {
        AsArraySerializerBase<T> asArraySerializerBase2 = serializable;
        Serializable serializable = asArraySerializerBase._unwrapSingle;
        asArraySerializerBase2(asArraySerializerBase, beanProperty, typeSerializer, jsonSerializer, (Boolean)serializable);
    }

    @Deprecated
    public final AsArraySerializerBase<T> withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer) {
        AsArraySerializerBase asArraySerializerBase = serializable;
        Serializable serializable = serializable._unwrapSingle;
        return asArraySerializerBase.withResolved(beanProperty, typeSerializer, jsonSerializer, (Boolean)serializable);
    }

    public abstract AsArraySerializerBase<T> withResolved(BeanProperty var1, TypeSerializer var2, JsonSerializer<?> var3, Boolean var4);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        Object object;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
        }
        JsonSerializer<Object> jsonSerializer = null;
        Boolean bl = null;
        if (beanProperty != null) {
            object = serializerProvider.getAnnotationIntrospector();
            AnnotatedMember annotatedMember = beanProperty.getMember();
            if (annotatedMember != null && (object = ((AnnotationIntrospector)object).findContentSerializer(annotatedMember)) != null) {
                jsonSerializer = serializerProvider.serializerInstance(annotatedMember, object);
            }
        }
        AsArraySerializerBase asArraySerializerBase = this;
        object = asArraySerializerBase.handledType();
        if ((object = asArraySerializerBase.findFormatOverrides(serializerProvider, beanProperty, (Class<?>)object)) != null) {
            bl = ((JsonFormat.Value)object).getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        if (jsonSerializer == null) {
            jsonSerializer = this._elementSerializer;
        }
        if ((jsonSerializer = this.findContextualConvertingSerializer(serializerProvider, beanProperty, jsonSerializer)) == null && (object = this._elementType) != null && this._staticTyping && !((JavaType)object).isJavaLangObject()) {
            jsonSerializer = serializerProvider.findContentValueSerializer(this._elementType, beanProperty);
        }
        if (jsonSerializer == this._elementSerializer && beanProperty == this._property && this._valueTypeSerializer == typeSerializer && Objects.equals(this._unwrapSingle, bl)) {
            return this;
        }
        return this.withResolved(beanProperty, typeSerializer, jsonSerializer, bl);
    }

    @Override
    public JavaType getContentType() {
        return this._elementType;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._elementSerializer;
    }

    @Override
    public void serialize(T t2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) && this.hasSingleElement(t2)) {
            this.serializeContents(t2, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(t2);
        this.serializeContents(t2, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeWithType(T t2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        AsArraySerializerBase asArraySerializerBase = writableTypeId;
        TypeSerializer typeSerializer2 = typeSerializer;
        WritableTypeId writableTypeId = typeSerializer2.writeTypePrefix(jsonGenerator, typeSerializer2.typeId(t2, JsonToken.START_ARRAY));
        jsonGenerator.setCurrentValue(t2);
        asArraySerializerBase.serializeContents(t2, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    public abstract void serializeContents(T var1, JsonGenerator var2, SerializerProvider var3);

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type jsonSerializer) {
        AsArraySerializerBase asArraySerializerBase = serializable;
        Serializable serializable = asArraySerializerBase.createSchemaNode("array", true);
        jsonSerializer = asArraySerializerBase._elementSerializer;
        if (jsonSerializer != null) {
            JsonNode jsonNode = null;
            if (jsonSerializer instanceof SchemaAware) {
                jsonNode = ((SchemaAware)((Object)jsonSerializer)).getSchema(serializerProvider, null);
            }
            if (jsonNode == null) {
                jsonNode = JsonSchema.getDefaultSchemaNode();
            }
            ((ObjectNode)serializable).set("items", jsonNode);
        }
        return serializable;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        JsonSerializer<Object> jsonSerializer = serializable._elementSerializer;
        if (jsonSerializer == null && serializable._elementType != null) {
            Serializable serializable = serializable;
            jsonSerializer = serializable._elementType;
            jsonSerializer = jsonFormatVisitorWrapper.getProvider().findContentValueSerializer((JavaType)((Object)jsonSerializer), serializable._property);
        }
        AsArraySerializerBase asArraySerializerBase = serializable;
        Serializable serializable = asArraySerializerBase._elementType;
        asArraySerializerBase.visitArrayFormat(jsonFormatVisitorWrapper, javaType, jsonSerializer, (JavaType)serializable);
    }

    public final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap object, Class<?> object2, SerializerProvider serializerProvider) {
        PropertySerializerMap propertySerializerMap = object;
        object = this._property;
        object = propertySerializerMap.findAndAddSecondarySerializer((Class<?>)object2, serializerProvider, (BeanProperty)object);
        object2 = ((PropertySerializerMap.SerializerAndMapResult)object).map;
        if (propertySerializerMap != object2) {
            this._dynamicSerializers = object2;
        }
        return ((PropertySerializerMap.SerializerAndMapResult)object).serializer;
    }

    public final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap object, JavaType object2, SerializerProvider serializerProvider) {
        PropertySerializerMap propertySerializerMap = object;
        object = this._property;
        object = propertySerializerMap.findAndAddSecondarySerializer((JavaType)object2, serializerProvider, (BeanProperty)object);
        object2 = ((PropertySerializerMap.SerializerAndMapResult)object).map;
        if (propertySerializerMap != object2) {
            this._dynamicSerializers = object2;
        }
        return ((PropertySerializerMap.SerializerAndMapResult)object).serializer;
    }
}

