/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.privatefasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.privatefasterxml.jackson.databind.ser.std.b;
import java.lang.reflect.Type;

@JacksonStdImpl
public final class BooleanSerializer
extends StdScalarSerializer<Object>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final boolean _forPrimitive;

    public BooleanSerializer(boolean bl) {
        Class<Boolean> clazz = bl ? Boolean.TYPE : Boolean.class;
        super(clazz, false);
        this._forPrimitive = bl;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty beanProperty) {
        BooleanSerializer booleanSerializer = this;
        Class clazz = booleanSerializer.handledType();
        if ((object = booleanSerializer.findFormatOverrides((SerializerProvider)object, beanProperty, clazz)) != null) {
            if (((JsonFormat.Shape)((Object)(object = ((JsonFormat.Value)object).getShape()))).isNumeric()) {
                return new b(this._forPrimitive);
            }
            if (object == JsonFormat.Shape.STRING) {
                return new ToStringSerializer((Class<?>)this._handledType);
            }
        }
        return this;
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeBoolean(Boolean.TRUE.equals(object));
    }

    @Override
    public final void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        jsonGenerator.writeBoolean(Boolean.TRUE.equals(object));
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("boolean", this._forPrimitive ^ true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        jsonFormatVisitorWrapper.expectBooleanFormat(javaType);
    }
}

