/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.type.WritableTypeId;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.Serializable;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ByteArraySerializer
extends StdSerializer<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, byte[] byArray) {
        return byArray.length == 0;
    }

    @Override
    public void serialize(byte[] byArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        Serializable serializable = serializerProvider.getConfig().getBase64Variant();
        int n2 = byArray.length;
        jsonGenerator.writeBinary((Base64Variant)serializable, byArray, 0, n2);
    }

    @Override
    public void serializeWithType(byte[] byArray, JsonGenerator object, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        JsonGenerator jsonGenerator = object;
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix((JsonGenerator)object, typeSerializer.typeId(byArray, JsonToken.VALUE_EMBEDDED_OBJECT));
        object = serializerProvider.getConfig().getBase64Variant();
        int n2 = byArray.length;
        jsonGenerator.writeBinary((Base64Variant)object, byArray, 0, n2);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("array", true).set("items", this.createSchemaNode("byte"));
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        JsonArrayFormatVisitor jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType);
        if (jsonArrayFormatVisitor != null) {
            jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

