/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.privatefasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        ByteBufferBackedInputStream byteBufferBackedInputStream;
        if (((ByteBuffer)object).hasArray()) {
            ByteBuffer byteBuffer = object;
            int n2 = byteBuffer.position();
            ByteBuffer byteBuffer2 = object;
            int n3 = byteBuffer2.arrayOffset() + n2;
            jsonGenerator.writeBinary(byteBuffer.array(), n3, byteBuffer2.limit() - n2);
            return;
        }
        ByteBuffer byteBuffer = ((ByteBuffer)object).asReadOnlyBuffer();
        if (byteBuffer.position() > 0) {
            byteBuffer.rewind();
        }
        object = byteBufferBackedInputStream;
        ((ByteBufferBackedInputStream)object)(byteBuffer);
        jsonGenerator.writeBinary((InputStream)object, byteBuffer.remaining());
        byteBufferBackedInputStream.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        JsonArrayFormatVisitor jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType);
        if (jsonArrayFormatVisitor != null) {
            jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

