/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.privatefasterxml.jackson.databind.util.StdDateFormat;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public abstract class DateTimeSerializerBase<T>
extends StdScalarSerializer<T>
implements ContextualSerializer {
    protected final Boolean _useTimestamp;
    protected final DateFormat _customFormat;
    protected final AtomicReference<DateFormat> _reusedCustomFormat;

    public DateTimeSerializerBase(Class<T> serializable, Boolean bl, DateFormat dateFormat) {
        super(serializable);
        this._useTimestamp = bl;
        this._customFormat = dateFormat;
        if (dateFormat == null) {
            serializable = null;
        } else {
            AtomicReference atomicReference;
            serializable = atomicReference;
            atomicReference = new AtomicReference();
        }
        this._reusedCustomFormat = serializable;
    }

    public abstract DateTimeSerializerBase<T> withFormat(Boolean var1, DateFormat var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty object2) {
        SimpleDateFormat simpleDateFormat;
        DateTimeSerializerBase dateTimeSerializerBase = this;
        Object object3 = dateTimeSerializerBase.handledType();
        if ((object2 = dateTimeSerializerBase.findFormatOverrides((SerializerProvider)object, (BeanProperty)object2, (Class<?>)object3)) == null) {
            return this;
        }
        object3 = ((JsonFormat.Value)object2).getShape();
        if (((JsonFormat.Shape)((Object)object3)).isNumeric()) {
            return this.withFormat(Boolean.TRUE, null);
        }
        if (((JsonFormat.Value)object2).hasPattern()) {
            SimpleDateFormat simpleDateFormat2;
            object3 = ((JsonFormat.Value)object2).hasLocale() ? ((JsonFormat.Value)object2).getLocale() : object.getLocale();
            SimpleDateFormat simpleDateFormat3 = simpleDateFormat2;
            simpleDateFormat2 = new SimpleDateFormat(((JsonFormat.Value)object2).getPattern(), (Locale)object3);
            object = ((JsonFormat.Value)object2).hasTimeZone() ? ((JsonFormat.Value)object2).getTimeZone() : object.getTimeZone();
            simpleDateFormat3.setTimeZone((TimeZone)object);
            return this.withFormat(Boolean.FALSE, simpleDateFormat3);
        }
        Object object4 = object2;
        boolean bl = ((JsonFormat.Value)object4).hasLocale();
        boolean bl2 = ((JsonFormat.Value)object4).hasTimeZone();
        boolean bl3 = object3 == JsonFormat.Shape.STRING;
        if (!(bl || bl2 || bl3)) {
            return this;
        }
        DateFormat dateFormat = object.getConfig().getDateFormat();
        if (dateFormat instanceof StdDateFormat) {
            object = (StdDateFormat)dateFormat;
            if (((JsonFormat.Value)object2).hasLocale()) {
                object = object.withLocale(((JsonFormat.Value)object2).getLocale());
            }
            if (((JsonFormat.Value)object2).hasTimeZone()) {
                object = object.withTimeZone(((JsonFormat.Value)object2).getTimeZone());
            }
            return this.withFormat(Boolean.FALSE, (DateFormat)object);
        }
        if (!(dateFormat instanceof SimpleDateFormat)) {
            Object[] objectArray = object;
            Object[] objectArray2 = new Object[1];
            object = objectArray2;
            objectArray2[0] = dateFormat.getClass().getName();
            objectArray.reportBadDefinition(this.handledType(), String.format("Configured `DateFormat` (%s) not a `SimpleDateFormat`; cannot configure `Locale` or `TimeZone`", object));
        }
        object = (SimpleDateFormat)dateFormat;
        if (bl) {
            SimpleDateFormat simpleDateFormat4;
            simpleDateFormat = simpleDateFormat4;
            object = object.toPattern();
            simpleDateFormat4 = new SimpleDateFormat((String)object, ((JsonFormat.Value)object2).getLocale());
        } else {
            simpleDateFormat = (SimpleDateFormat)object.clone();
        }
        object = ((JsonFormat.Value)object2).getTimeZone();
        if (object != null && !object.equals(simpleDateFormat.getTimeZone())) {
            simpleDateFormat.setTimeZone((TimeZone)object);
        }
        return this.withFormat(Boolean.FALSE, simpleDateFormat);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, T t2) {
        return false;
    }

    public abstract long _timestamp(T var1);

    @Override
    public JsonNode getSchema(SerializerProvider object, Type type) {
        object = this._asTimestamp((SerializerProvider)object) ? "number" : "string";
        return this.createSchemaNode((String)object, true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        this._acceptJsonFormatVisitor(jsonFormatVisitorWrapper, javaType, this._asTimestamp(jsonFormatVisitorWrapper.getProvider()));
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3);

    public boolean _asTimestamp(SerializerProvider serializerProvider) {
        Boolean bl = this._useTimestamp;
        if (bl != null) {
            return bl;
        }
        if (this._customFormat == null) {
            if (serializerProvider != null) {
                return serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            }
            throw new IllegalArgumentException("Null SerializerProvider passed for ".concat(this.handledType().getName()));
        }
        return false;
    }

    public void _acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, boolean bl) {
        Object object;
        if (bl) {
            DateTimeSerializerBase dateTimeSerializerBase = object;
            object = JsonParser.NumberType.LONG;
            JsonValueFormat jsonValueFormat = JsonValueFormat.UTC_MILLISEC;
            dateTimeSerializerBase.visitIntFormat(jsonFormatVisitorWrapper, javaType, (JsonParser.NumberType)((Object)object), jsonValueFormat);
        } else {
            DateTimeSerializerBase dateTimeSerializerBase = object;
            object = JsonValueFormat.DATE_TIME;
            dateTimeSerializerBase.visitStringFormat(jsonFormatVisitorWrapper, javaType, (JsonValueFormat)((Object)object));
        }
    }

    public void _serializeAsString(Date date, JsonGenerator jsonGenerator, SerializerProvider object) {
        if (this._customFormat == null) {
            ((SerializerProvider)object).defaultSerializeDateValue(date, jsonGenerator);
            return;
        }
        object = this._reusedCustomFormat.getAndSet(null);
        if (object == null) {
            object = (DateFormat)this._customFormat.clone();
        }
        jsonGenerator.writeString(((DateFormat)object).format(date));
        this._reusedCustomFormat.compareAndSet(null, (DateFormat)object);
    }
}

