/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DatabindContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.node.ArrayNode;
import com.privatefasterxml.jackson.databind.node.ObjectNode;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdSerializer;
import com.privatefasterxml.jackson.databind.util.EnumValues;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

@JacksonStdImpl
public class EnumSerializer
extends StdScalarSerializer<Enum<?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final EnumValues _values;
    protected final Boolean _serializeAsIndex;

    public EnumSerializer(EnumValues enumValues, Boolean bl) {
        super(enumValues.getEnumClass(), false);
        this._values = enumValues;
        this._serializeAsIndex = bl;
    }

    public static EnumSerializer construct(Class<?> serializable, SerializationConfig serializable2, BeanDescription beanDescription, JsonFormat.Value value) {
        Class<Enum<?>> clazz = serializable;
        serializable = EnumValues.constructFromName(serializable2, serializable);
        serializable2 = EnumSerializer._isShapeWrittenUsingIndex(clazz, value, true, null);
        return new EnumSerializer((EnumValues)serializable, (Boolean)serializable2);
    }

    public static Boolean _isShapeWrittenUsingIndex(Class<?> clazz, JsonFormat.Value object, boolean bl, Boolean object2) {
        if ((object = object == null ? null : ((JsonFormat.Value)object).getShape()) == null) {
            return object2;
        }
        if (object != JsonFormat.Shape.ANY && object != JsonFormat.Shape.SCALAR) {
            if (object != JsonFormat.Shape.STRING && object != JsonFormat.Shape.NATURAL) {
                if (!((JsonFormat.Shape)((Object)object)).isNumeric() && object != JsonFormat.Shape.ARRAY) {
                    IllegalArgumentException illegalArgumentException;
                    object2 = "Unsupported serialization shape (%s) for Enum %s, not supported as %s annotation";
                    Object[] objectArray = new Object[3];
                    Object[] objectArray2 = objectArray;
                    objectArray2[0] = object;
                    objectArray[1] = clazz.getName();
                    int n2 = 2;
                    object = bl ? "class" : "property";
                    IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
                    objectArray2[n2] = object;
                    illegalArgumentException2(String.format((String)object2, objectArray2));
                    throw illegalArgumentException2;
                }
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return object2;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty beanProperty) {
        EnumSerializer enumSerializer = this;
        Class clazz = enumSerializer.handledType();
        if ((object = enumSerializer.findFormatOverrides((SerializerProvider)object, beanProperty, clazz)) != null && !Objects.equals(object = EnumSerializer._isShapeWrittenUsingIndex(this.handledType(), (JsonFormat.Value)object, false, this._serializeAsIndex), this._serializeAsIndex)) {
            return new EnumSerializer(this._values, (Boolean)object);
        }
        return this;
    }

    public EnumValues getEnumValues() {
        return this._values;
    }

    @Override
    public final void serialize(Enum<?> enum_, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (this._serializeAsIndex(serializerProvider)) {
            jsonGenerator.writeNumber(enum_.ordinal());
            return;
        }
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
            jsonGenerator.writeString(enum_.toString());
            return;
        }
        jsonGenerator.writeString(this._values.serializedValueFor(enum_));
    }

    @Override
    public JsonNode getSchema(SerializerProvider object, Type type) {
        if (((EnumSerializer)serializable)._serializeAsIndex((SerializerProvider)object)) {
            return ((StdSerializer)serializable).createSchemaNode("integer", true);
        }
        ObjectNode objectNode = ((StdSerializer)serializable).createSchemaNode("string", true);
        if (type != null && ((DatabindContext)object).constructType(type).isEnumType()) {
            EnumSerializer enumSerializer = serializable;
            Serializable serializable = objectNode.putArray("enum");
            object = enumSerializer._values.values().iterator();
            while (object.hasNext()) {
                ((ArrayNode)serializable).add(((SerializableString)object.next()).getValue());
            }
        }
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper object, JavaType serializable) {
        Object object2;
        SerializerProvider serializerProvider = object.getProvider();
        if (((EnumSerializer)object2)._serializeAsIndex(serializerProvider)) {
            EnumSerializer enumSerializer = object2;
            object2 = JsonParser.NumberType.INT;
            enumSerializer.visitIntFormat((JsonFormatVisitorWrapper)object, (JavaType)serializable, (JsonParser.NumberType)((Object)object2));
            return;
        }
        if ((object = object.expectStringFormat((JavaType)serializable)) != null) {
            LinkedHashSet linkedHashSet;
            serializable = linkedHashSet;
            linkedHashSet = new LinkedHashSet();
            if (serializerProvider != null && serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
                object2 = ((EnumSerializer)object2)._values.enums().iterator();
                while (object2.hasNext()) {
                    serializable.add(((Enum)object2.next()).toString());
                }
            } else {
                object2 = ((EnumSerializer)object2)._values.values().iterator();
                while (object2.hasNext()) {
                    serializable.add(((SerializableString)object2.next()).getValue());
                }
            }
            object.enumTypes((Set<String>)((Object)serializable));
        }
    }

    public final boolean _serializeAsIndex(SerializerProvider serializerProvider) {
        Serializable serializable = ((EnumSerializer)serializable)._serializeAsIndex;
        if (serializable != null) {
            return (Boolean)serializable;
        }
        return serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
    }
}

