/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Iterator;

public class EnumSetSerializer
extends AsArraySerializerBase<EnumSet<? extends Enum<?>>> {
    public EnumSetSerializer(JavaType javaType) {
        super(EnumSet.class, javaType, true, null, null);
    }

    public EnumSetSerializer(EnumSetSerializer enumSetSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl) {
        super(enumSetSerializer, beanProperty, typeSerializer, jsonSerializer, bl);
    }

    public EnumSetSerializer _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return this;
    }

    public EnumSetSerializer withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl) {
        return new EnumSetSerializer(this, beanProperty, typeSerializer, jsonSerializer, bl);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, EnumSet<? extends Enum<?>> enumSet) {
        return enumSet.isEmpty();
    }

    @Override
    public boolean hasSingleElement(EnumSet<? extends Enum<?>> enumSet) {
        return enumSet.size() == 1;
    }

    @Override
    public final void serialize(EnumSet<? extends Enum<?>> enumSet, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2 = enumSet.size();
        if (n2 == 1 && (this._unwrapSingle == null && serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(enumSet, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(enumSet, n2);
        this.serializeContents(enumSet, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeContents(EnumSet<? extends Enum<?>> object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        JsonSerializer<Object> jsonSerializer = object;
        object = this._elementSerializer;
        Iterator iterator = ((AbstractCollection)((Object)jsonSerializer)).iterator();
        while (iterator.hasNext()) {
            Enum enum_ = (Enum)iterator.next();
            if (object == null) {
                object = enum_.getDeclaringClass();
                object = serializerProvider.findContentValueSerializer((Class<?>)((Object)object), this._property);
            }
            object.serialize(enum_, jsonGenerator, serializerProvider);
        }
    }
}

