/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.type.WritableTypeId;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.net.InetAddress;

public class InetAddressSerializer
extends StdScalarSerializer<InetAddress>
implements ContextualSerializer {
    protected final boolean _asNumeric;

    public InetAddressSerializer() {
        this(false);
    }

    public InetAddressSerializer(boolean bl) {
        super(InetAddress.class);
        this._asNumeric = bl;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty beanProperty) {
        InetAddressSerializer inetAddressSerializer = this;
        Class clazz = inetAddressSerializer.handledType();
        object = inetAddressSerializer.findFormatOverrides((SerializerProvider)object, beanProperty, clazz);
        boolean bl = false;
        if (object != null && (((JsonFormat.Shape)((Object)(object = ((JsonFormat.Value)object).getShape()))).isNumeric() || object == JsonFormat.Shape.ARRAY)) {
            bl = true;
        }
        if (bl != this._asNumeric) {
            return new InetAddressSerializer(bl);
        }
        return this;
    }

    @Override
    public void serialize(InetAddress inetAddress, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        Object object;
        if (((InetAddressSerializer)object)._asNumeric) {
            object = inetAddress.getHostAddress();
        } else {
            object = inetAddress.toString().trim();
            int n2 = ((String)object).indexOf(47);
            if (n2 >= 0) {
                object = n2 == 0 ? ((String)object).substring(1) : ((String)object).substring(0, n2);
            }
        }
        jsonGenerator.writeString((String)object);
    }

    @Override
    public void serializeWithType(InetAddress inetAddress, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        InetAddressSerializer inetAddressSerializer = object;
        TypeSerializer typeSerializer2 = typeSerializer;
        Object object = JsonToken.VALUE_STRING;
        object = typeSerializer2.writeTypePrefix(jsonGenerator, typeSerializer2.typeId((Object)inetAddress, InetAddress.class, (JsonToken)((Object)object)));
        inetAddressSerializer.serialize(inetAddress, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, (WritableTypeId)object);
    }
}

