/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.ContainerSerializer;
import com.privatefasterxml.jackson.databind.ser.std.AsArraySerializerBase;

@JacksonStdImpl
public class IterableSerializer
extends AsArraySerializerBase<Iterable<?>> {
    public IterableSerializer(JavaType javaType, boolean bl, TypeSerializer typeSerializer) {
        super(Iterable.class, javaType, bl, typeSerializer, null);
    }

    public IterableSerializer(IterableSerializer iterableSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl) {
        super(iterableSerializer, beanProperty, typeSerializer, jsonSerializer, bl);
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
        IterableSerializer iterableSerializer = this;
        BeanProperty beanProperty = iterableSerializer._property;
        JsonSerializer<Object> jsonSerializer = iterableSerializer._elementSerializer;
        Boolean bl = iterableSerializer._unwrapSingle;
        return new IterableSerializer(this, beanProperty, typeSerializer, jsonSerializer, bl);
    }

    public IterableSerializer withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl) {
        return new IterableSerializer(this, beanProperty, typeSerializer, jsonSerializer, bl);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Iterable<?> iterable) {
        return iterable.iterator().hasNext() ^ true;
    }

    @Override
    public boolean hasSingleElement(Iterable<?> iterable) {
        if (iterable != null && (this = iterable.iterator()).hasNext()) {
            Object object = this;
            object.next();
            if (!object.hasNext()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final void serialize(Iterable<?> iterable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if ((this._unwrapSingle == null && serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE) && this.hasSingleElement(iterable)) {
            this.serializeContents(iterable, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(iterable);
        this.serializeContents(iterable, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeContents(Iterable<?> object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if ((object = object.iterator()).hasNext()) {
            TypeSerializer typeSerializer = this._valueTypeSerializer;
            JsonSerializer<Object> jsonSerializer = null;
            JsonSerializer<Object> jsonSerializer2 = null;
            do {
                Object e2;
                if ((e2 = object.next()) == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                Object object2 = this._elementSerializer;
                if (object2 == null) {
                    object2 = e2.getClass();
                    if (object2 == jsonSerializer2) {
                        object2 = jsonSerializer2;
                        jsonSerializer2 = jsonSerializer;
                    } else {
                        jsonSerializer2 = jsonSerializer = serializerProvider.findValueSerializer((Class<?>)object2, this._property);
                    }
                } else {
                    JsonSerializer<Object> jsonSerializer3 = object2;
                    object2 = jsonSerializer2;
                    jsonSerializer2 = jsonSerializer;
                    jsonSerializer = jsonSerializer3;
                }
                if (typeSerializer == null) {
                    jsonSerializer.serialize(e2, jsonGenerator, serializerProvider);
                } else {
                    jsonSerializer.serializeWithType(e2, jsonGenerator, serializerProvider, typeSerializer);
                }
                JsonSerializer<Object> jsonSerializer4 = jsonSerializer2;
                jsonSerializer2 = object2;
                jsonSerializer = jsonSerializer4;
            } while (object.hasNext());
        }
    }
}

