/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.type.WritableTypeId;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.RuntimeJsonMappingException;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsonschema.JsonSchema;
import com.privatefasterxml.jackson.databind.jsonschema.SchemaAware;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import com.privatefasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.privatefasterxml.jackson.databind.ser.std.StdSerializer;
import com.privatefasterxml.jackson.databind.ser.std.c;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;

@JacksonStdImpl
public class JsonValueSerializer
extends StdSerializer<Object>
implements ContextualSerializer,
JsonFormatVisitable,
SchemaAware {
    protected final AnnotatedMember _accessor;
    protected final TypeSerializer _valueTypeSerializer;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final BeanProperty _property;
    protected final JavaType _valueType;
    protected final boolean _forceTypeInformation;
    protected transient PropertySerializerMap _dynamicSerializers;

    public JsonValueSerializer(AnnotatedMember annotatedMember, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer) {
        JsonValueSerializer jsonValueSerializer = this;
        super(annotatedMember.getType());
        this._accessor = annotatedMember;
        this._valueType = annotatedMember.getType();
        this._valueTypeSerializer = typeSerializer;
        jsonValueSerializer._valueSerializer = jsonSerializer;
        jsonValueSerializer._property = null;
        jsonValueSerializer._forceTypeInformation = true;
        jsonValueSerializer._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    @Deprecated
    public JsonValueSerializer(AnnotatedMember annotatedMember, JsonSerializer<?> jsonSerializer) {
        this(annotatedMember, null, jsonSerializer);
    }

    public JsonValueSerializer(JsonValueSerializer jsonValueSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, boolean bl) {
        JsonValueSerializer jsonValueSerializer2 = this;
        super(JsonValueSerializer._notNullClass(jsonValueSerializer.handledType()));
        this._accessor = jsonValueSerializer._accessor;
        this._valueType = jsonValueSerializer._valueType;
        this._valueTypeSerializer = typeSerializer;
        this._valueSerializer = jsonSerializer;
        this._property = beanProperty;
        jsonValueSerializer2._forceTypeInformation = bl;
        jsonValueSerializer2._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    private static final Class<Object> _notNullClass(Class<?> clazz) {
        if (clazz == null) {
            clazz = Object.class;
        }
        return clazz;
    }

    public JsonValueSerializer withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, boolean bl) {
        if (this._property == beanProperty && this._valueTypeSerializer == typeSerializer && this._valueSerializer == jsonSerializer && bl == this._forceTypeInformation) {
            return this;
        }
        return new JsonValueSerializer(this, beanProperty, typeSerializer, jsonSerializer, bl);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Object object) {
        if ((object = this._accessor.getValue(object)) == null) {
            return true;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            try {
                jsonSerializer = this._findDynamicSerializer(serializerProvider, object.getClass());
            }
            catch (JsonMappingException jsonMappingException) {
                throw new RuntimeJsonMappingException(jsonMappingException);
            }
        }
        return jsonSerializer.isEmpty(serializerProvider, object);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        JsonSerializer jsonSerializer;
        JsonSerializer<Object> jsonSerializer2;
        TypeSerializer typeSerializer = jsonSerializer._valueTypeSerializer;
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
        }
        if ((jsonSerializer2 = jsonSerializer._valueSerializer) == null) {
            if (!serializerProvider.isEnabled(MapperFeature.USE_STATIC_TYPING) && !jsonSerializer._valueType.isFinal()) {
                if (beanProperty != jsonSerializer._property) {
                    boolean bl = jsonSerializer._forceTypeInformation;
                    return jsonSerializer.withResolved(beanProperty, typeSerializer, jsonSerializer2, bl);
                }
                return jsonSerializer;
            }
            JsonValueSerializer jsonValueSerializer = jsonSerializer;
            JsonValueSerializer jsonValueSerializer2 = jsonSerializer;
            jsonSerializer = serializerProvider.findPrimaryPropertySerializer(jsonSerializer._valueType, beanProperty);
            boolean bl = jsonValueSerializer2.isNaturalTypeWithStdHandling(jsonValueSerializer2._valueType.getRawClass(), jsonSerializer);
            return jsonValueSerializer.withResolved(beanProperty, typeSerializer, jsonSerializer, bl);
        }
        JsonValueSerializer jsonValueSerializer = jsonSerializer;
        JsonValueSerializer jsonValueSerializer3 = jsonSerializer;
        jsonSerializer = serializerProvider.handlePrimaryContextualization(jsonSerializer2, beanProperty);
        boolean bl = jsonValueSerializer3._forceTypeInformation;
        return jsonValueSerializer.withResolved(beanProperty, typeSerializer, jsonSerializer, bl);
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        try {
            object = ((JsonValueSerializer)this)._accessor.getValue(object);
        }
        catch (Exception exception) {
            Object var5_6 = null;
            String string = ((JsonValueSerializer)this)._accessor.getName() + "()";
            ((StdSerializer)this).wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
            object = var5_6;
        }
        if (object == null) {
            serializerProvider.defaultSerializeNull(jsonGenerator);
        } else {
            JsonSerializer<Object> jsonSerializer = ((JsonValueSerializer)this)._valueSerializer;
            if (jsonSerializer == null) {
                jsonSerializer = ((JsonValueSerializer)this)._findDynamicSerializer(serializerProvider, object.getClass());
            }
            if ((this = ((JsonValueSerializer)this)._valueTypeSerializer) != null) {
                jsonSerializer.serializeWithType(object, jsonGenerator, serializerProvider, (TypeSerializer)this);
            } else {
                jsonSerializer.serialize(object, jsonGenerator, serializerProvider);
            }
        }
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        c c2;
        Object object2;
        JsonSerializer<Object> jsonSerializer;
        JsonSerializer<Object> jsonSerializer2;
        try {
            jsonSerializer2 = ((JsonValueSerializer)object2)._accessor.getValue(object);
        }
        catch (Exception exception) {
            jsonSerializer = null;
            String string = ((JsonValueSerializer)object2)._accessor.getName() + "()";
            ((StdSerializer)object2).wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
            jsonSerializer2 = jsonSerializer;
        }
        if (jsonSerializer2 == null) {
            serializerProvider.defaultSerializeNull(jsonGenerator);
            return;
        }
        jsonSerializer = ((JsonValueSerializer)object2)._valueSerializer;
        if (jsonSerializer == null) {
            jsonSerializer = ((JsonValueSerializer)object2)._findDynamicSerializer(serializerProvider, jsonSerializer2.getClass());
        } else if (((JsonValueSerializer)object2)._forceTypeInformation) {
            TypeSerializer typeSerializer2 = typeSerializer;
            object2 = typeSerializer2.writeTypePrefix(jsonGenerator, typeSerializer2.typeId(object, JsonToken.VALUE_STRING));
            jsonSerializer.serialize(jsonSerializer2, jsonGenerator, serializerProvider);
            typeSerializer.writeTypeSuffix(jsonGenerator, (WritableTypeId)object2);
            return;
        }
        object2 = c2;
        c2 = new c(typeSerializer, object);
        jsonSerializer.serializeWithType(jsonSerializer2, jsonGenerator, serializerProvider, (TypeSerializer)object2);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        JsonSerializer jsonSerializer = jsonSerializer._valueSerializer;
        if (jsonSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)jsonSerializer)).getSchema(serializerProvider, null);
        }
        return JsonSchema.getDefaultSchemaNode();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        JsonSerializer<Object> jsonSerializer = this._accessor.getDeclaringClass();
        if (jsonSerializer != null && ClassUtil.isEnumType(jsonSerializer) && this._acceptJsonFormatVisitorForEnum(jsonFormatVisitorWrapper, javaType, (Class<?>)((Object)jsonSerializer))) {
            return;
        }
        jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            JsonValueSerializer jsonValueSerializer = this;
            jsonSerializer = jsonValueSerializer._valueType;
            BeanProperty beanProperty = jsonValueSerializer._property;
            jsonSerializer = jsonFormatVisitorWrapper.getProvider().findTypedValueSerializer((JavaType)((Object)jsonSerializer), false, beanProperty);
            if (jsonSerializer == null) {
                jsonFormatVisitorWrapper.expectAnyFormat(javaType);
                return;
            }
        }
        jsonSerializer.acceptJsonFormatVisitor(jsonFormatVisitorWrapper, this._valueType);
    }

    public boolean _acceptJsonFormatVisitorForEnum(JsonFormatVisitorWrapper object, JavaType serializable, Class<?> objArray) {
        if ((object = object.expectStringFormat((JavaType)serializable)) != null) {
            LinkedHashSet linkedHashSet;
            serializable = linkedHashSet;
            linkedHashSet = new LinkedHashSet();
            for (Object obj : objArray.getEnumConstants()) {
                try {
                    serializable.add(String.valueOf(this._accessor.getValue(obj)));
                }
                catch (Exception exception) {
                    Throwable throwable;
                    while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                        throwable = throwable.getCause();
                    }
                    ClassUtil.throwIfError(throwable);
                    throw JsonMappingException.wrapWithPath(throwable, obj, this._accessor.getName() + "()");
                }
            }
            object.enumTypes((Set<String>)((Object)serializable));
        }
        return true;
    }

    public boolean isNaturalTypeWithStdHandling(Class<?> clazz, JsonSerializer<?> jsonSerializer) {
        if (clazz.isPrimitive() ? clazz != Integer.TYPE && clazz != Boolean.TYPE && clazz != Double.TYPE : clazz != String.class && clazz != Integer.class && clazz != Boolean.class && clazz != Double.class) {
            return false;
        }
        return this.isDefaultSerializer(jsonSerializer);
    }

    public JsonSerializer<Object> _findDynamicSerializer(SerializerProvider serializerProvider, Class<?> clazz) {
        JsonSerializer<Object> jsonSerializer = serializable._dynamicSerializers.serializerFor(clazz);
        if (jsonSerializer == null) {
            if (serializable._valueType.hasGenericTypes()) {
                JsonValueSerializer jsonValueSerializer = serializable;
                JsonValueSerializer jsonValueSerializer2 = serializable;
                Serializable serializable = serializerProvider.constructSpecializedType(serializable._valueType, clazz);
                jsonSerializer = serializerProvider.findPrimaryPropertySerializer((JavaType)serializable, jsonValueSerializer2._property);
                jsonValueSerializer._dynamicSerializers = jsonValueSerializer._dynamicSerializers.addSerializer((JavaType)serializable, jsonSerializer).map;
            } else {
                jsonSerializer = serializerProvider.findPrimaryPropertySerializer(clazz, serializable._property);
                serializable._dynamicSerializers = serializable._dynamicSerializers.addSerializer(clazz, jsonSerializer).map;
            }
        }
        return jsonSerializer;
    }

    public String toString() {
        return "(@JsonValue serializer for method " + this._accessor.getDeclaringClass() + "#" + this._accessor.getName() + ")";
    }
}

