/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.PropertyMetadata;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.node.ObjectNode;
import com.privatefasterxml.jackson.databind.ser.PropertyWriter;
import java.lang.annotation.Annotation;

public class MapProperty
extends PropertyWriter {
    private static final long serialVersionUID = 1L;
    private static final BeanProperty BOGUS_PROP = new BeanProperty.Bogus();
    protected final TypeSerializer _typeSerializer;
    protected final BeanProperty _property;
    protected Object _key;
    protected Object _value;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _valueSerializer;

    public MapProperty(TypeSerializer typeSerializer, BeanProperty beanProperty) {
        PropertyMetadata propertyMetadata = beanProperty == null ? PropertyMetadata.STD_REQUIRED_OR_OPTIONAL : beanProperty.getMetadata();
        super(propertyMetadata);
        this._typeSerializer = typeSerializer;
        if (beanProperty == null) {
            beanProperty = BOGUS_PROP;
        }
        this._property = beanProperty;
    }

    public void reset(Object object, Object object2, JsonSerializer<Object> jsonSerializer, JsonSerializer<Object> jsonSerializer2) {
        MapProperty mapProperty = this;
        mapProperty._key = object;
        mapProperty._value = object2;
        mapProperty._keySerializer = jsonSerializer;
        mapProperty._valueSerializer = jsonSerializer2;
    }

    @Deprecated
    public void reset(Object object, JsonSerializer<Object> jsonSerializer, JsonSerializer<Object> jsonSerializer2) {
        MapProperty mapProperty = this;
        mapProperty.reset(object, mapProperty._value, jsonSerializer, jsonSerializer2);
    }

    @Override
    public String getName() {
        Object object = ((MapProperty)object)._key;
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object object) {
        this._value = object;
    }

    @Override
    public PropertyName getFullName() {
        return new PropertyName(this.getName());
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this._property.getAnnotation(clazz);
    }

    @Override
    public <A extends Annotation> A getContextAnnotation(Class<A> clazz) {
        return this._property.getContextAnnotation(clazz);
    }

    @Override
    public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        MapProperty mapProperty = this;
        mapProperty._keySerializer.serialize(this._key, jsonGenerator, serializerProvider);
        object = mapProperty._typeSerializer;
        if (object == null) {
            this._valueSerializer.serialize(this._value, jsonGenerator, serializerProvider);
        } else {
            this._valueSerializer.serializeWithType(this._value, jsonGenerator, serializerProvider, (TypeSerializer)object);
        }
    }

    @Override
    public void serializeAsOmittedField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (!jsonGenerator.canOmitFields()) {
            jsonGenerator.writeOmittedField(this.getName());
        }
    }

    @Override
    public void serializeAsElement(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        object = this._typeSerializer;
        if (object == null) {
            this._valueSerializer.serialize(this._value, jsonGenerator, serializerProvider);
        } else {
            this._valueSerializer.serializeWithType(this._value, jsonGenerator, serializerProvider, (TypeSerializer)object);
        }
    }

    @Override
    public void serializeAsPlaceholder(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeNull();
    }

    @Override
    public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) {
        this._property.depositSchemaProperty(jsonObjectFormatVisitor, serializerProvider);
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(ObjectNode objectNode, SerializerProvider serializerProvider) {
    }

    @Override
    public JavaType getType() {
        return this._property.getType();
    }

    @Override
    public PropertyName getWrapperName() {
        return this._property.getWrapperName();
    }

    @Override
    public AnnotatedMember getMember() {
        return this._property.getMember();
    }
}

