/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdSerializer;
import java.lang.reflect.Type;

@JacksonStdImpl
public class NullSerializer
extends StdSerializer<Object> {
    public static final NullSerializer instance = new NullSerializer();

    private NullSerializer() {
        super(Object.class);
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeNull();
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        jsonGenerator.writeNull();
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("null");
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        jsonFormatVisitorWrapper.expectNullFormat(javaType);
    }
}

