/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.privatefasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.privatefasterxml.jackson.databind.ser.std.e;
import com.privatefasterxml.jackson.databind.ser.std.f;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

@JacksonStdImpl
public class NumberSerializer
extends StdScalarSerializer<Number>
implements ContextualSerializer {
    public static final NumberSerializer instance = new NumberSerializer((Class<? extends Number>)Number.class);
    protected static final int MAX_BIG_DECIMAL_SCALE = 9999;
    protected final boolean _isInt;

    public NumberSerializer(Class<? extends Number> clazz) {
        super(clazz, false);
        boolean bl = clazz == BigInteger.class;
        this._isInt = bl;
    }

    public static JsonSerializer<?> bigDecimalAsStringSerializer() {
        return f.a;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty beanProperty) {
        NumberSerializer numberSerializer = this;
        Class clazz = numberSerializer.handledType();
        if ((object = numberSerializer.findFormatOverrides((SerializerProvider)object, beanProperty, clazz)) != null && e.a[((JsonFormat.Value)object).getShape().ordinal()] == 1) {
            if (this.handledType() == BigDecimal.class) {
                return NumberSerializer.bigDecimalAsStringSerializer();
            }
            return ToStringSerializer.instance;
        }
        return this;
    }

    @Override
    public void serialize(Number number, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (number instanceof BigDecimal) {
            jsonGenerator.writeNumber((BigDecimal)number);
        } else if (number instanceof BigInteger) {
            jsonGenerator.writeNumber((BigInteger)number);
        } else if (number instanceof Long) {
            jsonGenerator.writeNumber(number.longValue());
        } else if (number instanceof Double) {
            jsonGenerator.writeNumber(number.doubleValue());
        } else if (number instanceof Float) {
            jsonGenerator.writeNumber(number.floatValue());
        } else if (!(number instanceof Integer || number instanceof Byte || number instanceof Short)) {
            jsonGenerator.writeNumber(number.toString());
        } else {
            jsonGenerator.writeNumber(number.intValue());
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider object, Type type) {
        object = this._isInt ? "integer" : "number";
        return this.createSchemaNode((String)object, true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        Object object;
        if (object._isInt) {
            NumberSerializer numberSerializer = object;
            object = JsonParser.NumberType.BIG_INTEGER;
            numberSerializer.visitIntFormat(jsonFormatVisitorWrapper, javaType, (JsonParser.NumberType)((Object)object));
        } else if (object.handledType() == BigDecimal.class) {
            NumberSerializer numberSerializer = object;
            object = JsonParser.NumberType.BIG_DECIMAL;
            numberSerializer.visitFloatFormat(jsonFormatVisitorWrapper, javaType, (JsonParser.NumberType)((Object)object));
        } else {
            jsonFormatVisitorWrapper.expectNumberFormat(javaType);
        }
    }
}

