/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.io.NumberOutput;
import com.privatefasterxml.jackson.core.type.WritableTypeId;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import com.privatefasterxml.jackson.databind.ser.std.NumberSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.privatefasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.privatefasterxml.jackson.databind.ser.std.g;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Map;

public class NumberSerializers {
    public static void addAll(Map<String, JsonSerializer<?>> serializable) {
        Map<String, JsonSerializer<?>> map = serializable;
        map.put(Integer.class.getName(), new IntegerSerializer(Integer.class));
        serializable = Integer.TYPE;
        map.put(serializable.getName(), new IntegerSerializer((Class<?>)serializable));
        map.put(Long.class.getName(), new LongSerializer(Long.class));
        serializable = Long.TYPE;
        map.put(serializable.getName(), new LongSerializer((Class<?>)serializable));
        serializable = IntLikeSerializer.instance;
        map.put(Byte.class.getName(), (JsonSerializer<?>)((Object)serializable));
        map.put(Byte.TYPE.getName(), (JsonSerializer<?>)((Object)serializable));
        serializable = ShortSerializer.instance;
        map.put(Short.class.getName(), (JsonSerializer<?>)((Object)serializable));
        map.put(Short.TYPE.getName(), (JsonSerializer<?>)((Object)serializable));
        map.put(Double.class.getName(), new DoubleSerializer(Double.class));
        serializable = Double.TYPE;
        map.put(serializable.getName(), new DoubleSerializer((Class<?>)serializable));
        serializable = FloatSerializer.instance;
        map.put(Float.class.getName(), (JsonSerializer<?>)((Object)serializable));
        map.put(Float.TYPE.getName(), (JsonSerializer<?>)((Object)serializable));
    }

    @JacksonStdImpl
    public static class IntegerSerializer
    extends Base<Object> {
        public IntegerSerializer(Class<?> clazz) {
            super(clazz, JsonParser.NumberType.INT, "integer");
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeNumber((Integer)object);
        }

        @Override
        public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
            this.serialize(object, jsonGenerator, serializerProvider);
        }
    }

    @JacksonStdImpl
    public static class LongSerializer
    extends Base<Object> {
        public LongSerializer(Class<?> clazz) {
            super(clazz, JsonParser.NumberType.LONG, "number");
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeNumber((Long)object);
        }
    }

    @JacksonStdImpl
    public static class IntLikeSerializer
    extends Base<Object> {
        static final IntLikeSerializer instance = new IntLikeSerializer();

        public IntLikeSerializer() {
            super(Number.class, JsonParser.NumberType.INT, "integer");
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeNumber(((Number)object).intValue());
        }
    }

    @JacksonStdImpl
    public static class ShortSerializer
    extends Base<Object> {
        static final ShortSerializer instance = new ShortSerializer();

        public ShortSerializer() {
            super(Short.class, JsonParser.NumberType.INT, "number");
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeNumber((Short)object);
        }
    }

    @JacksonStdImpl
    public static class DoubleSerializer
    extends Base<Object> {
        public DoubleSerializer(Class<?> clazz) {
            super(clazz, JsonParser.NumberType.DOUBLE, "number");
        }

        @Deprecated
        public static boolean notFinite(double d2) {
            return NumberOutput.notFinite(d2);
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeNumber((Double)object);
        }

        @Override
        public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
            Object object2 = (Double)object;
            if (NumberOutput.notFinite((Double)object2)) {
                JsonGenerator jsonGenerator2 = jsonGenerator;
                Serializable serializable = object2;
                object2 = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(object, JsonToken.VALUE_NUMBER_FLOAT));
                jsonGenerator2.writeNumber((Double)serializable);
                typeSerializer.writeTypeSuffix(jsonGenerator2, (WritableTypeId)object2);
            } else {
                jsonGenerator.writeNumber((Double)object2);
            }
        }
    }

    @JacksonStdImpl
    public static class FloatSerializer
    extends Base<Object> {
        static final FloatSerializer instance = new FloatSerializer();

        public FloatSerializer() {
            super(Float.class, JsonParser.NumberType.FLOAT, "number");
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeNumber(((Float)object).floatValue());
        }
    }

    public static abstract class Base<T>
    extends StdScalarSerializer<T>
    implements ContextualSerializer {
        protected final JsonParser.NumberType _numberType;
        protected final String _schemaType;
        protected final boolean _isInt;

        public Base(Class<?> clazz, JsonParser.NumberType numberType, String string) {
            super(clazz, false);
            this._numberType = numberType;
            this._schemaType = string;
            boolean bl = numberType == JsonParser.NumberType.INT || numberType == JsonParser.NumberType.LONG || numberType == JsonParser.NumberType.BIG_INTEGER;
            this._isInt = bl;
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            Base base = this;
            return base.createSchemaNode(base._schemaType, true);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            Object object;
            if (object._isInt) {
                Base base = object;
                object = base._numberType;
                base.visitIntFormat(jsonFormatVisitorWrapper, javaType, (JsonParser.NumberType)((Object)object));
            } else {
                Base base = object;
                object = base._numberType;
                base.visitFloatFormat(jsonFormatVisitorWrapper, javaType, (JsonParser.NumberType)((Object)object));
            }
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty beanProperty) {
            Base base = this;
            Class clazz = base.handledType();
            if ((object = base.findFormatOverrides((SerializerProvider)object, beanProperty, clazz)) != null && g.a[((JsonFormat.Value)object).getShape().ordinal()] == 1) {
                if (this.handledType() == BigDecimal.class) {
                    return NumberSerializer.bigDecimalAsStringSerializer();
                }
                return ToStringSerializer.instance;
            }
            return this;
        }
    }
}

