/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.annotation.JsonInclude;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.RuntimeJsonMappingException;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.annotation.JsonSerialize;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import com.privatefasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.privatefasterxml.jackson.databind.ser.std.StdSerializer;
import com.privatefasterxml.jackson.databind.ser.std.h;
import com.privatefasterxml.jackson.databind.type.ReferenceType;
import com.privatefasterxml.jackson.databind.util.ArrayBuilders;
import com.privatefasterxml.jackson.databind.util.BeanUtil;
import com.privatefasterxml.jackson.databind.util.NameTransformer;

public abstract class ReferenceTypeSerializer<T>
extends StdSerializer<T>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    public static final Object MARKER_FOR_EMPTY = JsonInclude.Include.NON_EMPTY;
    protected final JavaType _referredType;
    protected final BeanProperty _property;
    protected final TypeSerializer _valueTypeSerializer;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final NameTransformer _unwrapper;
    protected transient PropertySerializerMap _dynamicSerializers;
    protected final Object _suppressableValue;
    protected final boolean _suppressNulls;

    public ReferenceTypeSerializer(ReferenceType referenceType, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        ReferenceTypeSerializer referenceTypeSerializer = this;
        ReferenceTypeSerializer referenceTypeSerializer2 = this;
        super(referenceType);
        referenceTypeSerializer2._referredType = referenceType.getReferencedType();
        referenceTypeSerializer2._property = null;
        this._valueTypeSerializer = typeSerializer;
        referenceTypeSerializer._valueSerializer = jsonSerializer;
        referenceTypeSerializer._unwrapper = null;
        referenceTypeSerializer._suppressableValue = null;
        referenceTypeSerializer._suppressNulls = false;
        referenceTypeSerializer._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    public ReferenceTypeSerializer(ReferenceTypeSerializer<?> referenceTypeSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, NameTransformer nameTransformer, Object object, boolean bl) {
        ReferenceTypeSerializer referenceTypeSerializer2 = this;
        super(referenceTypeSerializer);
        referenceTypeSerializer2._referredType = referenceTypeSerializer._referredType;
        referenceTypeSerializer2._dynamicSerializers = PropertySerializerMap.emptyForProperties();
        this._property = beanProperty;
        this._valueTypeSerializer = typeSerializer;
        this._valueSerializer = jsonSerializer;
        this._unwrapper = nameTransformer;
        this._suppressableValue = object;
        this._suppressNulls = bl;
    }

    private final JsonSerializer<Object> _findCachedSerializer(SerializerProvider jsonSerializer, Class<?> clazz) {
        JsonSerializer<Object> jsonSerializer2 = this._dynamicSerializers.serializerFor(clazz);
        if (jsonSerializer2 == null) {
            if (this._referredType.hasGenericTypes()) {
                SerializerProvider serializerProvider = jsonSerializer;
                jsonSerializer = ((SerializerProvider)((Object)jsonSerializer)).constructSpecializedType(this._referredType, clazz);
                jsonSerializer = serializerProvider.findPrimaryPropertySerializer((JavaType)((Object)jsonSerializer), this._property);
            } else {
                jsonSerializer = ((SerializerProvider)((Object)jsonSerializer)).findPrimaryPropertySerializer(clazz, this._property);
            }
            jsonSerializer2 = this._unwrapper;
            jsonSerializer2 = jsonSerializer2 != null ? (jsonSerializer = jsonSerializer.unwrappingSerializer((NameTransformer)((Object)jsonSerializer2))) : jsonSerializer;
            this._dynamicSerializers = this._dynamicSerializers.newWith(clazz, jsonSerializer2);
        }
        return jsonSerializer2;
    }

    private final JsonSerializer<Object> _findSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanProperty beanProperty) {
        return serializerProvider.findPrimaryPropertySerializer(javaType, beanProperty);
    }

    @Override
    public JsonSerializer<T> unwrappingSerializer(NameTransformer nameTransformer) {
        JsonSerializer<Object> jsonSerializer = ((ReferenceTypeSerializer)((Object)beanProperty))._valueSerializer;
        if (jsonSerializer != null && (jsonSerializer = jsonSerializer.unwrappingSerializer(nameTransformer)) == ((ReferenceTypeSerializer)((Object)beanProperty))._valueSerializer) {
            return beanProperty;
        }
        NameTransformer nameTransformer2 = ((ReferenceTypeSerializer)((Object)beanProperty))._unwrapper;
        if (nameTransformer2 != null) {
            nameTransformer = NameTransformer.chainedTransformer(nameTransformer, nameTransformer2);
        }
        if (((ReferenceTypeSerializer)((Object)beanProperty))._valueSerializer == jsonSerializer && ((ReferenceTypeSerializer)((Object)beanProperty))._unwrapper == nameTransformer) {
            return beanProperty;
        }
        ReferenceTypeSerializer referenceTypeSerializer = beanProperty;
        BeanProperty beanProperty = referenceTypeSerializer._property;
        return referenceTypeSerializer.withResolved(beanProperty, referenceTypeSerializer._valueTypeSerializer, jsonSerializer, nameTransformer);
    }

    public abstract ReferenceTypeSerializer<T> withResolved(BeanProperty var1, TypeSerializer var2, JsonSerializer<?> var3, NameTransformer var4);

    public abstract ReferenceTypeSerializer<T> withContentInclusion(Object var1, boolean var2);

    public abstract boolean _isValuePresent(T var1);

    public abstract Object _getReferenced(T var1);

    public abstract Object _getReferencedIfPresent(T var1);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty object2) {
        Object object3;
        Object object4 = this._valueTypeSerializer;
        if (object4 != null) {
            object4 = ((TypeSerializer)object4).forProperty((BeanProperty)object2);
        }
        if ((object3 = this.findAnnotatedContentSerializer((SerializerProvider)object, (BeanProperty)object2)) == null) {
            object3 = this._valueSerializer;
            if (object3 == null) {
                if (this._useStatic((SerializerProvider)object, (BeanProperty)object2, this._referredType)) {
                    ReferenceTypeSerializer referenceTypeSerializer = this;
                    object3 = referenceTypeSerializer._findSerializer((SerializerProvider)object, referenceTypeSerializer._referredType, (BeanProperty)object2);
                }
            } else {
                object3 = ((SerializerProvider)object).handlePrimaryContextualization((JsonSerializer<?>)object3, (BeanProperty)object2);
            }
        }
        if (this._property == object2 && this._valueTypeSerializer == object4 && this._valueSerializer == object3) {
            object4 = this;
        } else {
            ReferenceTypeSerializer referenceTypeSerializer = this;
            NameTransformer nameTransformer = referenceTypeSerializer._unwrapper;
            object4 = referenceTypeSerializer.withResolved((BeanProperty)object2, (TypeSerializer)object4, (JsonSerializer<?>)object3, nameTransformer);
        }
        if (object2 != null) {
            BeanProperty beanProperty = object2;
            object2 = ((SerializerProvider)object).getConfig();
            if ((object2 = beanProperty.findPropertyInclusion((MapperConfig<?>)object2, this.handledType())) != null && (object3 = ((JsonInclude.Value)object2).getContentInclusion()) != JsonInclude.Include.USE_DEFAULTS) {
                boolean bl;
                switch (h.a[((Enum)object3).ordinal()]) {
                    default: {
                        object = null;
                        bl = false;
                        break;
                    }
                    case 5: {
                        object = null;
                        bl = true;
                        break;
                    }
                    case 4: {
                        boolean bl2;
                        object2 = ((SerializerProvider)object).includeFilterInstance(null, ((JsonInclude.Value)object2).getContentFilter());
                        if (object2 == null) {
                            boolean bl3;
                            bl = bl3 = true;
                            object = object2;
                            break;
                        }
                        bl = bl2 = ((SerializerProvider)object).includeFilterSuppressNulls(object2);
                        object = object2;
                        break;
                    }
                    case 3: {
                        bl = true;
                        object = MARKER_FOR_EMPTY;
                        break;
                    }
                    case 2: {
                        bl = true;
                        if (this._referredType.isReferenceType()) {
                            object = MARKER_FOR_EMPTY;
                            break;
                        }
                        object = null;
                        break;
                    }
                    case 1: {
                        object = BeanUtil.getDefaultValue(this._referredType);
                        bl = true;
                        if (object == null || !object.getClass().isArray()) break;
                        object = ArrayBuilders.getArrayComparator(object);
                    }
                }
                if (this._suppressableValue != object || this._suppressNulls != bl) {
                    object4 = ((ReferenceTypeSerializer)object4).withContentInclusion(object, bl);
                }
            }
        }
        return object4;
    }

    public boolean _useStatic(SerializerProvider serializerProvider, BeanProperty beanProperty, JavaType javaType) {
        if (javaType.isJavaLangObject()) {
            return false;
        }
        if (javaType.isFinal()) {
            return true;
        }
        if (javaType.useStaticType()) {
            return true;
        }
        Object object = serializerProvider.getAnnotationIntrospector();
        if (object != null && beanProperty != null && beanProperty.getMember() != null) {
            if ((object = ((AnnotationIntrospector)object).findSerializationTyping(beanProperty.getMember())) == JsonSerialize.Typing.STATIC) {
                return true;
            }
            if (object == JsonSerialize.Typing.DYNAMIC) {
                return false;
            }
        }
        return serializerProvider.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, T object) {
        if (!((ReferenceTypeSerializer)this)._isValuePresent(object)) {
            return true;
        }
        if ((object = ((ReferenceTypeSerializer)this)._getReferenced(object)) == null) {
            return ((ReferenceTypeSerializer)this)._suppressNulls;
        }
        if (((ReferenceTypeSerializer)this)._suppressableValue == null) {
            return false;
        }
        JsonSerializer<Object> jsonSerializer = ((ReferenceTypeSerializer)this)._valueSerializer;
        if (jsonSerializer == null) {
            try {
                jsonSerializer = ((ReferenceTypeSerializer)this)._findCachedSerializer(serializerProvider, object.getClass());
            }
            catch (JsonMappingException jsonMappingException) {
                throw new RuntimeJsonMappingException(jsonMappingException);
            }
        }
        if ((this = ((ReferenceTypeSerializer)this)._suppressableValue) == MARKER_FOR_EMPTY) {
            return jsonSerializer.isEmpty(serializerProvider, object);
        }
        return this.equals(object);
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return this._unwrapper != null;
    }

    public JavaType getReferredType() {
        return this._referredType;
    }

    @Override
    public void serialize(T object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if ((object = ((ReferenceTypeSerializer)this)._getReferencedIfPresent(object)) == null) {
            if (((ReferenceTypeSerializer)this)._unwrapper == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
            }
            return;
        }
        JsonSerializer<Object> jsonSerializer = ((ReferenceTypeSerializer)this)._valueSerializer;
        if (jsonSerializer == null) {
            jsonSerializer = ((ReferenceTypeSerializer)this)._findCachedSerializer(serializerProvider, object.getClass());
        }
        if ((this = ((ReferenceTypeSerializer)this)._valueTypeSerializer) != null) {
            jsonSerializer.serializeWithType(object, jsonGenerator, serializerProvider, (TypeSerializer)this);
        } else {
            jsonSerializer.serialize(object, jsonGenerator, serializerProvider);
        }
    }

    @Override
    public void serializeWithType(T object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        if ((object = this._getReferencedIfPresent(object)) == null) {
            if (this._unwrapper == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
            }
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            jsonSerializer = this._findCachedSerializer(serializerProvider, object.getClass());
        }
        jsonSerializer.serializeWithType(object, jsonGenerator, serializerProvider, typeSerializer);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType jsonSerializer) {
        jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            ReferenceTypeSerializer referenceTypeSerializer = this;
            jsonSerializer = jsonFormatVisitorWrapper.getProvider();
            Object object = referenceTypeSerializer._referredType;
            BeanProperty beanProperty = referenceTypeSerializer._property;
            jsonSerializer = referenceTypeSerializer._findSerializer((SerializerProvider)((Object)jsonSerializer), (JavaType)object, beanProperty);
            object = referenceTypeSerializer._unwrapper;
            if (object != null) {
                jsonSerializer = jsonSerializer.unwrappingSerializer((NameTransformer)object);
            }
        }
        jsonSerializer.acceptJsonFormatVisitor(jsonFormatVisitorWrapper, this._referredType);
    }
}

