/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import com.privatefasterxml.jackson.databind.ser.std.CollectionSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;

public abstract class StaticListSerializerBase<T extends Collection<?>>
extends StdSerializer<T>
implements ContextualSerializer {
    protected final Boolean _unwrapSingle;

    public StaticListSerializerBase(Class<?> clazz) {
        super(clazz, false);
        this._unwrapSingle = null;
    }

    public StaticListSerializerBase(StaticListSerializerBase<?> staticListSerializerBase, Boolean bl) {
        super(staticListSerializerBase);
        this._unwrapSingle = bl;
    }

    public abstract JsonSerializer<?> _withResolved(BeanProperty var1, Boolean var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        Object object;
        JsonSerializer<Object> jsonSerializer = null;
        Boolean bl = null;
        if (beanProperty != null) {
            object = serializerProvider.getAnnotationIntrospector();
            AnnotatedMember annotatedMember = beanProperty.getMember();
            if (annotatedMember != null && (object = ((AnnotationIntrospector)object).findContentSerializer(annotatedMember)) != null) {
                jsonSerializer = serializerProvider.serializerInstance(annotatedMember, object);
            }
        }
        StaticListSerializerBase staticListSerializerBase = this;
        object = staticListSerializerBase.handledType();
        if ((object = staticListSerializerBase.findFormatOverrides(serializerProvider, beanProperty, (Class<?>)object)) != null) {
            bl = ((JsonFormat.Value)object).getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        if ((jsonSerializer = this.findContextualConvertingSerializer(serializerProvider, beanProperty, jsonSerializer)) == null) {
            jsonSerializer = serializerProvider.findContentValueSerializer(String.class, beanProperty);
        }
        if (this.isDefaultSerializer(jsonSerializer)) {
            if (Objects.equals(bl, this._unwrapSingle)) {
                return this;
            }
            return this._withResolved(beanProperty, bl);
        }
        return new CollectionSerializer(serializerProvider.constructType((Type)((Object)String.class)), true, null, jsonSerializer);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, T t2) {
        return t2 == null || t2.isEmpty();
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("array", true).set("items", this.contentSchema());
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWithSerializerProvider, JavaType javaType) {
        if ((jsonFormatVisitorWithSerializerProvider = jsonFormatVisitorWithSerializerProvider.expectArrayFormat(javaType)) != null) {
            this.acceptContentVisitor((JsonArrayFormatVisitor)jsonFormatVisitorWithSerializerProvider);
        }
    }

    public abstract JsonNode contentSchema();

    public abstract void acceptContentVisitor(JsonArrayFormatVisitor var1);

    @Override
    public abstract void serializeWithType(T var1, JsonGenerator var2, SerializerProvider var3, TypeSerializer var4);
}

