/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.type.WritableTypeId;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.node.ObjectNode;
import com.privatefasterxml.jackson.databind.ser.ContainerSerializer;
import com.privatefasterxml.jackson.databind.ser.std.ArraySerializerBase;
import com.privatefasterxml.jackson.databind.ser.std.ByteArraySerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdSerializer;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;

public class StdArraySerializers {
    protected static final HashMap<String, JsonSerializer<?>> _arraySerializers;

    public static JsonSerializer<?> findStandardImpl(Class<?> clazz) {
        return _arraySerializers.get(clazz.getName());
    }

    static {
        DoubleArraySerializer doubleArraySerializer;
        FloatArraySerializer floatArraySerializer;
        LongArraySerializer longArraySerializer;
        IntArraySerializer intArraySerializer;
        ShortArraySerializer shortArraySerializer;
        CharArraySerializer charArraySerializer;
        ByteArraySerializer byteArraySerializer;
        BooleanArraySerializer booleanArraySerializer;
        _arraySerializers = new HashMap<String, BooleanArraySerializer>();
        String string = boolean[].class.getName();
        StdSerializer stdSerializer = booleanArraySerializer;
        booleanArraySerializer = new BooleanArraySerializer();
        _arraySerializers.put(string, stdSerializer);
        string = byte[].class.getName();
        stdSerializer = byteArraySerializer;
        byteArraySerializer = new ByteArraySerializer();
        _arraySerializers.put(string, stdSerializer);
        string = char[].class.getName();
        stdSerializer = charArraySerializer;
        charArraySerializer = new CharArraySerializer();
        _arraySerializers.put(string, stdSerializer);
        string = short[].class.getName();
        stdSerializer = shortArraySerializer;
        shortArraySerializer = new ShortArraySerializer();
        _arraySerializers.put(string, stdSerializer);
        string = int[].class.getName();
        stdSerializer = intArraySerializer;
        intArraySerializer = new IntArraySerializer();
        _arraySerializers.put(string, stdSerializer);
        string = long[].class.getName();
        stdSerializer = longArraySerializer;
        longArraySerializer = new LongArraySerializer();
        _arraySerializers.put(string, stdSerializer);
        string = float[].class.getName();
        stdSerializer = floatArraySerializer;
        floatArraySerializer = new FloatArraySerializer();
        _arraySerializers.put(string, stdSerializer);
        string = double[].class.getName();
        stdSerializer = doubleArraySerializer;
        doubleArraySerializer = new DoubleArraySerializer();
        _arraySerializers.put(string, stdSerializer);
    }

    @JacksonStdImpl
    public static class BooleanArraySerializer
    extends ArraySerializerBase<boolean[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Boolean.class);

        public BooleanArraySerializer() {
            super(boolean[].class);
        }

        public BooleanArraySerializer(BooleanArraySerializer booleanArraySerializer, BeanProperty beanProperty, Boolean bl) {
            super(booleanArraySerializer, beanProperty, bl);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
            return new BooleanArraySerializer(this, beanProperty, bl);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, boolean[] blArray) {
            return blArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(boolean[] blArray) {
            return blArray.length == 1;
        }

        @Override
        public final void serialize(boolean[] blArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            int n2 = blArray.length;
            if (n2 == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(blArray, jsonGenerator, serializerProvider);
                return;
            }
            jsonGenerator.writeStartArray(blArray, n2);
            this.serializeContents(blArray, jsonGenerator, serializerProvider);
            jsonGenerator.writeEndArray();
        }

        @Override
        public void serializeContents(boolean[] blArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            int n2 = blArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                jsonGenerator.writeBoolean(blArray[i2]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            ObjectNode objectNode = this.createSchemaNode("array", true);
            objectNode.set("items", this.createSchemaNode("boolean"));
            return objectNode;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            BooleanArraySerializer booleanArraySerializer = object;
            Object object = JsonFormatTypes.BOOLEAN;
            booleanArraySerializer.visitArrayFormat(jsonFormatVisitorWrapper, javaType, (JsonFormatTypes)((Object)object));
        }
    }

    @JacksonStdImpl
    public static class CharArraySerializer
    extends StdSerializer<char[]> {
        public CharArraySerializer() {
            super(char[].class);
        }

        private final void _writeArrayContents(JsonGenerator jsonGenerator, char[] cArray) {
            int n2 = cArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                jsonGenerator.writeString(cArray, i2, 1);
            }
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, char[] cArray) {
            return cArray.length == 0;
        }

        @Override
        public void serialize(char[] cArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            if (serializerProvider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
                jsonGenerator.writeStartArray(cArray, cArray.length);
                this._writeArrayContents(jsonGenerator, cArray);
                jsonGenerator.writeEndArray();
            } else {
                int n2 = cArray.length;
                jsonGenerator.writeString(cArray, 0, n2);
            }
        }

        @Override
        public void serializeWithType(char[] cArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
            Object object;
            if (serializerProvider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
                CharArraySerializer charArraySerializer = object;
                TypeSerializer typeSerializer2 = typeSerializer;
                object = typeSerializer2.writeTypePrefix(jsonGenerator, typeSerializer2.typeId(cArray, JsonToken.START_ARRAY));
                charArraySerializer._writeArrayContents(jsonGenerator, cArray);
            } else {
                TypeSerializer typeSerializer3 = typeSerializer;
                object = typeSerializer3.writeTypePrefix(jsonGenerator, typeSerializer3.typeId(cArray, JsonToken.VALUE_STRING));
                int n2 = cArray.length;
                jsonGenerator.writeString(cArray, 0, n2);
            }
            typeSerializer.writeTypeSuffix(jsonGenerator, (WritableTypeId)object);
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            ObjectNode objectNode = serializable.createSchemaNode("array", true);
            Serializable serializable = serializable.createSchemaNode("string");
            ((ObjectNode)serializable).put("type", "string");
            return objectNode.set("items", (JsonNode)((Object)serializable));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            CharArraySerializer charArraySerializer = object;
            Object object = JsonFormatTypes.STRING;
            charArraySerializer.visitArrayFormat(jsonFormatVisitorWrapper, javaType, (JsonFormatTypes)((Object)object));
        }
    }

    @JacksonStdImpl
    public static class ShortArraySerializer
    extends TypedPrimitiveArraySerializer<short[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Short.TYPE);

        public ShortArraySerializer() {
            super(short[].class);
        }

        public ShortArraySerializer(ShortArraySerializer shortArraySerializer, BeanProperty beanProperty, Boolean bl) {
            super(shortArraySerializer, beanProperty, bl);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
            return new ShortArraySerializer(this, beanProperty, bl);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, short[] sArray) {
            return sArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(short[] sArray) {
            return sArray.length == 1;
        }

        @Override
        public final void serialize(short[] sArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            int n2 = sArray.length;
            if (n2 == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(sArray, jsonGenerator, serializerProvider);
                return;
            }
            jsonGenerator.writeStartArray(sArray, n2);
            this.serializeContents(sArray, jsonGenerator, serializerProvider);
            jsonGenerator.writeEndArray();
        }

        @Override
        public void serializeContents(short[] sArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            int n2 = sArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                jsonGenerator.writeNumber((int)sArray[i2]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("integer"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            ShortArraySerializer shortArraySerializer = object;
            Object object = JsonFormatTypes.INTEGER;
            shortArraySerializer.visitArrayFormat(jsonFormatVisitorWrapper, javaType, (JsonFormatTypes)((Object)object));
        }
    }

    @JacksonStdImpl
    public static class IntArraySerializer
    extends ArraySerializerBase<int[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Integer.TYPE);

        public IntArraySerializer() {
            super(int[].class);
        }

        public IntArraySerializer(IntArraySerializer intArraySerializer, BeanProperty beanProperty, Boolean bl) {
            super(intArraySerializer, beanProperty, bl);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
            return new IntArraySerializer(this, beanProperty, bl);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, int[] nArray) {
            return nArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(int[] nArray) {
            return nArray.length == 1;
        }

        @Override
        public final void serialize(int[] nArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            if (nArray.length == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(nArray, jsonGenerator, serializerProvider);
                return;
            }
            int n2 = nArray.length;
            jsonGenerator.writeArray(nArray, 0, n2);
        }

        @Override
        public void serializeContents(int[] nArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            int n2 = nArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                jsonGenerator.writeNumber(nArray[i2]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("integer"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            IntArraySerializer intArraySerializer = object;
            Object object = JsonFormatTypes.INTEGER;
            intArraySerializer.visitArrayFormat(jsonFormatVisitorWrapper, javaType, (JsonFormatTypes)((Object)object));
        }
    }

    @JacksonStdImpl
    public static class LongArraySerializer
    extends TypedPrimitiveArraySerializer<long[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Long.TYPE);

        public LongArraySerializer() {
            super(long[].class);
        }

        public LongArraySerializer(LongArraySerializer longArraySerializer, BeanProperty beanProperty, Boolean bl) {
            super(longArraySerializer, beanProperty, bl);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
            return new LongArraySerializer(this, beanProperty, bl);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, long[] lArray) {
            return lArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(long[] lArray) {
            return lArray.length == 1;
        }

        @Override
        public final void serialize(long[] lArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            if (lArray.length == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(lArray, jsonGenerator, serializerProvider);
                return;
            }
            int n2 = lArray.length;
            jsonGenerator.writeArray(lArray, 0, n2);
        }

        @Override
        public void serializeContents(long[] lArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            int n2 = lArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                jsonGenerator.writeNumber(lArray[i2]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number", true));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            LongArraySerializer longArraySerializer = object;
            Object object = JsonFormatTypes.NUMBER;
            longArraySerializer.visitArrayFormat(jsonFormatVisitorWrapper, javaType, (JsonFormatTypes)((Object)object));
        }
    }

    @JacksonStdImpl
    public static class FloatArraySerializer
    extends TypedPrimitiveArraySerializer<float[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Float.TYPE);

        public FloatArraySerializer() {
            super(float[].class);
        }

        public FloatArraySerializer(FloatArraySerializer floatArraySerializer, BeanProperty beanProperty, Boolean bl) {
            super(floatArraySerializer, beanProperty, bl);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
            return new FloatArraySerializer(this, beanProperty, bl);
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, float[] fArray) {
            return fArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(float[] fArray) {
            return fArray.length == 1;
        }

        @Override
        public final void serialize(float[] fArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            int n2 = fArray.length;
            if (n2 == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(fArray, jsonGenerator, serializerProvider);
                return;
            }
            jsonGenerator.writeStartArray(fArray, n2);
            this.serializeContents(fArray, jsonGenerator, serializerProvider);
            jsonGenerator.writeEndArray();
        }

        @Override
        public void serializeContents(float[] fArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            int n2 = fArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                jsonGenerator.writeNumber(fArray[i2]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            FloatArraySerializer floatArraySerializer = object;
            Object object = JsonFormatTypes.NUMBER;
            floatArraySerializer.visitArrayFormat(jsonFormatVisitorWrapper, javaType, (JsonFormatTypes)((Object)object));
        }
    }

    @JacksonStdImpl
    public static class DoubleArraySerializer
    extends ArraySerializerBase<double[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Double.TYPE);

        public DoubleArraySerializer() {
            super(double[].class);
        }

        public DoubleArraySerializer(DoubleArraySerializer doubleArraySerializer, BeanProperty beanProperty, Boolean bl) {
            super(doubleArraySerializer, beanProperty, bl);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
            return new DoubleArraySerializer(this, beanProperty, bl);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return this;
        }

        @Override
        public JavaType getContentType() {
            return VALUE_TYPE;
        }

        @Override
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, double[] dArray) {
            return dArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(double[] dArray) {
            return dArray.length == 1;
        }

        @Override
        public final void serialize(double[] dArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            if (dArray.length == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(dArray, jsonGenerator, serializerProvider);
                return;
            }
            int n2 = dArray.length;
            jsonGenerator.writeArray(dArray, 0, n2);
        }

        @Override
        public void serializeContents(double[] dArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            int n2 = dArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                jsonGenerator.writeNumber(dArray[i2]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            DoubleArraySerializer doubleArraySerializer = object;
            Object object = JsonFormatTypes.NUMBER;
            doubleArraySerializer.visitArrayFormat(jsonFormatVisitorWrapper, javaType, (JsonFormatTypes)((Object)object));
        }
    }

    public static abstract class TypedPrimitiveArraySerializer<T>
    extends ArraySerializerBase<T> {
        public TypedPrimitiveArraySerializer(Class<T> clazz) {
            super(clazz);
        }

        public TypedPrimitiveArraySerializer(TypedPrimitiveArraySerializer<T> typedPrimitiveArraySerializer, BeanProperty beanProperty, Boolean bl) {
            super(typedPrimitiveArraySerializer, beanProperty, bl);
        }

        @Override
        public final ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return this;
        }
    }
}

