/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsonschema.SchemaAware;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import com.privatefasterxml.jackson.databind.ser.ResolvableSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdSerializer;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.Converter;
import java.lang.reflect.Type;

public class StdDelegatingSerializer
extends StdSerializer<Object>
implements ContextualSerializer,
ResolvableSerializer,
JsonFormatVisitable,
SchemaAware {
    protected final Converter<Object, ?> _converter;
    protected final JavaType _delegateType;
    protected final JsonSerializer<Object> _delegateSerializer;

    public StdDelegatingSerializer(Converter<?, ?> converter) {
        super(Object.class);
        this._converter = converter;
        this._delegateType = null;
        this._delegateSerializer = null;
    }

    public <T> StdDelegatingSerializer(Class<T> clazz, Converter<T, ?> converter) {
        super(clazz, false);
        this._converter = converter;
        this._delegateType = null;
        this._delegateSerializer = null;
    }

    public StdDelegatingSerializer(Converter<Object, ?> converter, JavaType javaType, JsonSerializer<?> jsonSerializer) {
        super(javaType);
        this._converter = converter;
        this._delegateType = javaType;
        this._delegateSerializer = jsonSerializer;
    }

    public StdDelegatingSerializer withDelegate(Converter<Object, ?> converter, JavaType javaType, JsonSerializer<?> jsonSerializer) {
        ClassUtil.verifyMustOverride(StdDelegatingSerializer.class, this, "withDelegate");
        return new StdDelegatingSerializer(converter, javaType, jsonSerializer);
    }

    @Override
    public void resolve(SerializerProvider serializerProvider) {
        JsonSerializer jsonSerializer = jsonSerializer._delegateSerializer;
        if (jsonSerializer != null && jsonSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
        }
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer = this._delegateSerializer;
        JavaType javaType = this._delegateType;
        if (jsonSerializer == null) {
            if (javaType == null) {
                javaType = this._converter.getOutputType(serializerProvider.getTypeFactory());
            }
            if (!javaType.isJavaLangObject()) {
                jsonSerializer = serializerProvider.findValueSerializer(javaType);
            }
        }
        if (jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = serializerProvider.handleSecondaryContextualization(jsonSerializer, beanProperty);
        }
        if (jsonSerializer == this._delegateSerializer && javaType == this._delegateType) {
            return this;
        }
        StdDelegatingSerializer stdDelegatingSerializer = this;
        return stdDelegatingSerializer.withDelegate(stdDelegatingSerializer._converter, javaType, jsonSerializer);
    }

    public Converter<Object, ?> getConverter() {
        return this._converter;
    }

    @Override
    public JsonSerializer<?> getDelegatee() {
        return this._delegateSerializer;
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if ((object = this.convertValue(object)) == null) {
            serializerProvider.defaultSerializeNull(jsonGenerator);
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._delegateSerializer;
        if (jsonSerializer == null) {
            jsonSerializer = this._findSerializer(object, serializerProvider);
        }
        jsonSerializer.serialize(object, jsonGenerator, serializerProvider);
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        StdDelegatingSerializer stdDelegatingSerializer = this;
        Object object2 = stdDelegatingSerializer.convertValue(object);
        JsonSerializer<Object> jsonSerializer = stdDelegatingSerializer._delegateSerializer;
        if (jsonSerializer == null) {
            jsonSerializer = this._findSerializer(object, serializerProvider);
        }
        jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, typeSerializer);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Object object) {
        Object object2 = ((StdDelegatingSerializer)jsonSerializer).convertValue(object);
        if (object2 == null) {
            return true;
        }
        JsonSerializer jsonSerializer = ((StdDelegatingSerializer)jsonSerializer)._delegateSerializer;
        if (jsonSerializer == null) {
            return object == null;
        }
        return jsonSerializer.isEmpty(serializerProvider, object2);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        JsonSerializer<Object> jsonSerializer = this._delegateSerializer;
        if (jsonSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)jsonSerializer)).getSchema(serializerProvider, type);
        }
        return super.getSchema(serializerProvider, type);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type, boolean bl) {
        JsonSerializer<Object> jsonSerializer = this._delegateSerializer;
        if (jsonSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)jsonSerializer)).getSchema(serializerProvider, type, bl);
        }
        return super.getSchema(serializerProvider, type);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        JsonSerializer jsonSerializer = ((StdDelegatingSerializer)jsonSerializer)._delegateSerializer;
        if (jsonSerializer != null) {
            jsonSerializer.acceptJsonFormatVisitor(jsonFormatVisitorWrapper, javaType);
        }
    }

    public Object convertValue(Object object) {
        return this._converter.convert(object);
    }

    public JsonSerializer<Object> _findSerializer(Object object, SerializerProvider serializerProvider) {
        return serializerProvider.findValueSerializer(object.getClass());
    }
}

