/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.ser.std.ClassSerializer;
import com.privatefasterxml.jackson.databind.ser.std.FileSerializer;
import com.privatefasterxml.jackson.databind.ser.std.NullSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdSerializer;
import com.privatefasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.privatefasterxml.jackson.databind.ser.std.UUIDSerializer;
import java.io.File;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public class StdJdkSerializers {
    public static Collection<Map.Entry<Class<?>, Object>> all() {
        ToStringSerializer toStringSerializer;
        ToStringSerializer toStringSerializer2;
        UUIDSerializer uUIDSerializer;
        ToStringSerializer toStringSerializer3;
        ToStringSerializer toStringSerializer4;
        ToStringSerializer toStringSerializer5;
        HashMap<Class<Void>, Object> hashMap = new HashMap<Class<Void>, Object>();
        StdSerializer stdSerializer = toStringSerializer5;
        toStringSerializer5 = new ToStringSerializer(URL.class);
        hashMap.put(URL.class, stdSerializer);
        stdSerializer = toStringSerializer4;
        toStringSerializer4 = new ToStringSerializer(URI.class);
        hashMap.put(URI.class, stdSerializer);
        stdSerializer = toStringSerializer3;
        toStringSerializer3 = new ToStringSerializer(Currency.class);
        hashMap.put(Currency.class, stdSerializer);
        stdSerializer = uUIDSerializer;
        uUIDSerializer = new UUIDSerializer();
        hashMap.put(UUID.class, stdSerializer);
        stdSerializer = toStringSerializer2;
        toStringSerializer2 = new ToStringSerializer(Pattern.class);
        hashMap.put(Pattern.class, stdSerializer);
        stdSerializer = toStringSerializer;
        toStringSerializer = new ToStringSerializer(Locale.class);
        hashMap.put(Locale.class, stdSerializer);
        hashMap.put(AtomicBoolean.class, AtomicBooleanSerializer.class);
        hashMap.put(AtomicInteger.class, AtomicIntegerSerializer.class);
        hashMap.put(AtomicLong.class, AtomicLongSerializer.class);
        hashMap.put(File.class, FileSerializer.class);
        hashMap.put(Class.class, ClassSerializer.class);
        stdSerializer = NullSerializer.instance;
        hashMap.put(Void.class, stdSerializer);
        hashMap.put(Void.TYPE, stdSerializer);
        return hashMap.entrySet();
    }

    public static class AtomicBooleanSerializer
    extends StdScalarSerializer<AtomicBoolean> {
        public AtomicBooleanSerializer() {
            super(AtomicBoolean.class, false);
        }

        @Override
        public void serialize(AtomicBoolean atomicBoolean, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeBoolean(atomicBoolean.get());
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("boolean", true);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            jsonFormatVisitorWrapper.expectBooleanFormat(javaType);
        }
    }

    public static class AtomicIntegerSerializer
    extends StdScalarSerializer<AtomicInteger> {
        public AtomicIntegerSerializer() {
            super(AtomicInteger.class, false);
        }

        @Override
        public void serialize(AtomicInteger atomicInteger, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeNumber(atomicInteger.get());
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("integer", true);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            AtomicIntegerSerializer atomicIntegerSerializer = object;
            Object object = JsonParser.NumberType.INT;
            atomicIntegerSerializer.visitIntFormat(jsonFormatVisitorWrapper, javaType, (JsonParser.NumberType)((Object)object));
        }
    }

    public static class AtomicLongSerializer
    extends StdScalarSerializer<AtomicLong> {
        public AtomicLongSerializer() {
            super(AtomicLong.class, false);
        }

        @Override
        public void serialize(AtomicLong atomicLong, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeNumber(atomicLong.get());
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("integer", true);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            AtomicLongSerializer atomicLongSerializer = object;
            Object object = JsonParser.NumberType.LONG;
            atomicLongSerializer.visitIntFormat(jsonFormatVisitorWrapper, javaType, (JsonParser.NumberType)((Object)object));
        }
    }
}

