/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.privatefasterxml.jackson.databind.ser.std.StdKeySerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdSerializer;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.EnumValues;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

public abstract class StdKeySerializers {
    protected static final JsonSerializer<Object> DEFAULT_KEY_SERIALIZER = new StdKeySerializer();
    protected static final JsonSerializer<Object> DEFAULT_STRING_SERIALIZER = new StringKeySerializer();

    public static JsonSerializer<Object> getStdKeySerializer(SerializationConfig serializationConfig, Class<?> clazz, boolean bl) {
        if (clazz != null && clazz != Object.class) {
            if (clazz == String.class) {
                return DEFAULT_STRING_SERIALIZER;
            }
            if (clazz.isPrimitive()) {
                clazz = ClassUtil.wrapperType(clazz);
            }
            if (clazz == Integer.class) {
                return new Default(5, clazz);
            }
            if (clazz == Long.class) {
                return new Default(6, clazz);
            }
            if (!clazz.isPrimitive() && !Number.class.isAssignableFrom(clazz)) {
                if (clazz == Class.class) {
                    return new Default(3, clazz);
                }
                if (Date.class.isAssignableFrom(clazz)) {
                    return new Default(1, clazz);
                }
                if (Calendar.class.isAssignableFrom(clazz)) {
                    return new Default(2, clazz);
                }
                if (clazz == UUID.class) {
                    return new Default(8, clazz);
                }
                if (clazz == byte[].class) {
                    return new Default(7, clazz);
                }
                if (bl) {
                    return new Default(8, clazz);
                }
                return null;
            }
            return new Default(8, clazz);
        }
        return new Dynamic();
    }

    public static JsonSerializer<Object> getFallbackKeySerializer(SerializationConfig serializationConfig, Class<?> clazz) {
        if (clazz != null) {
            if (clazz == Enum.class) {
                return new Dynamic();
            }
            if (ClassUtil.isEnumType(clazz)) {
                return EnumKeySerializer.construct(clazz, EnumValues.constructFromName(serializationConfig, clazz));
            }
        }
        return new Default(8, clazz);
    }

    @Deprecated
    public static JsonSerializer<Object> getDefault() {
        return DEFAULT_KEY_SERIALIZER;
    }

    public static class Dynamic
    extends StdSerializer<Object> {
        protected transient PropertySerializerMap _dynamicSerializers = PropertySerializerMap.emptyForProperties();

        public Dynamic() {
            super(String.class, false);
        }

        public Object readResolve() {
            this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
            return this;
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
            Class<?> clazz = object.getClass();
            JsonSerializer<Object> jsonSerializer = propertySerializerMap.serializerFor(clazz);
            if (jsonSerializer == null) {
                jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
            }
            jsonSerializer.serialize(object, jsonGenerator, serializerProvider);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            this.visitStringFormat(jsonFormatVisitorWrapper, javaType);
        }

        public JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap object, Class<?> object2, SerializerProvider object3) {
            if (object2 == Object.class) {
                Default default_;
                object3 = default_;
                ((Default)object3)(8, (Class<?>)object2);
                this._dynamicSerializers = ((PropertySerializerMap)object).newWith((Class<?>)object2, (JsonSerializer<Object>)object3);
                return default_;
            }
            PropertySerializerMap propertySerializerMap = object;
            object = propertySerializerMap.findAndAddKeySerializer((Class<?>)object2, (SerializerProvider)object3, null);
            object2 = ((PropertySerializerMap.SerializerAndMapResult)object).map;
            if (propertySerializerMap != object2) {
                this._dynamicSerializers = object2;
            }
            return ((PropertySerializerMap.SerializerAndMapResult)object).serializer;
        }
    }

    public static class Default
    extends StdSerializer<Object> {
        static final int TYPE_DATE = 1;
        static final int TYPE_CALENDAR = 2;
        static final int TYPE_CLASS = 3;
        static final int TYPE_ENUM = 4;
        static final int TYPE_INTEGER = 5;
        static final int TYPE_LONG = 6;
        static final int TYPE_BYTE_ARRAY = 7;
        static final int TYPE_TO_STRING = 8;
        protected final int _typeId;

        public Default(int n2, Class<?> clazz) {
            super(clazz, false);
            this._typeId = n2;
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            switch (((Default)object2)._typeId) {
                default: {
                    jsonGenerator.writeFieldName(object.toString());
                    break;
                }
                case 7: {
                    jsonGenerator.writeFieldName(serializerProvider.getConfig().getBase64Variant().encode((byte[])object));
                    break;
                }
                case 5: 
                case 6: {
                    jsonGenerator.writeFieldId(((Number)object).longValue());
                    break;
                }
                case 4: {
                    Object object2;
                    if (serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
                        object2 = object.toString();
                    } else {
                        object2 = (Enum)object;
                        object2 = serializerProvider.isEnabled(SerializationFeature.WRITE_ENUM_KEYS_USING_INDEX) ? String.valueOf(((Enum)object2).ordinal()) : ((Enum)object2).name();
                    }
                    jsonGenerator.writeFieldName((String)object2);
                    break;
                }
                case 3: {
                    jsonGenerator.writeFieldName(((Class)object).getName());
                    break;
                }
                case 2: {
                    serializerProvider.defaultSerializeDateKey(((Calendar)object).getTimeInMillis(), jsonGenerator);
                    break;
                }
                case 1: {
                    serializerProvider.defaultSerializeDateKey((Date)object, jsonGenerator);
                }
            }
        }
    }

    public static class EnumKeySerializer
    extends StdSerializer<Object> {
        protected final EnumValues _values;

        public EnumKeySerializer(Class<?> clazz, EnumValues enumValues) {
            super(clazz, false);
            this._values = enumValues;
        }

        public static EnumKeySerializer construct(Class<?> clazz, EnumValues enumValues) {
            return new EnumKeySerializer(clazz, enumValues);
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            if (serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
                jsonGenerator.writeFieldName(object.toString());
                return;
            }
            object = (Enum)object;
            if (serializerProvider.isEnabled(SerializationFeature.WRITE_ENUM_KEYS_USING_INDEX)) {
                jsonGenerator.writeFieldName(String.valueOf(((Enum)object).ordinal()));
                return;
            }
            jsonGenerator.writeFieldName(this._values.serializedValueFor((Enum<?>)object));
        }
    }

    public static class StringKeySerializer
    extends StdSerializer<Object> {
        public StringKeySerializer() {
            super(String.class, false);
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeFieldName((String)object);
        }
    }
}

