/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.annotation.JsonInclude;
import com.privatefasterxml.jackson.core.JacksonException;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.privatefasterxml.jackson.databind.jsonschema.SchemaAware;
import com.privatefasterxml.jackson.databind.node.JsonNodeFactory;
import com.privatefasterxml.jackson.databind.node.ObjectNode;
import com.privatefasterxml.jackson.databind.ser.FilterProvider;
import com.privatefasterxml.jackson.databind.ser.PropertyFilter;
import com.privatefasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class StdSerializer<T>
extends JsonSerializer<T>
implements JsonFormatVisitable,
SchemaAware,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Object KEY_CONTENT_CONVERTER_LOCK = new Object();
    protected final Class<T> _handledType;

    public StdSerializer(Class<T> clazz) {
        this._handledType = clazz;
    }

    public StdSerializer(JavaType javaType) {
        this._handledType = javaType.getRawClass();
    }

    public StdSerializer(Class<?> clazz, boolean bl) {
        this._handledType = clazz;
    }

    public StdSerializer(StdSerializer<?> stdSerializer) {
        this._handledType = stdSerializer._handledType;
    }

    public static final boolean _neitherNull(Object object, Object object2) {
        return object != null && object2 != null;
    }

    public static final boolean _nonEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    @Override
    public Class<T> handledType() {
        return this._handledType;
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3);

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        jsonFormatVisitorWrapper.expectAnyFormat(javaType);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("string");
    }

    @Override
    public JsonNode getSchema(SerializerProvider object, Type type, boolean bl) {
        Serializable serializable = (ObjectNode)((StdSerializer)serializable).getSchema((SerializerProvider)object, type);
        if (!bl) {
            object = "required";
            ((ObjectNode)serializable).put((String)object, bl ^ true);
        }
        return serializable;
    }

    public ObjectNode createSchemaNode(String string) {
        ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
        objectNode.put("type", string);
        return objectNode;
    }

    public ObjectNode createSchemaNode(String string, boolean bl) {
        Serializable serializable = ((StdSerializer)serializable).createSchemaNode(string);
        if (!bl) {
            string = "required";
            ((ObjectNode)serializable).put(string, bl ^ true);
        }
        return serializable;
    }

    public void visitStringFormat(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        jsonFormatVisitorWrapper.expectStringFormat(javaType);
    }

    public void visitStringFormat(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, JsonValueFormat jsonValueFormat) {
        JsonStringFormatVisitor jsonStringFormatVisitor = jsonFormatVisitorWrapper.expectStringFormat(javaType);
        if (jsonStringFormatVisitor != null) {
            jsonStringFormatVisitor.format(jsonValueFormat);
        }
    }

    public void visitIntFormat(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, JsonParser.NumberType numberType) {
        JsonIntegerFormatVisitor jsonIntegerFormatVisitor = jsonFormatVisitorWrapper.expectIntegerFormat(javaType);
        if (StdSerializer._neitherNull(jsonIntegerFormatVisitor, (Object)numberType)) {
            jsonIntegerFormatVisitor.numberType(numberType);
        }
    }

    public void visitIntFormat(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, JsonParser.NumberType numberType, JsonValueFormat jsonValueFormat) {
        JsonIntegerFormatVisitor jsonIntegerFormatVisitor = jsonFormatVisitorWrapper.expectIntegerFormat(javaType);
        if (jsonIntegerFormatVisitor != null) {
            if (numberType != null) {
                jsonIntegerFormatVisitor.numberType(numberType);
            }
            if (jsonValueFormat != null) {
                jsonIntegerFormatVisitor.format(jsonValueFormat);
            }
        }
    }

    public void visitFloatFormat(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, JsonParser.NumberType numberType) {
        JsonNumberFormatVisitor jsonNumberFormatVisitor = jsonFormatVisitorWrapper.expectNumberFormat(javaType);
        if (jsonNumberFormatVisitor != null) {
            jsonNumberFormatVisitor.numberType(numberType);
        }
    }

    public void visitArrayFormat(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, JsonSerializer<?> jsonSerializer, JavaType javaType2) {
        JsonArrayFormatVisitor jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType);
        if (StdSerializer._neitherNull(jsonArrayFormatVisitor, jsonSerializer)) {
            jsonArrayFormatVisitor.itemsFormat(jsonSerializer, javaType2);
        }
    }

    public void visitArrayFormat(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, JsonFormatTypes jsonFormatTypes) {
        JsonArrayFormatVisitor jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType);
        if (jsonArrayFormatVisitor != null) {
            jsonArrayFormatVisitor.itemsFormat(jsonFormatTypes);
        }
    }

    public void wrapAndThrow(SerializerProvider serializerProvider, Throwable throwable, Object object, String string) {
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        ClassUtil.throwIfError(throwable);
        boolean bl = serializerProvider == null || serializerProvider.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl || !(throwable instanceof JacksonException)) {
                throw (IOException)throwable;
            }
        } else if (!bl) {
            ClassUtil.throwIfRTE(throwable);
        }
        throw JsonMappingException.wrapWithPath(throwable, object, string);
    }

    public void wrapAndThrow(SerializerProvider serializerProvider, Throwable throwable, Object object, int n2) {
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        ClassUtil.throwIfError(throwable);
        boolean bl = serializerProvider == null || serializerProvider.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl || !(throwable instanceof JacksonException)) {
                throw (IOException)throwable;
            }
        } else if (!bl) {
            ClassUtil.throwIfRTE(throwable);
        }
        throw JsonMappingException.wrapWithPath(throwable, object, n2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonSerializer<?> findContextualConvertingSerializer(SerializerProvider serializerProvider, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer) {
        Throwable throwable2;
        void var2_3;
        Map map;
        block7: {
            void var3_4;
            block6: {
                JsonSerializer<?> jsonSerializer2;
                JsonSerializer<?> jsonSerializer3;
                void var1_2;
                Object object = KEY_CONTENT_CONVERTER_LOCK;
                map = (Map)var1_2.getAttribute(object);
                if (map != null) {
                    if (map.get(var2_3) != null) {
                        return var3_4;
                    }
                } else {
                    IdentityHashMap identityHashMap;
                    map = identityHashMap;
                    identityHashMap = new IdentityHashMap();
                    var1_2.setAttribute(object, map);
                }
                map.put(var2_3, Boolean.TRUE);
                try {
                    jsonSerializer3 = this.findConvertingContentSerializer((SerializerProvider)var1_2, (BeanProperty)var2_3, (JsonSerializer<?>)var3_4);
                    if (jsonSerializer3 == null) break block6;
                }
                catch (Throwable throwable2) {
                    break block7;
                }
                {
                    jsonSerializer2 = var1_2.handleSecondaryContextualization(jsonSerializer3, (BeanProperty)var2_3);
                    map.remove(var2_3);
                }
                return jsonSerializer2;
            }
            map.remove(var2_3);
            return var3_4;
        }
        map.remove(var2_3);
        throw throwable2;
    }

    @Deprecated
    public JsonSerializer<?> findConvertingContentSerializer(SerializerProvider serializerProvider, BeanProperty object, JsonSerializer<?> jsonSerializer) {
        AnnotatedMember annotatedMember;
        Object object2 = serializerProvider.getAnnotationIntrospector();
        if (StdSerializer._neitherNull(object2, object) && (annotatedMember = object.getMember()) != null && (object2 = ((AnnotationIntrospector)object2).findSerializationContentConverter(annotatedMember)) != null) {
            object2 = serializerProvider.converterInstance(object.getMember(), object2);
            object = object2.getOutputType(serializerProvider.getTypeFactory());
            if (jsonSerializer == null && !((JavaType)object).isJavaLangObject()) {
                jsonSerializer = serializerProvider.findValueSerializer((JavaType)object);
            }
            return new StdDelegatingSerializer((Converter<Object, ?>)object2, (JavaType)object, jsonSerializer);
        }
        return jsonSerializer;
    }

    public PropertyFilter findPropertyFilter(SerializerProvider serializerProvider, Object object, Object object2) {
        FilterProvider filterProvider = serializerProvider.getFilterProvider();
        if (filterProvider == null) {
            return (PropertyFilter)serializerProvider.reportBadDefinition(this.handledType(), "Cannot resolve PropertyFilter with id '" + object + "'; no FilterProvider configured");
        }
        return filterProvider.findPropertyFilter(object, object2);
    }

    public JsonFormat.Value findFormatOverrides(SerializerProvider serializerProvider, BeanProperty beanProperty, Class<?> clazz) {
        if (beanProperty != null) {
            return beanProperty.findPropertyFormat(serializerProvider.getConfig(), clazz);
        }
        return serializerProvider.getDefaultPropertyFormat(clazz);
    }

    public Boolean findFormatFeature(SerializerProvider serializerProvider, BeanProperty beanProperty, Class<?> clazz, JsonFormat.Feature feature) {
        if ((this = ((StdSerializer)this).findFormatOverrides(serializerProvider, beanProperty, clazz)) != null) {
            return ((JsonFormat.Value)this).getFeature(feature);
        }
        return null;
    }

    public JsonInclude.Value findIncludeOverrides(SerializerProvider serializerProvider, BeanProperty beanProperty, Class<?> clazz) {
        if (beanProperty != null) {
            return beanProperty.findPropertyInclusion(serializerProvider.getConfig(), clazz);
        }
        return serializerProvider.getDefaultPropertyInclusion(clazz);
    }

    public JsonSerializer<?> findAnnotatedContentSerializer(SerializerProvider serializerProvider, BeanProperty object) {
        if (object != null) {
            Serializable serializable = object.getMember();
            object = serializerProvider.getAnnotationIntrospector();
            if (serializable != null && (object = ((AnnotationIntrospector)object).findContentSerializer((Annotated)((Object)serializable))) != null) {
                return serializerProvider.serializerInstance((Annotated)((Object)serializable), object);
            }
        }
        return null;
    }

    public boolean isDefaultSerializer(JsonSerializer<?> jsonSerializer) {
        return ClassUtil.isJacksonStdImpl(jsonSerializer);
    }
}

