/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.ser.std;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonSerializer;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.privatefasterxml.jackson.databind.ser.ContextualSerializer;
import com.privatefasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.privatefasterxml.jackson.databind.util.TokenBuffer;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;

public class UUIDSerializer
extends StdScalarSerializer<UUID>
implements ContextualSerializer {
    static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    protected final Boolean _asBinary;

    public UUIDSerializer() {
        this((Boolean)null);
    }

    public UUIDSerializer(Boolean bl) {
        super(UUID.class);
        this._asBinary = bl;
    }

    private static void _appendInt(int n2, char[] cArray, int n3) {
        UUIDSerializer._appendShort(n2 >> 16, cArray, n3);
        UUIDSerializer._appendShort(n2, cArray, n3 + 4);
    }

    private static void _appendShort(int n2, char[] cArray, int n3) {
        char[] cArray2 = HEX_CHARS;
        int n4 = n2;
        int n5 = n2;
        int n6 = n2;
        cArray[n3] = cArray2[n2 >> 12 & 0xF];
        n2 = n3 + 1;
        cArray[n2] = cArray2[n6 >> 8 & 0xF];
        n2 = n3 + 2;
        cArray[n2] = cArray2[n5 >> 4 & 0xF];
        n2 = n3 + 3;
        cArray[n2] = HEX_CHARS[n4 & 0xF];
    }

    private static final byte[] _asBytes(UUID uUID) {
        byte[] byArray = new byte[16];
        UUID uUID2 = uUID;
        long l2 = uUID2.getMostSignificantBits();
        long l3 = uUID2.getLeastSignificantBits();
        long l4 = l2;
        UUIDSerializer._appendInt((int)(l4 >> 32), byArray, 0);
        UUIDSerializer._appendInt((int)l4, byArray, 4);
        UUIDSerializer._appendInt((int)(l3 >> 32), byArray, 8);
        UUIDSerializer._appendInt((int)l3, byArray, 12);
        return byArray;
    }

    private static final void _appendInt(int n2, byte[] byArray, int n3) {
        int n4 = n2;
        int n5 = n2;
        int n6 = n2;
        byArray[n3] = (byte)(n2 >> 24);
        n2 = n3 + 1;
        byArray[n2] = (byte)(n6 >> 16);
        n2 = n3 + 2;
        byArray[n2] = (byte)(n5 >> 8);
        n2 = n3 + 3;
        byArray[n2] = (byte)n4;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, UUID uUID) {
        return uUID.getLeastSignificantBits() == 0L && uUID.getMostSignificantBits() == 0L;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty object2) {
        UUIDSerializer uUIDSerializer = this;
        Class clazz = uUIDSerializer.handledType();
        object = uUIDSerializer.findFormatOverrides((SerializerProvider)object, (BeanProperty)object2, clazz);
        object2 = null;
        if (object != null) {
            if ((object = ((JsonFormat.Value)object).getShape()) == JsonFormat.Shape.BINARY) {
                object2 = Boolean.TRUE;
            } else if (object == JsonFormat.Shape.STRING) {
                object2 = Boolean.FALSE;
            }
        }
        if (!Objects.equals(object2, this._asBinary)) {
            return new UUIDSerializer((Boolean)object2);
        }
        return this;
    }

    @Override
    public void serialize(UUID uUID, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        long l2;
        if (((UUIDSerializer)object)._writeAsBinary(jsonGenerator)) {
            jsonGenerator.writeBinary(UUIDSerializer._asBytes(uUID));
            return;
        }
        char[] cArray = new char[36];
        Object object = cArray;
        long l3 = uUID.getMostSignificantBits();
        UUIDSerializer._appendInt((int)(l3 >> 32), (char[])object, 0);
        object[8] = 45;
        int n2 = (int)l3;
        Object object2 = object;
        UUIDSerializer._appendShort(n2 >>> 16, (char[])object, 9);
        object2[13] = 45;
        UUIDSerializer._appendShort(n2, (char[])object2, 14);
        cArray[18] = 45;
        long l4 = l2 = uUID.getLeastSignificantBits();
        UUIDSerializer._appendShort((int)(l2 >>> 48), (char[])object, 19);
        object[23] = 45;
        UUIDSerializer._appendShort((int)(l4 >>> 32), (char[])object, 24);
        UUIDSerializer._appendInt((int)l4, (char[])object, 28);
        jsonGenerator.writeString((char[])object, 0, 36);
    }

    public boolean _writeAsBinary(JsonGenerator jsonGenerator) {
        Serializable serializable = ((UUIDSerializer)serializable)._asBinary;
        if (serializable != null) {
            return (Boolean)serializable;
        }
        return !(jsonGenerator instanceof TokenBuffer) && jsonGenerator.canWriteBinaryNatively();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        UUIDSerializer uUIDSerializer = object;
        Object object = JsonValueFormat.UUID;
        uUIDSerializer.visitStringFormat(jsonFormatVisitorWrapper, javaType, (JsonValueFormat)((Object)object));
    }
}

