/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.type;

import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.type.TypeBase;
import com.privatefasterxml.jackson.databind.type.TypeBindings;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Type;

public final class ArrayType
extends TypeBase {
    private static final long serialVersionUID = 1L;
    protected final JavaType _componentType;
    protected final Object _emptyArray;

    public ArrayType(JavaType javaType, TypeBindings typeBindings, Object object, Object object2, Object object3, boolean bl) {
        ArrayType arrayType = type;
        Type type = object.getClass();
        int n2 = javaType.hashCode();
        super((Class<?>)type, typeBindings, null, null, n2, object2, object3, bl);
        arrayType._componentType = javaType;
        arrayType._emptyArray = object;
    }

    public static ArrayType construct(JavaType javaType, TypeBindings typeBindings) {
        return ArrayType.construct(javaType, typeBindings, null, null);
    }

    public static ArrayType construct(JavaType javaType, TypeBindings typeBindings, Object object, Object object2) {
        Object object3 = Array.newInstance(javaType.getRawClass(), 0);
        return new ArrayType(javaType, typeBindings, object3, object, object2, false);
    }

    private JavaType _reportUnsupported() {
        throw new UnsupportedOperationException("Cannot narrow or widen array types");
    }

    @Override
    public JavaType withContentType(JavaType object) {
        Object object2 = Array.newInstance(((JavaType)object).getRawClass(), 0);
        JavaType javaType = object;
        ArrayType arrayType = serializable;
        Serializable serializable = arrayType._bindings;
        object = arrayType._valueHandler;
        Object object3 = arrayType._typeHandler;
        boolean bl = arrayType._asStatic;
        return new ArrayType(javaType, (TypeBindings)serializable, object2, object, object3, bl);
    }

    @Override
    public ArrayType withTypeHandler(Object object) {
        if (object == javaType._typeHandler) {
            return javaType;
        }
        ArrayType arrayType = javaType;
        JavaType javaType = arrayType._componentType;
        TypeBindings typeBindings = arrayType._bindings;
        Object object2 = arrayType._emptyArray;
        Object object3 = arrayType._valueHandler;
        boolean bl = arrayType._asStatic;
        return new ArrayType(javaType, typeBindings, object2, object3, object, bl);
    }

    @Override
    public ArrayType withContentTypeHandler(Object object) {
        if (object == javaType._componentType.getTypeHandler()) {
            return javaType;
        }
        ArrayType arrayType = javaType;
        JavaType javaType = arrayType._componentType.withTypeHandler(object);
        object = arrayType._bindings;
        Object object2 = arrayType._emptyArray;
        Object object3 = arrayType._valueHandler;
        Object object4 = arrayType._typeHandler;
        boolean bl = arrayType._asStatic;
        return new ArrayType(javaType, (TypeBindings)object, object2, object3, object4, bl);
    }

    @Override
    public ArrayType withValueHandler(Object object) {
        if (object == javaType._valueHandler) {
            return javaType;
        }
        ArrayType arrayType = javaType;
        JavaType javaType = arrayType._componentType;
        TypeBindings typeBindings = arrayType._bindings;
        Object object2 = arrayType._emptyArray;
        Object object3 = arrayType._typeHandler;
        boolean bl = arrayType._asStatic;
        return new ArrayType(javaType, typeBindings, object2, object, object3, bl);
    }

    @Override
    public ArrayType withContentValueHandler(Object object) {
        if (object == javaType._componentType.getValueHandler()) {
            return javaType;
        }
        ArrayType arrayType = javaType;
        JavaType javaType = arrayType._componentType.withValueHandler(object);
        object = arrayType._bindings;
        Object object2 = arrayType._emptyArray;
        Object object3 = arrayType._valueHandler;
        Object object4 = arrayType._typeHandler;
        boolean bl = arrayType._asStatic;
        return new ArrayType(javaType, (TypeBindings)object, object2, object3, object4, bl);
    }

    @Override
    public ArrayType withStaticTyping() {
        if (javaType._asStatic) {
            return javaType;
        }
        ArrayType arrayType = javaType;
        JavaType javaType = arrayType._componentType.withStaticTyping();
        TypeBindings typeBindings = arrayType._bindings;
        Object object = arrayType._emptyArray;
        Object object2 = arrayType._valueHandler;
        Object object3 = arrayType._typeHandler;
        return new ArrayType(javaType, typeBindings, object, object2, object3, true);
    }

    @Override
    @Deprecated
    public JavaType _narrow(Class<?> clazz) {
        return this._reportUnsupported();
    }

    @Override
    public JavaType refine(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        return null;
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isConcrete() {
        return true;
    }

    @Override
    public boolean hasGenericTypes() {
        return this._componentType.hasGenericTypes();
    }

    @Override
    public boolean isContainerType() {
        return true;
    }

    @Override
    public JavaType getContentType() {
        return this._componentType;
    }

    @Override
    public Object getContentValueHandler() {
        return this._componentType.getValueHandler();
    }

    @Override
    public Object getContentTypeHandler() {
        return this._componentType.getTypeHandler();
    }

    @Override
    public boolean hasHandlers() {
        return super.hasHandlers() || this._componentType.hasHandlers();
    }

    @Override
    public StringBuilder getGenericSignature(StringBuilder stringBuilder) {
        stringBuilder.append('[');
        return this._componentType.getGenericSignature(stringBuilder);
    }

    @Override
    public StringBuilder getErasedSignature(StringBuilder stringBuilder) {
        stringBuilder.append('[');
        return this._componentType.getErasedSignature(stringBuilder);
    }

    public Object[] getEmptyArray() {
        return (Object[])this._emptyArray;
    }

    @Override
    public String toString() {
        return "[array type, component type: " + this._componentType + "]";
    }

    @Override
    public boolean equals(Object object) {
        if (object == arrayType2) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != ArrayType.class) {
            return false;
        }
        ArrayType arrayType = arrayType2;
        ArrayType arrayType2 = (ArrayType)object;
        return arrayType._componentType.equals(arrayType2._componentType);
    }
}

