/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.type;

import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.type.TypeBase;
import com.privatefasterxml.jackson.databind.type.TypeBindings;
import java.io.Serializable;

public class ResolvedRecursiveType
extends TypeBase {
    private static final long serialVersionUID = 1L;
    protected JavaType _referencedType;

    public ResolvedRecursiveType(Class<?> clazz, TypeBindings typeBindings) {
        super(clazz, typeBindings, null, null, 0, null, null, false);
    }

    public void setReference(JavaType javaType) {
        if (this._referencedType == null) {
            this._referencedType = javaType;
            return;
        }
        throw new IllegalStateException("Trying to re-set self reference; old value = " + this._referencedType + ", new = " + javaType);
    }

    @Override
    public JavaType getSuperClass() {
        JavaType javaType = this._referencedType;
        if (javaType != null) {
            return javaType.getSuperClass();
        }
        return super.getSuperClass();
    }

    public JavaType getSelfReferencedType() {
        return this._referencedType;
    }

    @Override
    public TypeBindings getBindings() {
        JavaType javaType = this._referencedType;
        if (javaType != null) {
            return javaType.getBindings();
        }
        return super.getBindings();
    }

    @Override
    public StringBuilder getGenericSignature(StringBuilder stringBuilder) {
        JavaType javaType = ((ResolvedRecursiveType)javaType)._referencedType;
        if (javaType != null) {
            return javaType.getErasedSignature(stringBuilder);
        }
        return stringBuilder.append("?");
    }

    @Override
    public StringBuilder getErasedSignature(StringBuilder stringBuilder) {
        JavaType javaType = ((ResolvedRecursiveType)javaType)._referencedType;
        if (javaType != null) {
            return javaType.getErasedSignature(stringBuilder);
        }
        return stringBuilder;
    }

    @Override
    public JavaType withContentType(JavaType javaType) {
        return this;
    }

    @Override
    public JavaType withTypeHandler(Object object) {
        return this;
    }

    @Override
    public JavaType withContentTypeHandler(Object object) {
        return this;
    }

    @Override
    public JavaType withValueHandler(Object object) {
        return this;
    }

    @Override
    public JavaType withContentValueHandler(Object object) {
        return this;
    }

    @Override
    public JavaType withStaticTyping() {
        return this;
    }

    @Override
    @Deprecated
    public JavaType _narrow(Class<?> clazz) {
        return this;
    }

    @Override
    public JavaType refine(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        return null;
    }

    @Override
    public boolean isContainerType() {
        return false;
    }

    @Override
    public String toString() {
        ResolvedRecursiveType resolvedRecursiveType = serializable;
        Serializable serializable = new StringBuilder(40).append("[recursive type; ");
        JavaType javaType = resolvedRecursiveType._referencedType;
        if (javaType == null) {
            ((StringBuilder)serializable).append("UNRESOLVED");
        } else {
            ((StringBuilder)serializable).append(javaType.getRawClass().getName());
        }
        return ((StringBuilder)serializable).toString();
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }
}

