/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.type;

import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.type.ResolvedRecursiveType;
import com.privatefasterxml.jackson.databind.type.a;
import com.privatefasterxml.jackson.databind.type.b;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.TypeVariable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TypeBindings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] NO_STRINGS;
    private static final JavaType[] NO_TYPES;
    private static final TypeBindings EMPTY;
    private final String[] _names;
    private final JavaType[] _types;
    private final String[] _unboundVariables;
    private final int _hashCode;

    private TypeBindings(String[] stringArray, JavaType[] javaTypeArray, String[] stringArray2) {
        if (stringArray == null) {
            stringArray = NO_STRINGS;
        }
        this._names = stringArray;
        if (javaTypeArray == null) {
            javaTypeArray = NO_TYPES;
        }
        this._types = javaTypeArray;
        if (stringArray.length == javaTypeArray.length) {
            int n2 = 1;
            int n3 = javaTypeArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 = this._types[i2].hashCode() + n2;
            }
            TypeBindings typeBindings = this;
            typeBindings._unboundVariables = stringArray2;
            typeBindings._hashCode = n2;
            return;
        }
        throw new IllegalArgumentException("Mismatching names (" + stringArray.length + "), types (" + javaTypeArray.length + ")");
    }

    public static TypeBindings emptyBindings() {
        return EMPTY;
    }

    public static TypeBindings create(Class<?> clazz, List<JavaType> javaTypeArray) {
        javaTypeArray = javaTypeArray != null && !javaTypeArray.isEmpty() ? javaTypeArray.toArray(NO_TYPES) : NO_TYPES;
        return TypeBindings.create(clazz, javaTypeArray);
    }

    public static TypeBindings create(Class<?> serializable, JavaType[] object) {
        block9: {
            block10: {
                String[] stringArray;
                block8: {
                    block7: {
                        if (object != null) break block7;
                        object = NO_TYPES;
                        break block8;
                    }
                    int n2 = ((JavaType[])object).length;
                    if (n2 == 1) break block9;
                    if (n2 == 2) break block10;
                }
                Object object2 = ((Class)serializable).getTypeParameters();
                if (object2 != null && ((TypeVariable<Class<?>>[])object2).length != 0) {
                    int n3 = ((TypeVariable<Class<?>>[])object2).length;
                    stringArray = new String[n3];
                    for (int i2 = 0; i2 < n3; ++i2) {
                        stringArray[i2] = object2[i2].getName();
                    }
                } else {
                    stringArray = NO_STRINGS;
                }
                if (stringArray.length != ((JavaType[])object).length) {
                    serializable = new StringBuilder("Cannot create TypeBindings for class ").append(((Class)serializable).getName()).append(" with ").append(((JavaType[])object).length).append(" type parameter");
                    object = ((JavaType[])object).length == 1 ? "" : "s";
                    object2 = new IllegalArgumentException(((StringBuilder)serializable).append((String)object).append(": class expects ").append(stringArray.length).toString());
                    throw object2;
                }
                return new TypeBindings(stringArray, (JavaType[])object, null);
            }
            Class<?> clazz = serializable;
            serializable = object[0];
            return TypeBindings.create(clazz, serializable, object[1]);
        }
        return TypeBindings.create(serializable, object[0]);
    }

    public static TypeBindings create(Class<?> javaTypeArray, JavaType javaType) {
        TypeVariable[] typeVariableArray = javaTypeArray == Collection.class ? b.b : (javaTypeArray == List.class ? b.d : (javaTypeArray == ArrayList.class ? b.e : (javaTypeArray == AbstractList.class ? b.a : (javaTypeArray == Iterable.class ? b.c : javaTypeArray.getTypeParameters()))));
        int n2 = typeVariableArray == null ? 0 : typeVariableArray.length;
        if (n2 == 1) {
            JavaType[] javaTypeArray2 = new JavaType[1];
            javaTypeArray = javaTypeArray2;
            javaTypeArray2[0] = javaType;
            return new TypeBindings(new String[]{typeVariableArray[0].getName()}, javaTypeArray, null);
        }
        throw new IllegalArgumentException("Cannot create TypeBindings for class " + javaTypeArray.getName() + " with 1 type parameter: class expects " + n2);
    }

    public static TypeBindings create(Class<?> javaTypeArray, JavaType javaType, JavaType javaType2) {
        TypeVariable[] typeVariableArray = javaTypeArray == Map.class ? b.f : (javaTypeArray == HashMap.class ? b.g : (javaTypeArray == LinkedHashMap.class ? b.h : javaTypeArray.getTypeParameters()));
        int n2 = typeVariableArray == null ? 0 : typeVariableArray.length;
        if (n2 == 2) {
            JavaType[] javaTypeArray2 = new JavaType[2];
            javaTypeArray = javaTypeArray2;
            javaTypeArray2[0] = javaType;
            javaTypeArray2[1] = javaType2;
            return new TypeBindings(new String[]{typeVariableArray[0].getName(), typeVariableArray[1].getName()}, javaTypeArray, null);
        }
        throw new IllegalArgumentException("Cannot create TypeBindings for class " + javaTypeArray.getName() + " with 2 type parameters: class expects " + n2);
    }

    public static TypeBindings create(List<String> stringArray, List<JavaType> list) {
        if (stringArray != null && !stringArray.isEmpty() && list != null && !list.isEmpty()) {
            stringArray = stringArray.toArray(NO_STRINGS);
            return new TypeBindings(stringArray, list.toArray(NO_TYPES), null);
        }
        return EMPTY;
    }

    public static TypeBindings createIfNeeded(Class<?> javaTypeArray, JavaType javaType) {
        TypeVariable<Class<?>>[] typeVariableArray = javaTypeArray.getTypeParameters();
        int n2 = typeVariableArray == null ? 0 : typeVariableArray.length;
        if (n2 == 0) {
            return EMPTY;
        }
        if (n2 == 1) {
            JavaType[] javaTypeArray2 = new JavaType[1];
            javaTypeArray = javaTypeArray2;
            javaTypeArray2[0] = javaType;
            return new TypeBindings(new String[]{typeVariableArray[0].getName()}, javaTypeArray, null);
        }
        throw new IllegalArgumentException("Cannot create TypeBindings for class " + javaTypeArray.getName() + " with 1 type parameter: class expects " + n2);
    }

    public static TypeBindings createIfNeeded(Class<?> serializable, JavaType[] object) {
        Object object2 = ((Class)serializable).getTypeParameters();
        if (object2 != null && ((TypeVariable<Class<?>>[])object2).length != 0) {
            if (object == null) {
                object = NO_TYPES;
            }
            int n2 = ((TypeVariable<Class<?>>[])object2).length;
            String[] stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = object2[i2].getName();
            }
            if (n2 != ((JavaType[])object).length) {
                serializable = new StringBuilder("Cannot create TypeBindings for class ").append(((Class)serializable).getName()).append(" with ").append(((JavaType[])object).length).append(" type parameter");
                object = ((JavaType[])object).length == 1 ? "" : "s";
                object2 = new IllegalArgumentException(((StringBuilder)serializable).append((String)object).append(": class expects ").append(n2).toString());
                throw object2;
            }
            return new TypeBindings(stringArray, (JavaType[])object, null);
        }
        return EMPTY;
    }

    static {
        String[] stringArray = new String[]{};
        NO_STRINGS = stringArray;
        JavaType[] javaTypeArray = new JavaType[]{};
        NO_TYPES = javaTypeArray;
        EMPTY = new TypeBindings(stringArray, javaTypeArray, null);
    }

    public Object readResolve() {
        String[] stringArray = this._names;
        if (this._names != null && stringArray.length != 0) {
            return this;
        }
        return EMPTY;
    }

    public TypeBindings withUnboundVariable(String string) {
        String[] stringArray = stringArray2._unboundVariables;
        int n2 = stringArray2._unboundVariables == null ? 0 : stringArray.length;
        stringArray = n2 == 0 ? new String[1] : Arrays.copyOf(stringArray, n2 + 1);
        stringArray[n2] = string;
        String[] stringArray2 = stringArray2._names;
        return new TypeBindings(stringArray2, stringArray2._types, stringArray);
    }

    public JavaType findBoundType(String object) {
        int n2 = ((TypeBindings)object2)._names.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!((String)object).equals(((TypeBindings)object2)._names[i2])) continue;
            Object object2 = ((TypeBindings)object2)._types[i2];
            if (object2 instanceof ResolvedRecursiveType && (object = ((ResolvedRecursiveType)object2).getSelfReferencedType()) != null) {
                object2 = object;
            }
            return object2;
        }
        return null;
    }

    public boolean isEmpty() {
        return this._types.length == 0;
    }

    public int size() {
        return this._types.length;
    }

    public String getBoundName(int n2) {
        if (n2 >= 0) {
            String[] stringArray = stringArray._names;
            if (n2 < stringArray._names.length) {
                return stringArray[n2];
            }
        }
        return null;
    }

    public JavaType getBoundType(int n2) {
        if (n2 >= 0) {
            JavaType[] javaTypeArray = javaTypeArray._types;
            if (n2 < javaTypeArray._types.length) {
                return javaTypeArray[n2];
            }
        }
        return null;
    }

    public List<JavaType> getTypeParameters() {
        JavaType[] javaTypeArray = javaTypeArray._types;
        if (javaTypeArray._types.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(javaTypeArray);
    }

    public boolean hasUnbound(String string) {
        String[] stringArray = this._unboundVariables;
        if (this._unboundVariables != null) {
            int n2 = stringArray.length;
            while ((n2 += -1) >= 0) {
                if (!string.equals(this._unboundVariables[n2])) continue;
                return true;
            }
        }
        return false;
    }

    public Object asKey(Class<?> clazz) {
        JavaType[] javaTypeArray = javaTypeArray._types;
        int n2 = javaTypeArray._hashCode;
        return new a(clazz, javaTypeArray, n2);
    }

    public String toString() {
        StringBuilder stringBuilder;
        if (this._types.length == 0) {
            return "<>";
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("<");
        int n2 = this._types.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuilder2.append(',');
            }
            stringBuilder2.append(this._types[i2].getGenericSignature());
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append('>');
        return stringBuilder3.toString();
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object javaTypeArray) {
        if (javaTypeArray == this) {
            return true;
        }
        if (!ClassUtil.hasClass(javaTypeArray, this.getClass())) {
            return false;
        }
        int n2 = this._types.length;
        if (n2 != (javaTypeArray = (TypeBindings)javaTypeArray).size()) {
            return false;
        }
        javaTypeArray = javaTypeArray._types;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (javaTypeArray[i2].equals(this._types[i2])) continue;
            return false;
        }
        return true;
    }

    public JavaType[] typeParameterArray() {
        return this._types;
    }
}

