/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.type;

import com.applitools.android.common.a;
import com.privatefasterxml.jackson.core.type.TypeReference;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.type.ArrayType;
import com.privatefasterxml.jackson.databind.type.ClassStack;
import com.privatefasterxml.jackson.databind.type.CollectionLikeType;
import com.privatefasterxml.jackson.databind.type.CollectionType;
import com.privatefasterxml.jackson.databind.type.MapLikeType;
import com.privatefasterxml.jackson.databind.type.MapType;
import com.privatefasterxml.jackson.databind.type.PlaceholderForType;
import com.privatefasterxml.jackson.databind.type.ReferenceType;
import com.privatefasterxml.jackson.databind.type.ResolvedRecursiveType;
import com.privatefasterxml.jackson.databind.type.SimpleType;
import com.privatefasterxml.jackson.databind.type.TypeBindings;
import com.privatefasterxml.jackson.databind.type.TypeModifier;
import com.privatefasterxml.jackson.databind.type.TypeParser;
import com.privatefasterxml.jackson.databind.util.ArrayBuilders;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.LRUMap;
import com.privatefasterxml.jackson.databind.util.LookupCache;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;

public class TypeFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final JavaType[] NO_TYPES = new JavaType[0];
    protected static final TypeFactory instance = new TypeFactory();
    protected static final TypeBindings EMPTY_BINDINGS = TypeBindings.emptyBindings();
    private static final Class<?> CLS_STRING = String.class;
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Class<?> CLS_COMPARABLE = Comparable.class;
    private static final Class<?> CLS_ENUM = Enum.class;
    private static final Class<?> CLS_JSON_NODE = JsonNode.class;
    private static final Class<?> CLS_BOOL;
    private static final Class<?> CLS_INT;
    private static final Class<?> CLS_LONG;
    protected static final SimpleType CORE_TYPE_BOOL;
    protected static final SimpleType CORE_TYPE_INT;
    protected static final SimpleType CORE_TYPE_LONG;
    protected static final SimpleType CORE_TYPE_STRING;
    protected static final SimpleType CORE_TYPE_OBJECT;
    protected static final SimpleType CORE_TYPE_COMPARABLE;
    protected static final SimpleType CORE_TYPE_ENUM;
    protected static final SimpleType CORE_TYPE_JSON_NODE;
    protected final LookupCache<Object, JavaType> _typeCache;
    protected final TypeModifier[] _modifiers;
    protected final TypeParser _parser;
    protected final ClassLoader _classLoader;

    private TypeFactory() {
        this((LookupCache<Object, JavaType>)null);
    }

    @Deprecated
    public TypeFactory(LRUMap<Object, JavaType> lRUMap) {
        this((LookupCache<Object, JavaType>)lRUMap);
    }

    public TypeFactory(LookupCache<Object, JavaType> serializable) {
        TypeParser typeParser;
        if (serializable == null) {
            LRUMap lRUMap;
            serializable = lRUMap;
            lRUMap = new LRUMap(16, 200);
        }
        TypeFactory typeFactory = this;
        typeFactory._typeCache = serializable;
        serializable = typeParser;
        typeParser = new TypeParser(this);
        typeFactory._parser = serializable;
        typeFactory._modifiers = null;
        typeFactory._classLoader = null;
    }

    @Deprecated
    public TypeFactory(LRUMap<Object, JavaType> lRUMap, TypeParser typeParser, TypeModifier[] typeModifierArray, ClassLoader classLoader) {
        this((LookupCache<Object, JavaType>)lRUMap, typeParser, typeModifierArray, classLoader);
    }

    public TypeFactory(LookupCache<Object, JavaType> lRUMap, TypeParser typeParser, TypeModifier[] typeModifierArray, ClassLoader classLoader) {
        if (lRUMap == null) {
            LRUMap<Object, JavaType> lRUMap2;
            lRUMap = lRUMap2;
            lRUMap2 = new LRUMap<Object, JavaType>(16, 200);
        }
        this._typeCache = lRUMap;
        this._parser = typeParser.withFactory(this);
        this._modifiers = typeModifierArray;
        this._classLoader = classLoader;
    }

    public static TypeFactory defaultInstance() {
        return instance;
    }

    public static JavaType unknownType() {
        return TypeFactory.defaultInstance()._unknownType();
    }

    public static Class<?> rawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        return TypeFactory.defaultInstance().constructType(type).getRawClass();
    }

    private TypeBindings _bindingsForSubtype(JavaType javaType, int n2, Class<?> clazz, boolean bl) {
        Object[] objectArray;
        JavaType[] javaTypeArray = new PlaceholderForType[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            PlaceholderForType placeholderForType;
            PlaceholderForType placeholderForType2 = placeholderForType;
            placeholderForType = new PlaceholderForType(i2);
            javaTypeArray[i2] = placeholderForType2;
        }
        Serializable serializable = TypeBindings.create(clazz, javaTypeArray);
        if ((serializable = objectArray._fromClass(null, clazz, (TypeBindings)serializable).findSuperType(javaType.getRawClass())) != null) {
            if ((objectArray = objectArray._resolveTypePlaceholders(javaType, (JavaType)serializable)) != null && !bl) {
                throw new IllegalArgumentException("Failed to specialize base type " + javaType.toCanonical() + " as " + clazz.getName() + ", problem: " + (String)objectArray);
            }
            objectArray = new JavaType[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                JavaType javaType2 = ((PlaceholderForType)javaTypeArray[i3]).actualType();
                if (javaType2 == null) {
                    javaType2 = TypeFactory.unknownType();
                }
                objectArray[i3] = javaType2;
            }
            return TypeBindings.create(clazz, (JavaType[])objectArray);
        }
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray[0] = javaType.getRawClass().getName();
        objectArray2[1] = clazz.getName();
        throw new IllegalArgumentException(String.format("Internal error: unable to locate supertype (%s) from resolved subtype %s", objectArray));
    }

    private String _resolveTypePlaceholders(JavaType javaType, JavaType object) {
        List<JavaType> list = javaType.getBindings().getTypeParameters();
        object = ((JavaType)object).getBindings().getTypeParameters();
        int n2 = object.size();
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            JavaType javaType2;
            JavaType javaType3 = list.get(i2);
            if (objectArray2._verifyAndResolvePlaceholders(javaType3, javaType2 = i2 < n2 ? (JavaType)object.get(i2) : TypeFactory.unknownType()) || javaType3.hasRawClass(Object.class) || i2 == 0 && javaType.isMapLikeType() && javaType2.hasRawClass(Object.class) || javaType3.isInterface() && javaType3.isTypeOrSuperTypeOf(javaType2.getRawClass())) continue;
            Object[] objectArray = new Object[4];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = i2 + 1;
            objectArray2[1] = n3;
            objectArray2[2] = javaType3.toCanonical();
            objectArray[3] = javaType2.toCanonical();
            return String.format("Type parameter #%d/%d differs; can not specialize %s with %s", objectArray2);
        }
        return null;
    }

    private boolean _verifyAndResolvePlaceholders(JavaType object, JavaType object2) {
        if (object2 instanceof PlaceholderForType) {
            ((PlaceholderForType)object2).actualType((JavaType)object);
            return true;
        }
        if (((JavaType)object).getRawClass() != ((JavaType)object2).getRawClass()) {
            return false;
        }
        object = ((JavaType)object).getBindings().getTypeParameters();
        object2 = ((JavaType)object2).getBindings().getTypeParameters();
        int n2 = object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            JavaType javaType = (JavaType)object.get(i2);
            if (this._verifyAndResolvePlaceholders(javaType, (JavaType)object2.get(i2))) continue;
            return false;
        }
        return true;
    }

    private JavaType _mapType(Class<?> clazz, TypeBindings typeBindings, JavaType object, JavaType[] objectArray) {
        List<JavaType> list;
        Serializable serializable;
        if (clazz == Properties.class) {
            serializable = CORE_TYPE_STRING;
            list = serializable;
        } else {
            list = typeBindings.getTypeParameters();
            int n2 = list.size();
            if (n2 != 0) {
                if (n2 != 2) {
                    object = "Strange Map type %s with %d type parameter%s (%s), can not resolve";
                    Object[] objectArray2 = new Object[4];
                    objectArray = objectArray2;
                    objectArray[0] = ClassUtil.nameOf(clazz);
                    objectArray2[1] = n2;
                    int n3 = 2;
                    list = n2 == 1 ? "" : "s";
                    Serializable serializable2 = serializable;
                    Object[] objectArray3 = objectArray;
                    objectArray3[n3] = list;
                    objectArray3[3] = typeBindings;
                    ((IllegalArgumentException)serializable2)(String.format((String)object, objectArray));
                    throw serializable2;
                }
                List<JavaType> list2 = list;
                serializable = (JavaType)list2.get(0);
                list = (JavaType)list2.get(1);
            } else {
                serializable = ((TypeFactory)serializable)._unknownType();
                list = serializable;
            }
        }
        return MapType.construct(clazz, typeBindings, (JavaType)object, (JavaType[])objectArray, (JavaType)serializable, (JavaType)((Object)list));
    }

    private JavaType _collectionType(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        block4: {
            block3: {
                Serializable serializable;
                List<JavaType> list;
                block2: {
                    list = typeBindings.getTypeParameters();
                    if (!list.isEmpty()) break block2;
                    serializable = serializable._unknownType();
                    break block3;
                }
                if (list.size() != 1) break block4;
                serializable = list.get(0);
            }
            return CollectionType.construct(clazz, typeBindings, javaType, javaTypeArray, (JavaType)serializable);
        }
        throw new IllegalArgumentException(a.a(clazz, new StringBuilder("Strange Collection type "), ": cannot determine type parameters"));
    }

    private JavaType _referenceType(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        block4: {
            block3: {
                Serializable serializable;
                List<JavaType> list;
                block2: {
                    list = typeBindings.getTypeParameters();
                    if (!list.isEmpty()) break block2;
                    serializable = serializable._unknownType();
                    break block3;
                }
                if (list.size() != 1) break block4;
                serializable = list.get(0);
            }
            return ReferenceType.construct(clazz, typeBindings, javaType, javaTypeArray, (JavaType)serializable);
        }
        throw new IllegalArgumentException(a.a(clazz, new StringBuilder("Strange Reference type "), ": cannot determine type parameters"));
    }

    static {
        Class<Boolean> clazz = Boolean.TYPE;
        CLS_BOOL = clazz;
        Class<Integer> clazz2 = Integer.TYPE;
        CLS_INT = clazz2;
        Class<Long> clazz3 = Long.TYPE;
        CLS_LONG = clazz3;
        CORE_TYPE_BOOL = new SimpleType(clazz);
        CORE_TYPE_INT = new SimpleType(clazz2);
        CORE_TYPE_LONG = new SimpleType(clazz3);
        CORE_TYPE_STRING = new SimpleType(String.class);
        CORE_TYPE_OBJECT = new SimpleType(Object.class);
        CORE_TYPE_COMPARABLE = new SimpleType(Comparable.class);
        CORE_TYPE_ENUM = new SimpleType(Enum.class);
        CORE_TYPE_JSON_NODE = new SimpleType(JsonNode.class);
    }

    public TypeFactory withModifier(TypeModifier typeModifierArray) {
        Object object;
        TypeModifier[] typeModifierArray2 = serializable._typeCache;
        if (typeModifierArray == null) {
            typeModifierArray = null;
            typeModifierArray2 = null;
        } else {
            object = serializable._modifiers;
            if (serializable._modifiers == null) {
                TypeModifier[] typeModifierArray3 = new TypeModifier[1];
                typeModifierArray2 = typeModifierArray3;
                typeModifierArray3[0] = typeModifierArray;
                TypeModifier[] typeModifierArray4 = typeModifierArray = null;
                typeModifierArray = typeModifierArray2;
                typeModifierArray2 = typeModifierArray4;
            } else {
                typeModifierArray = ArrayBuilders.insertInListNoDup(object, typeModifierArray);
            }
        }
        TypeFactory typeFactory = serializable;
        Serializable serializable = typeFactory._parser;
        object = typeFactory._classLoader;
        return new TypeFactory((LookupCache<Object, JavaType>)typeModifierArray2, (TypeParser)serializable, typeModifierArray, (ClassLoader)object);
    }

    public TypeFactory withClassLoader(ClassLoader classLoader) {
        TypeFactory typeFactory = lookupCache;
        LookupCache<Object, JavaType> lookupCache = typeFactory._typeCache;
        TypeParser typeParser = typeFactory._parser;
        TypeModifier[] typeModifierArray = typeFactory._modifiers;
        return new TypeFactory(lookupCache, typeParser, typeModifierArray, classLoader);
    }

    @Deprecated
    public TypeFactory withCache(LRUMap<Object, JavaType> lRUMap) {
        TypeFactory typeFactory = serializable;
        Serializable serializable = typeFactory._parser;
        TypeModifier[] typeModifierArray = typeFactory._modifiers;
        ClassLoader classLoader = typeFactory._classLoader;
        return new TypeFactory(lRUMap, (TypeParser)serializable, typeModifierArray, classLoader);
    }

    public TypeFactory withCache(LookupCache<Object, JavaType> lookupCache) {
        TypeFactory typeFactory = serializable;
        Serializable serializable = typeFactory._parser;
        TypeModifier[] typeModifierArray = typeFactory._modifiers;
        ClassLoader classLoader = typeFactory._classLoader;
        return new TypeFactory(lookupCache, (TypeParser)serializable, typeModifierArray, classLoader);
    }

    public void clearCache() {
        this._typeCache.clear();
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public Class<?> findClass(String string) {
        Serializable serializable;
        if (string.indexOf(46) < 0 && (serializable = this._findPrimitive(string)) != null) {
            return serializable;
        }
        serializable = null;
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader != null) {
            try {
                return this.classForName(string, true, classLoader);
            }
            catch (Exception exception) {
                serializable = ClassUtil.getRootCause(exception);
            }
        }
        try {
            return this.classForName(string);
        }
        catch (Exception exception) {
            if (serializable == null) {
                serializable = ClassUtil.getRootCause(exception);
            }
            ClassUtil.throwIfRTE(serializable);
            throw new ClassNotFoundException(((Throwable)serializable).getMessage(), (Throwable)serializable);
        }
    }

    public Class<?> classForName(String string, boolean bl, ClassLoader classLoader) {
        return Class.forName(string, true, classLoader);
    }

    public Class<?> classForName(String string) {
        return Class.forName(string);
    }

    public Class<?> _findPrimitive(String string) {
        if ("int".equals(string)) {
            return Integer.TYPE;
        }
        if ("long".equals(string)) {
            return Long.TYPE;
        }
        if ("float".equals(string)) {
            return Float.TYPE;
        }
        if ("double".equals(string)) {
            return Double.TYPE;
        }
        if ("boolean".equals(string)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(string)) {
            return Byte.TYPE;
        }
        if ("char".equals(string)) {
            return Character.TYPE;
        }
        if ("short".equals(string)) {
            return Short.TYPE;
        }
        if ("void".equals(string)) {
            return Void.TYPE;
        }
        return null;
    }

    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) {
        return this.constructSpecializedType(javaType, clazz, false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz, boolean bl) {
        JavaType javaType2;
        void var2_8;
        void var1_7;
        Class<?> clazz2 = var1_7.getRawClass();
        if (clazz2 == var2_8) {
            return var1_7;
        }
        if (clazz2 != Object.class) {
            int n2;
            if (!clazz2.isAssignableFrom((Class<?>)var2_8)) {
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = ClassUtil.nameOf(var2_8);
                objectArray[1] = ClassUtil.getTypeDescription((JavaType)var1_7);
                throw new IllegalArgumentException(String.format("Class %s not subtype of %s", objectArray2));
            }
            if (var1_7.isContainerType()) {
                if (var1_7.isMapLikeType()) {
                    if (var2_8 == HashMap.class || var2_8 == LinkedHashMap.class || var2_8 == EnumMap.class || var2_8 == TreeMap.class) {
                        void v1 = var1_7;
                        JavaType javaType3 = v1.getKeyType();
                        JavaType javaType4 = v1.getContentType();
                        TypeBindings typeBindings = TypeBindings.create(var2_8, javaType3, javaType4);
                        javaType2 = this._fromClass(null, (Class<?>)var2_8, typeBindings);
                        return javaType2.withHandlersFrom((JavaType)var1_7);
                    }
                } else if (var1_7.isCollectionLikeType()) {
                    if (var2_8 != ArrayList.class && var2_8 != LinkedList.class && var2_8 != HashSet.class && var2_8 != TreeSet.class) {
                        if (clazz2 == EnumSet.class) {
                            return var1_7;
                        }
                    } else {
                        TypeBindings typeBindings = TypeBindings.create(var2_8, var1_7.getContentType());
                        javaType2 = this._fromClass(null, (Class<?>)var2_8, typeBindings);
                        return javaType2.withHandlersFrom((JavaType)var1_7);
                    }
                }
            }
            if (!var1_7.getBindings().isEmpty() && (n2 = var2_8.getTypeParameters().length) != 0) {
                void var3_9;
                TypeFactory typeFactory = this;
                TypeBindings typeBindings = typeFactory._bindingsForSubtype((JavaType)var1_7, n2, (Class<?>)var2_8, (boolean)var3_9);
                javaType2 = typeFactory._fromClass(null, (Class<?>)var2_8, typeBindings);
                return javaType2.withHandlersFrom((JavaType)var1_7);
            }
        }
        TypeBindings typeBindings = EMPTY_BINDINGS;
        javaType2 = this._fromClass(null, (Class<?>)var2_8, typeBindings);
        return javaType2.withHandlersFrom((JavaType)var1_7);
    }

    public JavaType constructGeneralizedType(JavaType javaType, Class<?> clazz) {
        Object object = javaType.getRawClass();
        if (object == clazz) {
            return javaType;
        }
        JavaType javaType2 = javaType.findSuperType(clazz);
        if (javaType2 == null) {
            if (!clazz.isAssignableFrom((Class<?>)object)) {
                Object[] objectArray = new Object[2];
                object = objectArray;
                objectArray[0] = clazz.getName();
                objectArray[1] = javaType;
                throw new IllegalArgumentException(String.format("Class %s not a super-type of %s", object));
            }
            Object[] objectArray = new Object[2];
            object = objectArray;
            objectArray[0] = clazz.getName();
            objectArray[1] = javaType;
            throw new IllegalArgumentException(String.format("Internal error: class %s not included as super-type for %s", object));
        }
        return javaType2;
    }

    public JavaType constructFromCanonical(String string) {
        return this._parser.parse(string);
    }

    public JavaType[] findTypeParameters(JavaType javaType, Class<?> clazz) {
        Serializable serializable = javaType.findSuperType(clazz);
        if (serializable == null) {
            return NO_TYPES;
        }
        return ((JavaType)serializable).getBindings().typeParameterArray();
    }

    @Deprecated
    public JavaType[] findTypeParameters(Class<?> clazz, Class<?> clazz2, TypeBindings typeBindings) {
        TypeFactory typeFactory = this;
        return typeFactory.findTypeParameters(typeFactory.constructType(clazz, typeBindings), clazz2);
    }

    @Deprecated
    public JavaType[] findTypeParameters(Class<?> clazz, Class<?> clazz2) {
        TypeFactory typeFactory = this;
        return typeFactory.findTypeParameters(typeFactory.constructType(clazz), clazz2);
    }

    public JavaType moreSpecificType(JavaType javaType, JavaType javaType2) {
        Class<?> clazz;
        if (javaType == null) {
            return javaType2;
        }
        if (javaType2 == null) {
            return javaType;
        }
        Serializable serializable = javaType.getRawClass();
        if (serializable == (clazz = javaType2.getRawClass())) {
            return javaType;
        }
        if (((Class)serializable).isAssignableFrom(clazz)) {
            return javaType2;
        }
        return javaType;
    }

    public JavaType constructType(Type type) {
        TypeFactory typeFactory = serializable;
        Serializable serializable = EMPTY_BINDINGS;
        return typeFactory._fromAny(null, type, (TypeBindings)serializable);
    }

    public JavaType constructType(TypeReference<?> typeReference) {
        TypeFactory typeFactory = serializable;
        Serializable serializable = EMPTY_BINDINGS;
        return typeFactory._fromAny(null, typeReference.getType(), (TypeBindings)serializable);
    }

    public JavaType resolveMemberType(Type type, TypeBindings typeBindings) {
        return this._fromAny(null, type, typeBindings);
    }

    @Deprecated
    public JavaType constructType(Type type, TypeBindings typeBindings) {
        if (type instanceof Class) {
            return this._applyModifiers(type, this._fromClass(null, (Class)type, typeBindings));
        }
        return this._fromAny(null, type, typeBindings);
    }

    @Deprecated
    public JavaType constructType(Type type, Class<?> type2) {
        type2 = type2 == null ? null : this.constructType(type2);
        return this.constructType(type, (JavaType)type2);
    }

    @Deprecated
    public JavaType constructType(Type type, JavaType serializable) {
        if (serializable == null) {
            serializable = EMPTY_BINDINGS;
        } else {
            Serializable serializable2 = ((JavaType)serializable).getBindings();
            if (type.getClass() != Class.class) {
                TypeBindings typeBindings = serializable2;
                serializable2 = serializable;
                serializable = typeBindings;
                while (((TypeBindings)serializable).isEmpty() && (serializable2 = ((JavaType)serializable2).getSuperClass()) != null) {
                    serializable = ((JavaType)serializable2).getBindings();
                }
            } else {
                serializable = serializable2;
            }
        }
        return this._fromAny(null, type, (TypeBindings)serializable);
    }

    public ArrayType constructArrayType(Class<?> clazz) {
        return ArrayType.construct(this._fromAny(null, clazz, null), null);
    }

    public ArrayType constructArrayType(JavaType javaType) {
        return ArrayType.construct(javaType, null);
    }

    public CollectionType constructCollectionType(Class<? extends Collection> clazz, Class<?> clazz2) {
        TypeFactory typeFactory = serializable;
        TypeFactory typeFactory2 = serializable;
        Serializable serializable = EMPTY_BINDINGS;
        return typeFactory.constructCollectionType(clazz, typeFactory2._fromClass(null, clazz2, (TypeBindings)serializable));
    }

    public CollectionType constructCollectionType(Class<? extends Collection> clazz, JavaType javaType) {
        TypeFactory typeFactory = serializable;
        Serializable serializable = TypeBindings.createIfNeeded(clazz, javaType);
        Object[] objectArray = (Object[])typeFactory._fromClass(null, clazz, (TypeBindings)serializable);
        if (((TypeBindings)serializable).isEmpty() && javaType != null && !((JavaType)(serializable = objectArray.findSuperType(Collection.class).getContentType())).equals(javaType)) {
            Object[] objectArray2 = new Object[3];
            objectArray = objectArray2;
            objectArray2[0] = ClassUtil.nameOf(clazz);
            objectArray2[1] = javaType;
            objectArray2[2] = serializable;
            throw new IllegalArgumentException(String.format("Non-generic Collection class %s did not resolve to something with element type %s but %s ", objectArray));
        }
        return objectArray;
    }

    public CollectionLikeType constructCollectionLikeType(Class<?> clazz, Class<?> clazz2) {
        TypeFactory typeFactory = serializable;
        TypeFactory typeFactory2 = serializable;
        Serializable serializable = EMPTY_BINDINGS;
        return typeFactory.constructCollectionLikeType(clazz, typeFactory2._fromClass(null, clazz2, (TypeBindings)serializable));
    }

    public CollectionLikeType constructCollectionLikeType(Class<?> clazz, JavaType javaType) {
        TypeFactory typeFactory = serializable;
        Serializable serializable = TypeBindings.createIfNeeded(clazz, javaType);
        if ((serializable = typeFactory._fromClass(null, clazz, (TypeBindings)serializable)) instanceof CollectionLikeType) {
            return (CollectionLikeType)serializable;
        }
        return CollectionLikeType.upgradeFrom((JavaType)serializable, javaType);
    }

    public MapType constructMapType(Class<? extends Map> clazz, Class<?> type, Class<?> type2) {
        if (clazz == Properties.class) {
            type = CORE_TYPE_STRING;
            type2 = type;
        } else {
            TypeFactory typeFactory = this;
            TypeBindings typeBindings = EMPTY_BINDINGS;
            type = typeFactory._fromClass(null, (Class<?>)type, typeBindings);
            type2 = typeFactory._fromClass(null, (Class<?>)type2, typeBindings);
        }
        return this.constructMapType(clazz, (JavaType)type, (JavaType)type2);
    }

    public MapType constructMapType(Class<? extends Map> clazz, JavaType objectArray, JavaType javaType) {
        TypeFactory typeFactory = serializable;
        Serializable serializable = TypeBindings.createIfNeeded(clazz, new JavaType[]{objectArray, javaType});
        MapType mapType = (MapType)typeFactory._fromClass(null, clazz, (TypeBindings)serializable);
        if (((TypeBindings)serializable).isEmpty()) {
            serializable = mapType.findSuperType(Map.class);
            JavaType javaType2 = ((JavaType)serializable).getKeyType();
            if (javaType2.equals(objectArray)) {
                if (!((JavaType)(serializable = ((JavaType)serializable).getContentType())).equals(javaType)) {
                    Object[] objectArray2 = new Object[3];
                    objectArray = objectArray2;
                    objectArray2[0] = ClassUtil.nameOf(clazz);
                    objectArray2[1] = javaType;
                    objectArray2[2] = serializable;
                    throw new IllegalArgumentException(String.format("Non-generic Map class %s did not resolve to something with value type %s but %s ", objectArray));
                }
            } else {
                Object[] objectArray3 = new Object[3];
                serializable = objectArray3;
                objectArray3[0] = ClassUtil.nameOf(clazz);
                objectArray3[1] = objectArray;
                objectArray3[2] = javaType2;
                throw new IllegalArgumentException(String.format("Non-generic Map class %s did not resolve to something with key type %s but %s ", (Object[])serializable));
            }
        }
        return mapType;
    }

    public MapLikeType constructMapLikeType(Class<?> type, Class<?> clazz, Class<?> clazz2) {
        TypeFactory typeFactory = serializable;
        Class<?> clazz3 = type;
        TypeFactory typeFactory2 = serializable;
        Serializable serializable = EMPTY_BINDINGS;
        type = typeFactory2._fromClass(null, clazz, (TypeBindings)serializable);
        return typeFactory.constructMapLikeType(clazz3, (JavaType)type, typeFactory2._fromClass(null, clazz2, (TypeBindings)serializable));
    }

    public MapLikeType constructMapLikeType(Class<?> clazz, JavaType javaType, JavaType javaType2) {
        TypeFactory typeFactory = serializable;
        Serializable serializable = TypeBindings.createIfNeeded(clazz, new JavaType[]{javaType, javaType2});
        if ((serializable = typeFactory._fromClass(null, clazz, (TypeBindings)serializable)) instanceof MapLikeType) {
            return (MapLikeType)serializable;
        }
        return MapLikeType.upgradeFrom((JavaType)serializable, javaType, javaType2);
    }

    public JavaType constructSimpleType(Class<?> clazz, JavaType[] javaTypeArray) {
        TypeFactory typeFactory = serializable;
        Serializable serializable = TypeBindings.create(clazz, javaTypeArray);
        return typeFactory._fromClass(null, clazz, (TypeBindings)serializable);
    }

    @Deprecated
    public JavaType constructSimpleType(Class<?> clazz, Class<?> clazz2, JavaType[] javaTypeArray) {
        return this.constructSimpleType(clazz, javaTypeArray);
    }

    public JavaType constructReferenceType(Class<?> clazz, JavaType javaType) {
        Class<?> clazz2 = clazz;
        return ReferenceType.construct(clazz2, TypeBindings.create(clazz2, javaType), null, null, javaType);
    }

    @Deprecated
    public JavaType uncheckedSimpleType(Class<?> clazz) {
        return this._constructSimple(clazz, EMPTY_BINDINGS, null, null);
    }

    public JavaType constructParametricType(Class<?> clazz, Class<?> ... classArray) {
        int n2 = classArray.length;
        JavaType[] javaTypeArray = new JavaType[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeBindings typeBindings = EMPTY_BINDINGS;
            javaTypeArray[i2] = this._fromClass(null, classArray[i2], typeBindings);
        }
        return this.constructParametricType(clazz, javaTypeArray);
    }

    public JavaType constructParametricType(Class<?> clazz, JavaType ... javaTypeArray) {
        Class<?> clazz2 = clazz;
        return this.constructParametricType(clazz2, TypeBindings.create(clazz2, javaTypeArray));
    }

    public JavaType constructParametricType(Class<?> clazz, TypeBindings typeBindings) {
        return this._applyModifiers(clazz, this._fromClass(null, clazz, typeBindings));
    }

    @Deprecated
    public JavaType constructParametrizedType(Class<?> clazz, Class<?> clazz2, JavaType ... javaTypeArray) {
        return this.constructParametricType(clazz, javaTypeArray);
    }

    @Deprecated
    public JavaType constructParametrizedType(Class<?> clazz, Class<?> clazz2, Class<?> ... classArray) {
        return this.constructParametricType(clazz, classArray);
    }

    public CollectionType constructRawCollectionType(Class<? extends Collection> clazz) {
        return this.constructCollectionType(clazz, TypeFactory.unknownType());
    }

    public CollectionLikeType constructRawCollectionLikeType(Class<?> clazz) {
        return this.constructCollectionLikeType(clazz, TypeFactory.unknownType());
    }

    public MapType constructRawMapType(Class<? extends Map> clazz) {
        return this.constructMapType(clazz, TypeFactory.unknownType(), TypeFactory.unknownType());
    }

    public MapLikeType constructRawMapLikeType(Class<?> clazz) {
        return this.constructMapLikeType(clazz, TypeFactory.unknownType(), TypeFactory.unknownType());
    }

    public JavaType _constructSimple(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        JavaType javaType2;
        if (typeBindings.isEmpty() && (javaType2 = this._findWellKnownSimple(clazz)) != null) {
            return javaType2;
        }
        return this._newSimpleType(clazz, typeBindings, javaType, javaTypeArray);
    }

    public JavaType _newSimpleType(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        return new SimpleType(clazz, typeBindings, javaType, javaTypeArray);
    }

    public JavaType _unknownType() {
        return CORE_TYPE_OBJECT;
    }

    public JavaType _findWellKnownSimple(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == CLS_BOOL) {
                return CORE_TYPE_BOOL;
            }
            if (clazz == CLS_INT) {
                return CORE_TYPE_INT;
            }
            if (clazz == CLS_LONG) {
                return CORE_TYPE_LONG;
            }
        } else {
            if (clazz == CLS_STRING) {
                return CORE_TYPE_STRING;
            }
            if (clazz == CLS_OBJECT) {
                return CORE_TYPE_OBJECT;
            }
            if (clazz == CLS_JSON_NODE) {
                return CORE_TYPE_JSON_NODE;
            }
        }
        return null;
    }

    public JavaType _fromAny(ClassStack object, Type object2, TypeBindings typeBindings) {
        StringBuilder stringBuilder;
        block9: {
            block5: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                if (!(object2 instanceof Class)) break block4;
                                typeBindings = EMPTY_BINDINGS;
                                object = this._fromClass((ClassStack)object, (Class)object2, typeBindings);
                                break block5;
                            }
                            if (!(object2 instanceof ParameterizedType)) break block6;
                            object = this._fromParamType((ClassStack)object, (ParameterizedType)object2, typeBindings);
                            break block5;
                        }
                        if (object2 instanceof JavaType) {
                            return (JavaType)object2;
                        }
                        if (!(object2 instanceof GenericArrayType)) break block7;
                        object = this._fromArrayType((ClassStack)object, (GenericArrayType)object2, typeBindings);
                        break block5;
                    }
                    if (!(object2 instanceof TypeVariable)) break block8;
                    object = this._fromVariable((ClassStack)object, (TypeVariable)object2, typeBindings);
                    break block5;
                }
                if (!(object2 instanceof WildcardType)) break block9;
                object = this._fromWildcard((ClassStack)object, (WildcardType)object2, typeBindings);
            }
            return this._applyModifiers((Type)object2, (JavaType)object);
        }
        object = stringBuilder;
        stringBuilder = new StringBuilder("Unrecognized Type: ");
        object2 = object2 == null ? "[null]" : object2.toString();
        Serializable serializable = this;
        ((IllegalArgumentException)serializable)(((StringBuilder)object).append((String)object2).toString());
        throw serializable;
    }

    public JavaType _applyModifiers(Type type, JavaType javaType) {
        if (objectArray2._modifiers == null) {
            return javaType;
        }
        TypeBindings typeBindings = javaType.getBindings();
        if (typeBindings == null) {
            typeBindings = EMPTY_BINDINGS;
        }
        TypeModifier[] typeModifierArray = objectArray2._modifiers;
        int n2 = objectArray2._modifiers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeModifier typeModifier = typeModifierArray[i2];
            JavaType javaType2 = typeModifier.modifyType(javaType, type, typeBindings, (TypeFactory)objectArray2);
            if (javaType2 != null) {
                javaType = javaType2;
                continue;
            }
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = typeModifier;
            objectArray[1] = typeModifier.getClass().getName();
            objectArray[2] = javaType;
            throw new IllegalStateException(String.format("TypeModifier %s (of type %s) return null for type %s", objectArray2));
        }
        return javaType;
    }

    public JavaType _fromClass(ClassStack classStack, Class<?> type, TypeBindings typeBindings) {
        Object object;
        Object object2 = ((TypeFactory)serializable)._findWellKnownSimple((Class<?>)type);
        if (object2 != null) {
            return object2;
        }
        object2 = typeBindings != null && !typeBindings.isEmpty() ? typeBindings.asKey((Class<?>)type) : type;
        JavaType javaType = ((TypeFactory)serializable)._typeCache.get(object2);
        if (javaType != null) {
            return javaType;
        }
        if (classStack == null) {
            ClassStack classStack2;
            classStack = classStack2;
            classStack2 = new ClassStack((Class<?>)type);
        } else {
            object = classStack.find((Class<?>)type);
            if (object != null) {
                ResolvedRecursiveType resolvedRecursiveType;
                Serializable serializable = resolvedRecursiveType;
                ((ResolvedRecursiveType)serializable)((Class<?>)type, EMPTY_BINDINGS);
                ((ClassStack)object).addSelfReference((ResolvedRecursiveType)serializable);
                return resolvedRecursiveType;
            }
            classStack = classStack.child((Class<?>)type);
        }
        if (((Class)type).isArray()) {
            type = ArrayType.construct(((TypeFactory)serializable)._fromAny(classStack, ((Class)type).getComponentType(), typeBindings), typeBindings);
        } else {
            JavaType[] javaTypeArray;
            if (((Class)type).isInterface()) {
                object = null;
                javaTypeArray = ((TypeFactory)serializable)._resolveSuperInterfaces(classStack, (Class<?>)type, typeBindings);
            } else {
                Serializable serializable = serializable;
                object = ((TypeFactory)serializable)._resolveSuperClass(classStack, (Class<?>)type, typeBindings);
                javaTypeArray = ((TypeFactory)serializable)._resolveSuperInterfaces(classStack, (Class<?>)type, typeBindings);
            }
            if (type == Properties.class) {
                JavaType javaType2 = javaType = CORE_TYPE_STRING;
                javaType = MapType.construct(type, typeBindings, (JavaType)object, javaTypeArray, javaType2, javaType2);
            } else if (object != null) {
                javaType = ((JavaType)object).refine((Class<?>)type, typeBindings, (JavaType)object, javaTypeArray);
            }
            type = javaType == null && (javaType = ((TypeFactory)serializable)._fromWellKnownClass(classStack, (Class<?>)type, typeBindings, (JavaType)object, javaTypeArray)) == null && (javaType = ((TypeFactory)serializable)._fromWellKnownInterface(classStack, (Class<?>)type, typeBindings, (JavaType)object, javaTypeArray)) == null ? ((TypeFactory)serializable)._newSimpleType((Class<?>)type, typeBindings, (JavaType)object, javaTypeArray) : javaType;
        }
        classStack.resolveSelfReferences((JavaType)type);
        if (!((JavaType)type).hasHandlers()) {
            ((TypeFactory)serializable)._typeCache.putIfAbsent(object2, (JavaType)type);
        }
        return type;
    }

    public JavaType _resolveSuperClass(ClassStack classStack, Class<?> type, TypeBindings typeBindings) {
        if ((type = ClassUtil.getGenericSuperclass(type)) == null) {
            return null;
        }
        return this._fromAny(classStack, type, typeBindings);
    }

    public JavaType[] _resolveSuperInterfaces(ClassStack classStack, Class<?> typeArray, TypeBindings typeBindings) {
        if ((typeArray = ClassUtil.getGenericInterfaces(typeArray)) != null && typeArray.length != 0) {
            int n2 = typeArray.length;
            JavaType[] javaTypeArray = new JavaType[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                javaTypeArray[i2] = this._fromAny(classStack, typeArray[i2], typeBindings);
            }
            return javaTypeArray;
        }
        return NO_TYPES;
    }

    public JavaType _fromWellKnownClass(ClassStack classStack, Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        if (typeBindings == null) {
            typeBindings = EMPTY_BINDINGS;
        }
        if (clazz == Map.class) {
            return this._mapType(clazz, typeBindings, javaType, javaTypeArray);
        }
        if (clazz == Collection.class) {
            return this._collectionType(clazz, typeBindings, javaType, javaTypeArray);
        }
        if (clazz == AtomicReference.class) {
            return this._referenceType(clazz, typeBindings, javaType, javaTypeArray);
        }
        return null;
    }

    public JavaType _fromWellKnownInterface(ClassStack classStack, Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        int n2 = javaTypeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JavaType javaType2 = javaTypeArray[i2].refine(clazz, typeBindings, javaType, javaTypeArray);
            if (javaType2 == null) continue;
            return javaType2;
        }
        return null;
    }

    public JavaType _fromParamType(ClassStack classStack, ParameterizedType object, TypeBindings typeBindings) {
        Class clazz = (Class)object.getRawType();
        if (clazz == CLS_ENUM) {
            return CORE_TYPE_ENUM;
        }
        if (clazz == CLS_COMPARABLE) {
            return CORE_TYPE_COMPARABLE;
        }
        int n2 = (object = object.getActualTypeArguments()) == null ? 0 : ((Type[])object).length;
        if (n2 == 0) {
            object = EMPTY_BINDINGS;
        } else {
            JavaType[] javaTypeArray = new JavaType[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                javaTypeArray[i2] = this._fromAny(classStack, object[i2], typeBindings);
            }
            object = TypeBindings.create(clazz, javaTypeArray);
        }
        return this._fromClass(classStack, clazz, (TypeBindings)object);
    }

    public JavaType _fromArrayType(ClassStack classStack, GenericArrayType genericArrayType, TypeBindings typeBindings) {
        return ArrayType.construct(this._fromAny(classStack, genericArrayType.getGenericComponentType(), typeBindings), typeBindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaType _fromVariable(ClassStack classStack, TypeVariable<?> typeVariable, TypeBindings typeBindings) {
        String string = typeVariable.getName();
        if (typeBindings != null) {
            JavaType javaType = typeBindings.findBoundType(string);
            if (javaType != null) {
                return javaType;
            }
            if (typeBindings.hasUnbound(string)) {
                return CORE_TYPE_OBJECT;
            }
            TypeFactory typeFactory = serializable;
            TypeVariable<?> typeVariable2 = typeVariable;
            Serializable serializable = typeBindings.withUnboundVariable(string);
            synchronized (typeVariable2) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return typeFactory._fromAny(classStack, typeVariable2.getBounds()[0], (TypeBindings)serializable);
            }
        }
        throw new IllegalArgumentException("Null `bindings` passed (type variable \"" + string + "\")");
    }

    public JavaType _fromWildcard(ClassStack classStack, WildcardType wildcardType, TypeBindings typeBindings) {
        return this._fromAny(classStack, wildcardType.getUpperBounds()[0], typeBindings);
    }
}

