/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.util;

import com.privatefasterxml.jackson.annotation.JsonInclude;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class BeanUtil {
    @Deprecated
    public static String okNameForGetter(AnnotatedMethod annotatedMethod, boolean bl) {
        AnnotatedMethod annotatedMethod2 = annotatedMethod;
        String string = annotatedMethod2.getName();
        String string2 = BeanUtil.okNameForIsGetter(annotatedMethod2, string, bl);
        if (string2 == null) {
            string2 = BeanUtil.okNameForRegularGetter(annotatedMethod, string, bl);
        }
        return string2;
    }

    @Deprecated
    public static String okNameForRegularGetter(AnnotatedMethod annotatedMethod, String string, boolean bl) {
        if (string.startsWith("get")) {
            if ("getCallbacks".equals(string) ? BeanUtil.isCglibGetCallbacks(annotatedMethod) : "getMetaClass".equals(string) && BeanUtil.isGroovyMetaClassGetter(annotatedMethod)) {
                return null;
            }
            return bl ? BeanUtil.stdManglePropertyName(string, 3) : BeanUtil.legacyManglePropertyName(string, 3);
        }
        return null;
    }

    @Deprecated
    public static String okNameForIsGetter(AnnotatedMethod serializable, String string, boolean bl) {
        if (string.startsWith("is") && ((serializable = serializable.getRawType()) == Boolean.class || serializable == Boolean.TYPE)) {
            return bl ? BeanUtil.stdManglePropertyName(string, 2) : BeanUtil.legacyManglePropertyName(string, 2);
        }
        return null;
    }

    @Deprecated
    public static String okNameForSetter(AnnotatedMethod annotatedMethod, boolean bl) {
        return BeanUtil.okNameForMutator(annotatedMethod, "set", bl);
    }

    @Deprecated
    public static String okNameForMutator(AnnotatedMethod object, String string, boolean bl) {
        if (((String)(object = ((AnnotatedMethod)object).getName())).startsWith(string)) {
            return bl ? BeanUtil.stdManglePropertyName((String)object, string.length()) : BeanUtil.legacyManglePropertyName((String)object, string.length());
        }
        return null;
    }

    public static Object getDefaultValue(JavaType javaType) {
        Class<?> clazz = javaType.getRawClass();
        Class<?> clazz2 = ClassUtil.primitiveType(clazz);
        if (clazz2 != null) {
            return ClassUtil.defaultValue(clazz2);
        }
        if (!javaType.isContainerType() && !javaType.isReferenceType()) {
            if (clazz == String.class) {
                return "";
            }
            if (javaType.isTypeOrSubTypeOf(Date.class)) {
                return new Date(0L);
            }
            if (javaType.isTypeOrSubTypeOf(Calendar.class)) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTimeInMillis(0L);
                return gregorianCalendar;
            }
            return null;
        }
        return JsonInclude.Include.NON_EMPTY;
    }

    public static boolean isCglibGetCallbacks(AnnotatedMethod object) {
        if (((Class)(object = ((AnnotatedMethod)object).getRawType())).isArray() && ((String)(object = ((Class)object).getComponentType().getName())).contains(".cglib")) {
            return ((String)object).startsWith("net.sf.cglib") || ((String)object).startsWith("org.hibernate.repackage.cglib") || ((String)object).startsWith("org.springframework.cglib");
        }
        return false;
    }

    public static boolean isGroovyMetaClassGetter(AnnotatedMethod annotatedMethod) {
        return annotatedMethod.getRawType().getName().startsWith("groovy.lang");
    }

    public static String legacyManglePropertyName(String string, int n2) {
        StringBuilder stringBuilder;
        int n3 = string.length();
        if (n3 == n2) {
            return null;
        }
        char c2 = string.charAt(n2);
        char c3 = Character.toLowerCase(c2);
        if (c2 == c3) {
            return string.substring(n2);
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2(n3 - n2);
        stringBuilder.append(c3);
        ++n2;
        while (n2 < n3) {
            char c4 = string.charAt(n2);
            c3 = Character.toLowerCase(c4);
            if (c4 == c3) {
                stringBuilder2.append(string, n2, n3);
                break;
            }
            stringBuilder2.append(c3);
            ++n2;
        }
        return stringBuilder2.toString();
    }

    public static String stdManglePropertyName(String string, int n2) {
        StringBuilder stringBuilder;
        int n3 = string.length();
        if (n3 == n2) {
            return null;
        }
        char c2 = string.charAt(n2);
        char c3 = Character.toLowerCase(c2);
        if (c2 == c3) {
            return string.substring(n2);
        }
        int n4 = n2 + 1;
        if (n4 < n3 && Character.isUpperCase(string.charAt(n4))) {
            return string.substring(n2);
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2(n3 - n2);
        stringBuilder2.append(c3);
        stringBuilder.append(string, n4, n3);
        return stringBuilder.toString();
    }

    public static String checkUnsupportedType(JavaType javaType) {
        block6: {
            String string;
            String string2;
            block5: {
                block4: {
                    string2 = javaType.getRawClass().getName();
                    if (!BeanUtil.isJava8TimeClass(string2)) break block4;
                    if (string2.indexOf(46, 10) >= 0) {
                        return null;
                    }
                    string2 = "Java 8 date/time";
                    string = "com.privatefasterxml.jackson.datatype:jackson-datatype-jsr310";
                    break block5;
                }
                if (!BeanUtil.isJodaTimeClass(string2)) break block6;
                string2 = "Joda date/time";
                string = "com.privatefasterxml.jackson.datatype:jackson-datatype-joda";
            }
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = string2;
            objectArray[1] = ClassUtil.getTypeDescription(javaType);
            objectArray[2] = string;
            return String.format("%s type %s not supported by default: add Module \"%s\" to enable handling", objectArray2);
        }
        return null;
    }

    public static boolean isJava8TimeClass(Class<?> clazz) {
        return BeanUtil.isJava8TimeClass(clazz.getName());
    }

    private static boolean isJava8TimeClass(String string) {
        return string.startsWith("java.time.");
    }

    public static boolean isJodaTimeClass(Class<?> clazz) {
        return BeanUtil.isJodaTimeClass(clazz.getName());
    }

    private static boolean isJodaTimeClass(String string) {
        return string.startsWith("org.joda.time.");
    }
}

