/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.util;

import com.applitools.android.common.a;
import com.privatefasterxml.jackson.core.JacksonException;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.privatefasterxml.jackson.databind.annotation.NoClass;
import com.privatefasterxml.jackson.databind.util.Named;
import com.privatefasterxml.jackson.databind.util.b;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ClassUtil {
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final Ctor[] NO_CTORS = new Ctor[0];
    private static final Iterator<?> EMPTY_ITERATOR = Collections.emptyIterator();

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static List<JavaType> findSuperTypes(JavaType javaType, Class<?> clazz, boolean bl) {
        if (javaType != null && !javaType.hasRawClass(clazz) && !javaType.hasRawClass(Object.class)) {
            ArrayList<JavaType> arrayList;
            ArrayList<JavaType> arrayList2 = arrayList;
            arrayList2(8);
            ClassUtil._addSuperTypes(javaType, clazz, arrayList2, bl);
            return arrayList;
        }
        return Collections.emptyList();
    }

    public static List<Class<?>> findRawSuperTypes(Class<?> clazz, Class<?> clazz2, boolean bl) {
        if (clazz != null && clazz != clazz2 && clazz != Object.class) {
            ArrayList<Class<?>> arrayList;
            ArrayList<Class<?>> arrayList2 = arrayList;
            arrayList2(8);
            ClassUtil._addRawSuperTypes(clazz, clazz2, arrayList2, bl);
            return arrayList;
        }
        return Collections.emptyList();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static List<Class<?>> findSuperClasses(Class<?> clazz, Class<?> clazz2, boolean bl) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList(8);
        if (clazz == null) return arrayList2;
        if (clazz == clazz2) return arrayList2;
        if (bl) {
            arrayList2.add(clazz);
        }
        while ((clazz = clazz.getSuperclass()) != null) {
            if (clazz == clazz2) {
                return arrayList2;
            }
            arrayList2.add(clazz);
        }
        return arrayList2;
    }

    @Deprecated
    public static List<Class<?>> findSuperTypes(Class<?> serializable, Class<?> clazz) {
        ArrayList arrayList;
        Class<?> clazz2 = serializable;
        serializable = arrayList;
        arrayList = new ArrayList(8);
        return ClassUtil.findSuperTypes(clazz2, clazz, serializable);
    }

    @Deprecated
    public static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2, List<Class<?>> list) {
        ClassUtil._addRawSuperTypes(clazz, clazz2, list, false);
        return list;
    }

    private static void _addSuperTypes(JavaType javaType, Class<?> clazz, Collection<JavaType> collection, boolean bl) {
        if (javaType == null) {
            return;
        }
        Class<?> clazz2 = javaType.getRawClass();
        if (clazz2 != clazz && clazz2 != Object.class) {
            if (bl) {
                if (collection.contains(javaType)) {
                    return;
                }
                collection.add(javaType);
            }
            Iterator<JavaType> iterator = javaType.getInterfaces().iterator();
            while (iterator.hasNext()) {
                ClassUtil._addSuperTypes(iterator.next(), clazz, collection, true);
            }
            ClassUtil._addSuperTypes(javaType.getSuperClass(), clazz, collection, true);
            return;
        }
    }

    private static void _addRawSuperTypes(Class<?> clazz, Class<?> clazz2, Collection<Class<?>> collection, boolean bl) {
        if (clazz != clazz2 && clazz != null && clazz != Object.class) {
            if (bl) {
                if (collection.contains(clazz)) {
                    return;
                }
                collection.add(clazz);
            }
            Class<?>[] classArray = ClassUtil._interfaces(clazz);
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ClassUtil._addRawSuperTypes(classArray[i2], clazz2, collection, true);
            }
            ClassUtil._addRawSuperTypes(clazz.getSuperclass(), clazz2, collection, true);
            return;
        }
    }

    public static String canBeABeanType(Class<?> clazz) {
        if (clazz.isAnnotation()) {
            return "annotation";
        }
        if (clazz.isArray()) {
            return "array";
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return "enum";
        }
        if (clazz.isPrimitive()) {
            return "primitive";
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String isLocalType(Class<?> clazz, boolean bl) {
        boolean bl2;
        block5: {
            try {
                bl2 = Modifier.isStatic(clazz.getModifiers());
                if (bl2) break block5;
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
            catch (SecurityException securityException) {
                return null;
            }
            {
                if (!ClassUtil.hasEnclosingMethod(clazz)) break block5;
                return "local/anonymous";
            }
        }
        if (bl) return null;
        if (bl2) return null;
        {
            if (ClassUtil.getEnclosingClass(clazz) == null) return null;
            return "non-static member class";
        }
    }

    public static Class<?> getOuterClass(Class<?> clazz) {
        if (!Modifier.isStatic(clazz.getModifiers())) {
            block4: {
                try {
                    if (!ClassUtil.hasEnclosingMethod(clazz)) break block4;
                    return null;
                }
                catch (SecurityException securityException) {}
            }
            return ClassUtil.getEnclosingClass(clazz);
        }
        return null;
    }

    public static boolean isProxyType(Class<?> object) {
        return ((String)(object = ((Class)object).getName())).startsWith("net.sf.cglib.proxy.") || ((String)object).startsWith("org.hibernate.proxy.");
        {
        }
    }

    public static boolean isConcrete(Class<?> clazz) {
        return (clazz.getModifiers() & 0x600) == 0;
    }

    public static boolean isConcrete(Member member) {
        return (member.getModifiers() & 0x600) == 0;
    }

    public static boolean isCollectionMapOrArray(Class<?> clazz) {
        if (clazz.isArray()) {
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Map.class.isAssignableFrom(clazz);
    }

    public static boolean isBogusClass(Class<?> clazz) {
        return clazz == Void.class || clazz == Void.TYPE || clazz == NoClass.class;
    }

    public static boolean isRecordType(Class<?> clazz) {
        return (clazz = clazz.getSuperclass()) != null && "java.lang.Record".equals(clazz.getName());
    }

    public static boolean isObjectOrPrimitive(Class<?> clazz) {
        return clazz == CLS_OBJECT || clazz.isPrimitive();
    }

    public static boolean hasClass(Object object, Class<?> clazz) {
        return object != null && object.getClass() == clazz;
    }

    public static void verifyMustOverride(Class<?> clazz, Object object, String string) {
        if (object.getClass() == clazz) {
            return;
        }
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = object.getClass().getName();
        objectArray[1] = clazz.getName();
        objectArray[2] = string;
        throw new IllegalStateException(String.format("Sub-class %s (of class %s) must override method '%s'", objectArray2));
    }

    @Deprecated
    public static boolean hasGetterSignature(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray != null && classArray.length != 0) {
            return false;
        }
        return Void.TYPE != method.getReturnType();
    }

    public static Throwable throwIfError(Throwable throwable) {
        if (!(throwable instanceof Error)) {
            return throwable;
        }
        throw (Error)throwable;
    }

    public static Throwable throwIfRTE(Throwable throwable) {
        if (!(throwable instanceof RuntimeException)) {
            return throwable;
        }
        throw (RuntimeException)throwable;
    }

    public static Throwable throwIfIOE(Throwable throwable) {
        if (!(throwable instanceof IOException)) {
            return throwable;
        }
        throw (IOException)throwable;
    }

    public static Throwable getRootCause(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static Throwable throwRootCauseIfIOE(Throwable throwable) {
        return ClassUtil.throwIfIOE(ClassUtil.getRootCause(throwable));
    }

    public static void throwAsIAE(Throwable throwable) {
        Throwable throwable2 = throwable;
        ClassUtil.throwAsIAE(throwable2, throwable2.getMessage());
    }

    public static void throwAsIAE(Throwable throwable, String string) {
        Throwable throwable2 = throwable;
        ClassUtil.throwIfRTE(throwable2);
        ClassUtil.throwIfError(throwable2);
        throw new IllegalArgumentException(string, throwable);
    }

    public static <T> T throwAsMappingException(DeserializationContext deserializationContext, IOException iOException) {
        if (iOException instanceof JsonMappingException) {
            throw (JsonMappingException)iOException;
        }
        throw JsonMappingException.from(deserializationContext, iOException.getMessage()).withCause(iOException);
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable) {
        ClassUtil.throwAsIAE(ClassUtil.getRootCause(throwable));
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable, String string) {
        ClassUtil.throwAsIAE(ClassUtil.getRootCause(throwable), string);
    }

    public static void closeOnFailAndThrowAsIOE(JsonGenerator jsonGenerator, Exception exception) {
        JsonGenerator jsonGenerator2 = jsonGenerator;
        jsonGenerator2.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
        try {
            jsonGenerator2.close();
        }
        catch (Exception exception2) {
            exception.addSuppressed(exception2);
        }
        Exception exception3 = exception;
        ClassUtil.throwIfIOE(exception3);
        ClassUtil.throwIfRTE(exception3);
        throw new RuntimeException(exception);
    }

    public static void closeOnFailAndThrowAsIOE(JsonGenerator jsonGenerator, Closeable closeable, Exception exception) {
        if (jsonGenerator != null) {
            JsonGenerator jsonGenerator2 = jsonGenerator;
            jsonGenerator2.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
            try {
                jsonGenerator2.close();
            }
            catch (Exception exception2) {
                exception.addSuppressed(exception2);
            }
        }
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception3) {
                exception.addSuppressed(exception3);
            }
        }
        Exception exception4 = exception;
        ClassUtil.throwIfIOE(exception4);
        ClassUtil.throwIfRTE(exception4);
        throw new RuntimeException(exception);
    }

    public static <T> T createInstance(Class<T> clazz, boolean bl) {
        Constructor<T> constructor = ClassUtil.findConstructor(clazz, bl);
        if (constructor != null) {
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                ClassUtil.unwrapAndThrowAsIAE(exception, "Failed to instantiate class " + clazz.getName() + ", problem: " + exception.getMessage());
                return null;
            }
        }
        throw new IllegalArgumentException(a.a(clazz, new StringBuilder("Class "), " has no default (no arg) constructor"));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> Constructor<T> findConstructor(Class<T> clazz, boolean bl) {
        Exception exception2;
        block7: {
            Constructor<T> constructor;
            String string = "Default constructor for ";
            try {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
                if (bl) {
                    ClassUtil.checkAndFixAccess(constructor, bl);
                    return constructor;
                }
            }
            catch (Exception exception2) {
                break block7;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
            {
                if (Modifier.isPublic(constructor.getModifiers())) {
                    return constructor;
                }
                {
                    IllegalArgumentException illegalArgumentException;
                    illegalArgumentException(string + clazz.getName() + " is not accessible (non-public?): not allowed to try modify access via Reflection: cannot instantiate type");
                    throw illegalArgumentException;
                }
            }
        }
        ClassUtil.unwrapAndThrowAsIAE(exception2, "Failed to find default constructor of class " + clazz.getName() + ", problem: " + exception2.getMessage());
        return null;
    }

    public static Class<?> classOf(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass();
    }

    public static Class<?> rawClass(JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        return javaType.getRawClass();
    }

    public static <T> T nonNull(T t2, T t3) {
        if (t2 == null) {
            t2 = t3;
        }
        return t2;
    }

    public static String nullOrToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static String nonNullString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static String quotedOr(Object object, String objectArray) {
        if (object == null) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = object;
        return String.format("\"%s\"", objectArray);
    }

    public static String getClassDescription(Object object) {
        if (object == null) {
            return "unknown";
        }
        return ClassUtil.nameOf(object instanceof Class ? (Class<?>)object : object.getClass());
    }

    public static String getTypeDescription(JavaType javaType) {
        if (javaType == null) {
            return "[null]";
        }
        StringBuilder stringBuilder = new StringBuilder(80).append('`');
        stringBuilder.append(javaType.toCanonical());
        return stringBuilder.append('`').toString();
    }

    public static String classNameOf(Object object) {
        if (object == null) {
            return "[null]";
        }
        return ClassUtil.nameOf(object instanceof Class ? (Class<?>)object : object.getClass());
    }

    public static String nameOf(Class<?> object) {
        if (object == null) {
            return "[null]";
        }
        int n2 = 0;
        while (((Class)object).isArray()) {
            ++n2;
            object = ((Class)object).getComponentType();
        }
        object = ((Class)object).isPrimitive() ? ((Class)object).getSimpleName() : ((Class)object).getName();
        if (n2 > 0) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder((String)object);
            do {
                stringBuilder2.append("[]");
            } while ((n2 += -1) > 0);
            object = stringBuilder2.toString();
        }
        return ClassUtil.backticked((String)object);
    }

    public static String nameOf(Named named) {
        if (named == null) {
            return "[null]";
        }
        return ClassUtil.apostrophed(named.getName());
    }

    public static String name(String string) {
        if (string == null) {
            return "[null]";
        }
        return ClassUtil.apostrophed(string);
    }

    public static String name(PropertyName propertyName) {
        if (propertyName == null) {
            return "[null]";
        }
        return ClassUtil.apostrophed(propertyName.getSimpleName());
    }

    public static String backticked(String string) {
        if (string == null) {
            return "[null]";
        }
        return new StringBuilder(string.length() + 2).append('`').append(string).append('`').toString();
    }

    public static String apostrophed(String string) {
        if (string == null) {
            return "[null]";
        }
        return new StringBuilder(string.length() + 2).append('\'').append(string).append('\'').toString();
    }

    public static String exceptionMessage(Throwable throwable) {
        if (throwable instanceof JacksonException) {
            return ((JacksonException)throwable).getOriginalMessage();
        }
        if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            return throwable.getCause().getMessage();
        }
        return throwable.getMessage();
    }

    public static Object defaultValue(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        throw new IllegalArgumentException(a.a(clazz, new StringBuilder("Class "), " is not a primitive type"));
    }

    public static Class<?> wrapperType(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException(a.a(clazz, new StringBuilder("Class "), " is not a primitive type"));
    }

    public static Class<?> primitiveType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        return null;
    }

    @Deprecated
    public static void checkAndFixAccess(Member member) {
        ClassUtil.checkAndFixAccess(member, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkAndFixAccess(Member member, boolean bl) {
        SecurityException securityException2;
        Object[] objectArray;
        block6: {
            RuntimeException runtimeException2;
            block5: {
                block4: {
                    Member member2 = member;
                    objectArray = (AccessibleObject)((Object)member2);
                    try {
                        Class<?> clazz = member2.getDeclaringClass();
                        if (!Modifier.isPublic(member2.getModifiers()) || !Modifier.isPublic(clazz.getModifiers())) break block4;
                        if (!bl) return;
                        if (ClassUtil.isJDKClass(clazz)) return;
                    }
                    catch (RuntimeException runtimeException2) {
                        break block5;
                    }
                    catch (SecurityException securityException2) {
                        break block6;
                    }
                }
                objectArray.setAccessible(true);
                return;
            }
            if (!"InaccessibleObjectException".equals(runtimeException2.getClass().getSimpleName())) throw runtimeException2;
            Object[] objectArray2 = new Object[5];
            objectArray = objectArray2;
            objectArray[0] = member.getClass().getSimpleName();
            objectArray[1] = member.getName();
            objectArray[2] = ClassUtil.nameOf(member.getDeclaringClass());
            objectArray[3] = runtimeException2.getClass().getName();
            objectArray2[4] = runtimeException2.getMessage();
            throw new IllegalArgumentException(String.format("Failed to call `setAccess()` on %s '%s' (of class %s) due to `%s`, problem: %s", objectArray), runtimeException2);
        }
        if (objectArray.isAccessible()) {
            return;
        }
        objectArray = member.getDeclaringClass();
        throw new IllegalArgumentException("Cannot access " + member + " (from class " + objectArray.getName() + "; failed to set access: " + securityException2.getMessage());
    }

    public static boolean isEnumType(Class<?> clazz) {
        return Enum.class.isAssignableFrom(clazz);
    }

    public static Class<? extends Enum<?>> findEnumType(EnumSet<?> enumSet) {
        if (!enumSet.isEmpty()) {
            return ClassUtil.findEnumType((Enum)enumSet.iterator().next());
        }
        b b2 = b.e;
        Field field = b2.a;
        if (field != null) {
            try {
                return (Class)field.get(enumSet);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        throw new IllegalStateException("Cannot figure out type parameter for `EnumSet` (odd JDK platform?), problem: " + b2.c);
    }

    public static Class<? extends Enum<?>> findEnumType(EnumMap<?, ?> enumMap) {
        if (!enumMap.isEmpty()) {
            return ClassUtil.findEnumType((Enum)enumMap.keySet().iterator().next());
        }
        b b2 = b.e;
        Field field = b2.b;
        if (field != null) {
            try {
                return (Class)field.get(enumMap);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        throw new IllegalStateException("Cannot figure out type parameter for `EnumMap` (odd JDK platform?), problem: " + b2.d);
    }

    public static Class<? extends Enum<?>> findEnumType(Enum<?> enum_) {
        return enum_.getDeclaringClass();
    }

    public static Class<? extends Enum<?>> findEnumType(Class<?> clazz) {
        if (clazz.getSuperclass() != Enum.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static <T extends Annotation> Enum<?> findFirstAnnotatedEnumValue(Class<Enum<?>> clazz, Class<T> clazz2) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isEnumConstant() || field.getAnnotation(clazz2) == null) continue;
            String string = field.getName();
            for (Enum<?> enum_ : clazz.getEnumConstants()) {
                if (!string.equals(enum_.name())) continue;
                return enum_;
            }
        }
        return null;
    }

    public static boolean isJacksonStdImpl(Object object) {
        return object == null || ClassUtil.isJacksonStdImpl(object.getClass());
    }

    public static boolean isJacksonStdImpl(Class<?> clazz) {
        return clazz.getAnnotation(JacksonStdImpl.class) != null;
    }

    public static boolean isJDKClass(Class<?> object) {
        return ((String)(object = ((Class)object).getName())).startsWith("java.") || ((String)object).startsWith("javax.");
    }

    public static boolean isNonStaticInnerClass(Class<?> clazz) {
        return !Modifier.isStatic(clazz.getModifiers()) && ClassUtil.getEnclosingClass(clazz) != null;
    }

    @Deprecated
    public static String getPackageName(Class<?> annotatedElement) {
        return (annotatedElement = ((Class)annotatedElement).getPackage()) == null ? null : ((Package)annotatedElement).getName();
    }

    public static boolean hasEnclosingMethod(Class<?> clazz) {
        return !ClassUtil.isObjectOrPrimitive(clazz) && clazz.getEnclosingMethod() != null;
    }

    @Deprecated
    public static Field[] getDeclaredFields(Class<?> clazz) {
        return clazz.getDeclaredFields();
    }

    @Deprecated
    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return clazz.getDeclaredMethods();
    }

    public static Annotation[] findClassAnnotations(Class<?> clazz) {
        if (ClassUtil.isObjectOrPrimitive(clazz)) {
            return NO_ANNOTATIONS;
        }
        return clazz.getDeclaredAnnotations();
    }

    public static Method[] getClassMethods(Class<?> clazz) {
        try {
            return clazz.getDeclaredMethods();
        }
        catch (Throwable throwable) {
            return ClassUtil._failGetClassMethods(clazz, throwable);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Class<?> clazz2;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                return ClassUtil._failGetClassMethods(clazz, noClassDefFoundError);
            }
            try {
                clazz2 = classLoader.loadClass(clazz.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError2 = noClassDefFoundError;
                noClassDefFoundError2.addSuppressed(classNotFoundException);
                return ClassUtil._failGetClassMethods(clazz, noClassDefFoundError2);
            }
            try {
                return clazz2.getDeclaredMethods();
            }
            catch (Throwable throwable) {
                return ClassUtil._failGetClassMethods(clazz, throwable);
            }
        }
    }

    private static Method[] _failGetClassMethods(Class<?> clazz, Throwable throwable) {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = clazz.getName();
        objectArray2[1] = throwable.getClass().getName();
        objectArray[2] = throwable.getMessage();
        throw new IllegalArgumentException(String.format("Failed on call to `getDeclaredMethods()` on class `%s`, problem: (%s) %s", objectArray2), throwable);
    }

    public static Ctor[] getConstructors(Class<?> constructorArray) {
        if (!constructorArray.isInterface() && !ClassUtil.isObjectOrPrimitive(constructorArray)) {
            constructorArray = constructorArray.getDeclaredConstructors();
            int n2 = constructorArray.length;
            Ctor[] ctorArray = new Ctor[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                Ctor ctor;
                Ctor ctor2 = ctor;
                ctor = new Ctor(constructorArray[i2]);
                ctorArray[i2] = ctor2;
            }
            return ctorArray;
        }
        return NO_CTORS;
    }

    public static Class<?> getDeclaringClass(Class<?> clazz) {
        return ClassUtil.isObjectOrPrimitive(clazz) ? null : clazz.getDeclaringClass();
    }

    public static Type getGenericSuperclass(Class<?> clazz) {
        return clazz.getGenericSuperclass();
    }

    public static Type[] getGenericInterfaces(Class<?> clazz) {
        return clazz.getGenericInterfaces();
    }

    public static Class<?> getEnclosingClass(Class<?> clazz) {
        return ClassUtil.isObjectOrPrimitive(clazz) ? null : clazz.getEnclosingClass();
    }

    private static Class<?>[] _interfaces(Class<?> clazz) {
        return clazz.getInterfaces();
    }

    public static final class Ctor {
        public final Constructor<?> _ctor;
        private transient Annotation[] _annotations;
        private transient Annotation[][] _paramAnnotations;
        private int _paramCount = -1;

        public Ctor(Constructor<?> constructor) {
            this._ctor = constructor;
        }

        public Constructor<?> getConstructor() {
            return this._ctor;
        }

        public int getParamCount() {
            int n2 = this._paramCount;
            if (n2 < 0) {
                this._paramCount = n2 = this._ctor.getParameterCount();
            }
            return n2;
        }

        public Class<?> getDeclaringClass() {
            return this._ctor.getDeclaringClass();
        }

        public Annotation[] getDeclaredAnnotations() {
            Annotation[] annotationArray = this._annotations;
            if (this._annotations == null) {
                annotationArray = this._ctor.getDeclaredAnnotations();
                this._annotations = annotationArray;
            }
            return annotationArray;
        }

        public Annotation[][] getParameterAnnotations() {
            Annotation[][] annotationArray = this._paramAnnotations;
            if (this._paramAnnotations == null) {
                annotationArray = this._ctor.getParameterAnnotations();
                this._paramAnnotations = annotationArray;
            }
            return annotationArray;
        }
    }
}

