/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class CompactStringObjectMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final CompactStringObjectMap EMPTY;
    private final int _hashMask;
    private final int _spillCount;
    private final Object[] _hashArea;

    private CompactStringObjectMap(int n2, int n3, Object[] objectArray) {
        this._hashMask = n2;
        this._spillCount = n3;
        this._hashArea = objectArray;
    }

    public static <T> CompactStringObjectMap construct(Map<String, T> map) {
        if (map.isEmpty()) {
            return EMPTY;
        }
        Map<String, T> map2 = map;
        int n2 = CompactStringObjectMap.findSize(map2.size());
        int n3 = n2 - 1;
        int n4 = n2 + (n2 >> 1);
        Object[] objectArray = new Object[n4 * 2];
        int n5 = 0;
        for (Map.Entry<String, T> entry : map2.entrySet()) {
            String string = entry.getKey();
            if (string == null) continue;
            int n6 = string.hashCode() & n3;
            int n7 = n6 + n6;
            if (objectArray[n7] != null && objectArray[n7 = n2 + (n6 >> 1) << 1] != null) {
                n7 = (n4 << 1) + n5;
                n5 += 2;
                if (n7 >= objectArray.length) {
                    objectArray = Arrays.copyOf(objectArray, objectArray.length + 4);
                }
            }
            objectArray[n7] = string;
            int n8 = n7 + 1;
            objectArray[n8] = entry.getValue();
        }
        return new CompactStringObjectMap(n3, n5, objectArray);
    }

    private static final int findSize(int n2) {
        if (n2 <= 5) {
            return 8;
        }
        if (n2 <= 12) {
            return 16;
        }
        int n3 = n2;
        n2 = n3 + (n3 >> 2);
        int n4 = 32;
        while (n4 < n2) {
            int n5 = n4;
            n4 = n5 + n5;
        }
        return n4;
    }

    private final Object _find2(String string, int n2, Object object) {
        if (object == null) {
            return null;
        }
        CompactStringObjectMap compactStringObjectMap = this;
        int n3 = compactStringObjectMap._hashMask + 1;
        Object object2 = compactStringObjectMap._hashArea[n2 = n3 + (n2 >> 1) << 1];
        if (string.equals(object2)) {
            return this._hashArea[n2 + 1];
        }
        if (object2 != null) {
            int n4 = n3;
            n3 = n2 + this._spillCount;
            for (n2 = (v331771) + ((v331771) >> 1) << 1; n2 < n3; n2 += 2) {
                object2 = this._hashArea[n2];
                if (object2 != string && !string.equals(object2)) {
                    continue;
                }
                return this._hashArea[n2 + 1];
            }
        }
        return null;
    }

    static {
        Object[] objectArray = new Object[4];
        EMPTY = new CompactStringObjectMap(1, 0, objectArray);
    }

    public Object find(String string) {
        int n2 = string.hashCode() & this._hashMask;
        int n3 = n2 << 1;
        Object object = this._hashArea[n3];
        if (object != string && !string.equals(object)) {
            return this._find2(string, n2, object);
        }
        return this._hashArea[n3 + 1];
    }

    public Object findCaseInsensitive(String string) {
        int n2 = this._hashArea.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            Object object = this._hashArea[i2];
            if (object == null || !((String)object).equalsIgnoreCase(string)) continue;
            return this._hashArea[i2 + 1];
        }
        return null;
    }

    public List<String> keys() {
        ArrayList<String> arrayList;
        int n2 = this._hashArea.length;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(n2 >> 2);
        for (int i2 = 0; i2 < n2; i2 += 2) {
            Object object = this._hashArea[i2];
            if (object == null) continue;
            arrayList2.add((String)object);
        }
        return arrayList2;
    }
}

